/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.pipez;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.maxhenkel.pipez.DirectionalPosition;
import de.maxhenkel.pipez.Filter;
import de.maxhenkel.pipez.corelib.tag.SingleElementTag;
import de.maxhenkel.pipez.corelib.tag.Tag;
import de.maxhenkel.pipez.utils.ChemicalTag;
import de.maxhenkel.pipez.utils.MekanismUtils;
import java.util.UUID;
import javax.annotation.Nullable;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.Chemical;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.Identifier;

public class GasFilter
extends Filter<GasFilter, Chemical> {
    private static final Codec<ChemicalTagData> TAG_DATA_CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.STRING.fieldOf("type").xmap(Filter.TagType::valueOf, Enum::name).forGetter(ChemicalTagData::tagType), (App)Identifier.CODEC.fieldOf("tag").forGetter(ChemicalTagData::location)).apply((Applicative)i, ChemicalTagData::new));
    private static final StreamCodec<RegistryFriendlyByteBuf, ChemicalTagData> TAG_DATA_STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BOOL, ChemicalTagData::isSingle, (StreamCodec)Identifier.STREAM_CODEC, ChemicalTagData::location, ChemicalTagData::new);
    private static final Codec<Tag<Chemical>> TAG_CODEC = TAG_DATA_CODEC.xmap(data -> {
        if (!MekanismUtils.isMekanismInstalled()) {
            return null;
        }
        if (data.isSingle()) {
            if (MekanismAPI.CHEMICAL_REGISTRY.containsKey(data.location)) {
                return null;
            }
            return null;
        }
        return null;
    }, tag -> {
        if (tag instanceof SingleElementTag) {
            SingleElementTag t = (SingleElementTag)tag;
            return new ChemicalTagData(Filter.TagType.SINGLE, t.getName());
        }
        if (tag instanceof ChemicalTag) {
            ChemicalTag gasTag = (ChemicalTag)tag;
            return new ChemicalTagData(Filter.TagType.TAG, gasTag.getName());
        }
        return null;
    });
    public static final StreamCodec<RegistryFriendlyByteBuf, Tag<Chemical>> STREAM_TAG_CODEC = TAG_DATA_STREAM_CODEC.map(data -> {
        if (data.isSingle()) {
            if (MekanismAPI.CHEMICAL_REGISTRY.containsKey(data.location)) {
                return null;
            }
            return null;
        }
        return null;
    }, tag -> {
        if (tag instanceof SingleElementTag) {
            SingleElementTag t = (SingleElementTag)tag;
            return new ChemicalTagData(Filter.TagType.SINGLE, t.getName());
        }
        if (tag instanceof ChemicalTag) {
            ChemicalTag gasTag = (ChemicalTag)tag;
            return new ChemicalTagData(Filter.TagType.TAG, gasTag.getName());
        }
        return null;
    });
    public static final Codec<GasFilter> CODEC = GasFilter.codec(GasFilter.class, TAG_CODEC);
    public static final StreamCodec<RegistryFriendlyByteBuf, GasFilter> STREAM_CODEC = GasFilter.streamCodec(GasFilter.class, STREAM_TAG_CODEC);

    public GasFilter(UUID id, @Nullable Tag<Chemical> tag, @Nullable CompoundTag metadata, boolean exactMetadata, @Nullable DirectionalPosition destination, boolean invert) {
        super(id, tag, metadata, exactMetadata, destination, invert);
    }

    public GasFilter() {
        this(UUID.randomUUID(), (Tag<Chemical>)null, (CompoundTag)null, false, (DirectionalPosition)null, false);
    }

    @Override
    public Codec<GasFilter> getCodec() {
        return CODEC;
    }

    @Override
    public StreamCodec<RegistryFriendlyByteBuf, GasFilter> getStreamCodec() {
        return STREAM_CODEC;
    }

    protected record ChemicalTagData(Filter.TagType tagType, Identifier location) {
        public ChemicalTagData(boolean single, Identifier location) {
            this(single ? Filter.TagType.SINGLE : Filter.TagType.TAG, location);
        }

        public boolean isSingle() {
            return this.tagType == Filter.TagType.SINGLE;
        }
    }
}

