/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.pipez.blocks.tileentity.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import de.maxhenkel.pipez.ModelRegistry;
import de.maxhenkel.pipez.blocks.tileentity.PipeTileEntity;
import de.maxhenkel.pipez.blocks.tileentity.render.PipeRenderState;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.rendertype.RenderTypes;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.QuadCollection;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public abstract class PipeRenderer
implements BlockEntityRenderer<PipeTileEntity, PipeRenderState> {
    protected Minecraft minecraft;
    protected BlockEntityRendererProvider.Context renderer;
    protected AtomicReference<QuadCollection> cachedModel;

    public PipeRenderer(BlockEntityRendererProvider.Context renderer) {
        this.renderer = renderer;
        this.minecraft = Minecraft.getInstance();
        this.cachedModel = this.getModel().getModel();
    }

    public PipeRenderState createRenderState() {
        return new PipeRenderState();
    }

    public void extractRenderState(PipeTileEntity entity, PipeRenderState state, float partialTicks, Vec3 pos, @Nullable ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        super.extractRenderState((BlockEntity)entity, (BlockEntityRenderState)state, partialTicks, pos, crumblingOverlay);
        for (Direction side : Direction.values()) {
            state.extracting[side.ordinal()] = entity.isExtracting(side);
        }
    }

    public void submit(PipeRenderState state, PoseStack stack, SubmitNodeCollector collector, CameraRenderState cameraRenderState) {
        QuadCollection model = this.cachedModel.get();
        if (model == null) {
            return;
        }
        for (Direction side : Direction.values()) {
            if (!state.extracting[side.ordinal()]) continue;
            this.renderExtractor(model, side, stack, collector, state.lightCoords, OverlayTexture.NO_OVERLAY);
        }
    }

    private void renderExtractor(QuadCollection model, Direction direction, PoseStack stack, SubmitNodeCollector collector, int combinedLight, int combinedOverlay) {
        stack.pushPose();
        stack.translate((double)direction.getStepX() * 0.001, (double)direction.getStepY() * 0.001, (double)direction.getStepZ() * 0.001);
        stack.translate(0.5, 0.5, 0.5);
        stack.mulPose((Quaternionfc)this.getRotation(direction));
        stack.translate(-0.5, -0.5, -0.5);
        List quads = model.getQuads(null);
        collector.submitCustomGeometry(stack, RenderTypes.solidMovingBlock(), (pose, vertexConsumer) -> {
            for (BakedQuad quad : quads) {
                vertexConsumer.putBulkData(pose, quad, 1.0f, 1.0f, 1.0f, 1.0f, combinedLight, combinedOverlay);
            }
        });
        stack.popPose();
    }

    private Quaternionf getRotation(Direction direction) {
        Quaternionf q = new Quaternionf();
        switch (direction) {
            case NORTH: {
                return q;
            }
            case SOUTH: {
                q.mul((Quaternionfc)Axis.YP.rotationDegrees(180.0f));
                return q;
            }
            case WEST: {
                q.mul((Quaternionfc)Axis.YP.rotationDegrees(90.0f));
                return q;
            }
            case EAST: {
                q.mul((Quaternionfc)Axis.YP.rotationDegrees(270.0f));
                return q;
            }
            case UP: {
                q.mul((Quaternionfc)Axis.XP.rotationDegrees(90.0f));
                return q;
            }
        }
        q.mul((Quaternionfc)Axis.XP.rotationDegrees(270.0f));
        return q;
    }

    abstract ModelRegistry.Model getModel();
}

