/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.pipez.gui;

import de.maxhenkel.pipez.Filter;
import de.maxhenkel.pipez.FluidFilter;
import de.maxhenkel.pipez.ItemFilter;
import de.maxhenkel.pipez.Upgrade;
import de.maxhenkel.pipez.blocks.tileentity.PipeLogicTileEntity;
import de.maxhenkel.pipez.blocks.tileentity.types.PipeType;
import de.maxhenkel.pipez.corelib.inventory.ScreenBase;
import de.maxhenkel.pipez.corelib.tag.SingleElementTag;
import de.maxhenkel.pipez.gui.CycleIconButton;
import de.maxhenkel.pipez.gui.ExtractContainer;
import de.maxhenkel.pipez.gui.FilterList;
import de.maxhenkel.pipez.gui.UpgradeSlot;
import de.maxhenkel.pipez.net.CycleDistributionMessage;
import de.maxhenkel.pipez.net.CycleFilterModeMessage;
import de.maxhenkel.pipez.net.CycleRedstoneModeMessage;
import de.maxhenkel.pipez.net.EditFilterMessage;
import de.maxhenkel.pipez.net.RemoveFilterMessage;
import de.maxhenkel.pipez.net.UpdateFilterMessage;
import de.maxhenkel.pipez.utils.NbtUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.Identifier;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.client.network.ClientPacketDistributor;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.transfer.fluid.FluidUtil;

public class ExtractScreen
extends ScreenBase<ExtractContainer> {
    public static final Identifier BACKGROUND = Identifier.fromNamespaceAndPath((String)"pipez", (String)"textures/gui/container/extract.png");
    private CycleIconButton redstoneButton;
    private CycleIconButton sortButton;
    private CycleIconButton filterButton;
    private Button addFilterButton;
    private Button editFilterButton;
    private Button removeFilterButton;
    private ScreenBase.HoverArea redstoneArea;
    private ScreenBase.HoverArea sortArea;
    private ScreenBase.HoverArea filterArea;
    private ScreenBase.HoverArea[] tabs;
    private PipeType<?, ?>[] pipeTypes;
    private int currentindex;
    private FilterList filterList;

    public ExtractScreen(ExtractContainer container, Inventory playerInventory, Component title) {
        super(BACKGROUND, container, playerInventory, title);
        this.imageWidth = 176;
        this.imageHeight = 196;
        this.pipeTypes = container.getPipe().getPipeTypes();
        if (this.pipeTypes.length > 1) {
            this.tabs = new ScreenBase.HoverArea[this.pipeTypes.length];
        }
        this.currentindex = container.getIndex();
        if (this.currentindex < 0) {
            this.currentindex = ((ExtractContainer)this.getMenu()).getPipe().getPreferredPipeIndex(((ExtractContainer)this.getMenu()).getSide());
        }
    }

    protected void init() {
        super.init();
        this.hoverAreas.clear();
        this.clearWidgets();
        PipeLogicTileEntity pipe = ((ExtractContainer)this.getMenu()).getPipe();
        Direction side = ((ExtractContainer)this.getMenu()).getSide();
        this.filterList = new FilterList(this, 32, 8, 136, 66, () -> pipe.getFilters(side, this.pipeTypes[this.currentindex]));
        Supplier<Integer> redstoneModeIndex = () -> pipe.getRedstoneMode(((ExtractContainer)this.getMenu()).getSide(), this.pipeTypes[this.currentindex]).ordinal();
        List<CycleIconButton.Icon> redstoneModeIcons = Arrays.asList(new CycleIconButton.Icon(BACKGROUND, 176, 16), new CycleIconButton.Icon(BACKGROUND, 192, 16), new CycleIconButton.Icon(BACKGROUND, 208, 16), new CycleIconButton.Icon(BACKGROUND, 224, 16));
        this.redstoneButton = new CycleIconButton(this.leftPos + 7, this.topPos + 7, redstoneModeIcons, redstoneModeIndex, button -> ClientPacketDistributor.sendToServer((CustomPacketPayload)new CycleRedstoneModeMessage(this.currentindex), (CustomPacketPayload[])new CustomPacketPayload[0]));
        Supplier<Integer> distributionIndex = () -> pipe.getDistribution(((ExtractContainer)this.getMenu()).getSide(), this.pipeTypes[this.currentindex]).ordinal();
        List<CycleIconButton.Icon> distributionIcons = Arrays.asList(new CycleIconButton.Icon(BACKGROUND, 176, 0), new CycleIconButton.Icon(BACKGROUND, 192, 0), new CycleIconButton.Icon(BACKGROUND, 208, 0), new CycleIconButton.Icon(BACKGROUND, 224, 0));
        this.sortButton = new CycleIconButton(this.leftPos + 7, this.topPos + 31, distributionIcons, distributionIndex, button -> ClientPacketDistributor.sendToServer((CustomPacketPayload)new CycleDistributionMessage(this.currentindex), (CustomPacketPayload[])new CustomPacketPayload[0]));
        Supplier<Integer> filterModeIndex = () -> this.pipeTypes[this.currentindex].hasFilter() ? pipe.getFilterMode(((ExtractContainer)this.getMenu()).getSide(), this.pipeTypes[this.currentindex]).ordinal() : 0;
        List<CycleIconButton.Icon> filterModeIcons = Arrays.asList(new CycleIconButton.Icon(BACKGROUND, 176, 32), new CycleIconButton.Icon(BACKGROUND, 192, 32));
        this.filterButton = new CycleIconButton(this.leftPos + 7, this.topPos + 55, filterModeIcons, filterModeIndex, button -> ClientPacketDistributor.sendToServer((CustomPacketPayload)new CycleFilterModeMessage(this.currentindex), (CustomPacketPayload[])new CustomPacketPayload[0]));
        this.addFilterButton = Button.builder((Component)Component.translatable((String)"message.pipez.filter.add"), button -> ClientPacketDistributor.sendToServer((CustomPacketPayload)new EditFilterMessage(this.pipeTypes[this.currentindex].createFilter(), this.currentindex), (CustomPacketPayload[])new CustomPacketPayload[0])).bounds(this.leftPos + 31, this.topPos + 79, 40, 20).build();
        this.editFilterButton = Button.builder((Component)Component.translatable((String)"message.pipez.filter.edit"), button -> {
            if (this.filterList.getSelected() >= 0) {
                ClientPacketDistributor.sendToServer((CustomPacketPayload)new EditFilterMessage(pipe.getFilters(side, this.pipeTypes[this.currentindex]).get(this.filterList.getSelected()), this.currentindex), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }).bounds(this.leftPos + 80, this.topPos + 79, 40, 20).build();
        this.removeFilterButton = Button.builder((Component)Component.translatable((String)"message.pipez.filter.remove"), button -> {
            if (this.filterList.getSelected() >= 0) {
                ClientPacketDistributor.sendToServer((CustomPacketPayload)new RemoveFilterMessage(pipe.getFilters(side, this.pipeTypes[this.currentindex]).get(this.filterList.getSelected()).getId(), this.currentindex), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }).bounds(this.leftPos + 129, this.topPos + 79, 40, 20).build();
        this.addRenderableWidget(this.redstoneButton);
        this.addRenderableWidget(this.sortButton);
        this.addRenderableWidget(this.filterButton);
        this.addRenderableWidget(this.addFilterButton);
        this.addRenderableWidget(this.editFilterButton);
        this.addRenderableWidget(this.removeFilterButton);
        if (this.hasTabs()) {
            for (int i = 0; i < this.pipeTypes.length; ++i) {
                int tabIndex = i;
                this.tabs[i] = new ScreenBase.HoverArea(-23, 5 + 25 * i, 24, 24, () -> {
                    ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
                    tooltip.add(Component.translatable((String)this.pipeTypes[tabIndex].getTranslationKey()));
                    return tooltip;
                });
                this.hoverAreas.add(this.tabs[i]);
            }
        }
        this.redstoneArea = new ScreenBase.HoverArea(7, 7, 20, 20, () -> {
            if (this.redstoneButton.active) {
                return Arrays.asList(Component.translatable((String)"tooltip.pipez.redstone_mode", (Object[])new Object[]{Component.translatable((String)("tooltip.pipez.redstone_mode." + pipe.getRedstoneMode(side, this.pipeTypes[this.currentindex]).getName()))}));
            }
            return Collections.emptyList();
        });
        this.sortArea = new ScreenBase.HoverArea(7, 31, 20, 20, () -> {
            if (this.sortButton.active) {
                return Arrays.asList(Component.translatable((String)"tooltip.pipez.distribution", (Object[])new Object[]{Component.translatable((String)("tooltip.pipez.distribution." + pipe.getDistribution(side, this.pipeTypes[this.currentindex]).getName()))}));
            }
            return Collections.emptyList();
        });
        this.filterArea = new ScreenBase.HoverArea(7, 55, 20, 20, () -> {
            if (this.filterButton.active) {
                return Arrays.asList(Component.translatable((String)"tooltip.pipez.filter_mode", (Object[])new Object[]{Component.translatable((String)("tooltip.pipez.filter_mode." + pipe.getFilterMode(side, this.pipeTypes[this.currentindex]).getName()))}));
            }
            return Collections.emptyList();
        });
        this.hoverAreas.add(this.redstoneArea);
        this.hoverAreas.add(this.sortArea);
        this.hoverAreas.add(this.filterArea);
        this.checkButtons();
    }

    protected void containerTick() {
        super.containerTick();
        this.checkButtons();
        this.filterList.tick();
    }

    private void checkButtons() {
        Upgrade upgrade = ((ExtractContainer)this.getMenu()).getPipe().getUpgrade(((ExtractContainer)this.getMenu()).getSide());
        this.redstoneButton.active = Upgrade.canChangeRedstoneMode(upgrade);
        this.sortButton.active = Upgrade.canChangeDistributionMode(upgrade);
        this.addFilterButton.active = this.filterButton.active = Upgrade.canChangeFilter(upgrade) && this.pipeTypes[this.currentindex].hasFilter();
        this.removeFilterButton.active = this.editFilterButton.active = Upgrade.canChangeFilter(upgrade) && this.filterList.getSelected() >= 0;
    }

    @Override
    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.renderLabels(guiGraphics, mouseX, mouseY);
        guiGraphics.drawString(this.font, this.playerInventoryTitle, 8, this.imageHeight - 96 + 3, -12566464, false);
        this.filterList.drawGuiContainerForegroundLayer(guiGraphics, mouseX, mouseY);
    }

    @Override
    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        super.renderBg(guiGraphics, partialTicks, mouseX, mouseY);
        this.filterList.drawGuiContainerBackgroundLayer(guiGraphics, partialTicks, mouseX, mouseY);
        if (this.hasTabs()) {
            int i;
            for (i = 0; i < this.pipeTypes.length; ++i) {
                if (i == this.currentindex) {
                    guiGraphics.blit(RenderPipelines.GUI_TEXTURED, BACKGROUND, this.leftPos - 26 + 3, this.topPos + 5 + 25 * i, 176.0f, 48.0f, 26, 24, 256, 256);
                    continue;
                }
                guiGraphics.blit(RenderPipelines.GUI_TEXTURED, BACKGROUND, this.leftPos - 26 + 3, this.topPos + 5 + 25 * i, 176.0f, 72.0f, 26, 24, 256, 256);
            }
            for (i = 0; i < this.pipeTypes.length; ++i) {
                if (i == this.currentindex) {
                    guiGraphics.renderItem(this.pipeTypes[i].getIcon(), this.leftPos - 26 + 3 + 4, this.topPos + 5 + 25 * i + 4, 0);
                    guiGraphics.renderItemDecorations(this.font, this.pipeTypes[i].getIcon(), this.leftPos - 26 + 3 + 4, this.topPos + 5 + 25 * i + 4);
                    continue;
                }
                guiGraphics.renderItem(this.pipeTypes[i].getIcon(), this.leftPos - 26 + 3 + 4 + 2, this.topPos + 5 + 25 * i + 4, 0);
                guiGraphics.renderItemDecorations(this.font, this.pipeTypes[i].getIcon(), this.leftPos - 26 + 3 + 4 + 2, this.topPos + 5 + 25 * i + 4);
            }
        }
    }

    @Override
    public void render(GuiGraphics guiGraphics, int x, int y, float partialTicks) {
        super.render(guiGraphics, x, y, partialTicks);
        this.drawHoverAreas(guiGraphics, x, y);
    }

    public int getTabsX() {
        return this.leftPos - this.getTabsWidth();
    }

    public int getTabsY() {
        return this.topPos + 5;
    }

    public int getTabsHeight() {
        if (this.hasTabs()) {
            return 25 * this.tabs.length;
        }
        return 0;
    }

    public int getTabsWidth() {
        return 23;
    }

    public boolean hasTabs() {
        return this.tabs != null;
    }

    public boolean mouseClicked(MouseButtonEvent event, boolean b) {
        Slot sl;
        if (this.filterList.mouseClicked(event, b)) {
            return true;
        }
        if (this.hasTabs()) {
            for (int i = 0; i < this.tabs.length; ++i) {
                ScreenBase.HoverArea hoverArea = this.tabs[i];
                if (this.currentindex == i || !hoverArea.isHovered(this.leftPos, this.topPos, (int)event.x(), (int)event.y())) continue;
                this.minecraft.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
                this.currentindex = i;
                this.init();
                return true;
            }
        }
        if (event.hasShiftDown() && (sl = this.getSlotUnderMouse()) != null && !(sl instanceof UpgradeSlot)) {
            this.addQuickFilter(sl.getItem());
        }
        return super.mouseClicked(event, b);
    }

    public void addQuickFilter(ItemStack stack) {
        FluidStack firstStackContained;
        if (stack == null || stack.isEmpty()) {
            return;
        }
        if (!this.filterButton.active) {
            return;
        }
        Filter<?, ?> filter = this.pipeTypes[this.currentindex].createFilter();
        filter.setExactMetadata(true);
        if (filter instanceof ItemFilter) {
            filter.setTag(new SingleElementTag<Item>(BuiltInRegistries.ITEM.getKey((Object)stack.getItem()), stack.getItem()));
            filter.setMetadata(NbtUtils.componentPatchToNbtOptional(stack.getComponentsPatch()).orElse(null));
            ClientPacketDistributor.sendToServer((CustomPacketPayload)new UpdateFilterMessage(filter, this.currentindex), (CustomPacketPayload[])new CustomPacketPayload[0]);
        } else if (filter instanceof FluidFilter && !(firstStackContained = FluidUtil.getFirstStackContained((ItemStack)stack)).isEmpty()) {
            filter.setTag(new SingleElementTag<Fluid>(BuiltInRegistries.FLUID.getKey((Object)firstStackContained.getFluid()), firstStackContained.getFluid()));
            filter.setMetadata(NbtUtils.componentPatchToNbtOptional(stack.getComponentsPatch()).orElse(null));
            ClientPacketDistributor.sendToServer((CustomPacketPayload)new UpdateFilterMessage(filter, this.currentindex), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public boolean mouseReleased(MouseButtonEvent event) {
        if (this.filterList.mouseReleased(event)) {
            return true;
        }
        return super.mouseReleased(event);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double deltaX, double deltaY) {
        return this.filterList.mouseScrolled(mouseX, mouseY, deltaX, deltaY);
    }

    public <T extends GuiEventListener & Renderable> T addRenderableWidget(T widget) {
        return (T)super.addRenderableWidget(widget);
    }

    public void addHoverArea(ScreenBase.HoverArea hoverArea) {
        this.hoverAreas.add(hoverArea);
    }
}

