/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.universal;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.level.ItemLike;
import org.jspecify.annotations.Nullable;
import snownee.jade.addon.universal.ItemIterator;
import snownee.jade.api.Accessor;
import snownee.jade.api.view.ViewGroup;

public class ItemCollector<T> {
    public static final int MAX_SIZE = 54;
    public static final ItemCollector<?> EMPTY = new ItemCollector(null);
    private static final CompoundTag IGNORED_TAG = new CompoundTag();
    private static final Predicate<ItemStack> SHOWN;
    private final Items items = new Items();
    private final @Nullable ItemIterator<T> iterator;
    public long version;
    public long lastTimeFinished;
    public boolean lastTimeIsEmpty;
    public @Nullable List<ViewGroup<ItemStack>> mergedResult;
    public @Nullable List<ViewGroup<ItemStack>> sortedMergedResult;

    public ItemCollector(@Nullable ItemIterator<T> iterator) {
        this.iterator = iterator;
    }

    public @Nullable List<ViewGroup<ItemStack>> update(Accessor<?> accessor) {
        List<ViewGroup<ItemStack>> result;
        if (this.iterator == null) {
            return null;
        }
        T container = this.iterator.find(accessor);
        if (container == null) {
            return null;
        }
        boolean sorted = accessor.getServerData().getBooleanOr("SortItems", false);
        long currentVersion = this.iterator.getVersion(container);
        long gameTime = System.currentTimeMillis();
        List<ViewGroup<ItemStack>> list = result = sorted ? this.sortedMergedResult : this.mergedResult;
        if (result != null && this.iterator.isFinished()) {
            if (this.version == currentVersion) {
                return result;
            }
            if (this.lastTimeFinished + 250L > gameTime) {
                return result;
            }
            this.iterator.reset();
        }
        AtomicInteger count = new AtomicInteger();
        this.iterator.populate(container, 108).forEach(stack -> {
            count.incrementAndGet();
            if (SHOWN.test((ItemStack)stack)) {
                ItemDefinition def = new ItemDefinition((ItemStack)stack);
                this.items.addTo(def, stack.getCount());
            }
        });
        this.iterator.afterPopulate(count.get());
        if (result != null && !this.iterator.isFinished()) {
            this.updateCollectingProgress(result.getFirst());
            return result;
        }
        List<ItemStack> partialResult = this.items.partialResult(sorted);
        List<ViewGroup<ItemStack>> groups = List.of(this.updateCollectingProgress(new ViewGroup<ItemStack>(partialResult)));
        if (this.iterator.isFinished()) {
            if (sorted) {
                this.mergedResult = List.of(this.updateCollectingProgress(new ViewGroup<ItemStack>(this.items.partialResult(false))));
                this.sortedMergedResult = groups;
            } else {
                this.mergedResult = groups;
                this.sortedMergedResult = List.of(this.updateCollectingProgress(new ViewGroup<ItemStack>(this.items.partialResult(true))));
            }
            this.lastTimeIsEmpty = groups.getFirst().views.isEmpty();
            this.version = currentVersion;
            this.lastTimeFinished = gameTime;
            this.items.clear();
        }
        return groups;
    }

    protected ViewGroup<ItemStack> updateCollectingProgress(ViewGroup<ItemStack> group) {
        if (this.lastTimeIsEmpty && group.views.isEmpty()) {
            return group;
        }
        float progress = Objects.requireNonNull(this.iterator).getCollectingProgress();
        CompoundTag data = group.getExtraData();
        if (Float.isNaN(progress) || progress >= 1.0f) {
            data.remove("Collecting");
        } else {
            data.putFloat("Collecting", progress);
        }
        return group;
    }

    static {
        IGNORED_TAG.putBoolean("__JadeClear", true);
        SHOWN = stack -> {
            if (stack.isEmpty()) {
                return false;
            }
            if (((TooltipDisplay)stack.getOrDefault(DataComponents.TOOLTIP_DISPLAY, (Object)TooltipDisplay.DEFAULT)).hideTooltip()) {
                return false;
            }
            if (stack.hasNonDefault(DataComponents.CUSTOM_MODEL_DATA) || stack.hasNonDefault(DataComponents.ITEM_MODEL)) {
                CustomData customData = (CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
                return !customData.matchedBy(IGNORED_TAG);
            }
            return true;
        };
    }

    private static class Items {
        private final Object2IntLinkedOpenHashMap<ItemDefinition> items = new Object2IntLinkedOpenHashMap();
        private final List<ItemDefinition> sorted = Lists.newArrayList();
        private final Set<ItemDefinition> sortedSet = Sets.newLinkedHashSet();
        private int smallestCount;

        private Items() {
        }

        public void clear() {
            this.smallestCount = 0;
            this.items.clear();
            this.sorted.clear();
            this.sortedSet.clear();
        }

        public List<ItemStack> partialResult(boolean sort) {
            if (sort) {
                this.sorted.sort((a, b) -> -Integer.compare(this.items.getInt(a), this.items.getInt(b)));
                if (this.sorted.size() > 54) {
                    this.sorted.subList(54, this.sorted.size()).clear();
                    this.sortedSet.clear();
                    this.sortedSet.addAll(this.sorted);
                }
                if (!this.sorted.isEmpty()) {
                    this.smallestCount = this.items.getInt((Object)this.sorted.getLast());
                }
                return this.sorted.stream().map(def -> def.toStack(this.items.getInt(def))).toList();
            }
            return this.items.object2IntEntrySet().stream().limit(54L).map(entry -> ((ItemDefinition)entry.getKey()).toStack(entry.getIntValue())).toList();
        }

        public void addTo(ItemDefinition def, int count) {
            int old = this.items.addTo((Object)def, count);
            if (!this.sortedSet.contains(def)) {
                count += old;
                if (this.sorted.size() < 54) {
                    this.sortedSet.add(def);
                    this.sorted.add(def);
                    this.smallestCount = Math.min(this.smallestCount, count);
                } else if (count > this.smallestCount) {
                    this.sortedSet.add(def);
                    this.sorted.add(def);
                }
            }
        }
    }

    public record ItemDefinition(Item item, DataComponentPatch components) {
        ItemDefinition(ItemStack stack) {
            this(stack.getItem(), stack.getComponentsPatch());
        }

        public ItemStack toStack(int count) {
            ItemStack itemStack = new ItemStack((ItemLike)this.item, count);
            itemStack.applyComponents(this.components);
            return itemStack;
        }
    }
}

