/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.vanilla;

import java.util.Map;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.Identifier;
import net.minecraft.util.Unit;
import net.minecraft.world.entity.animal.golem.CopperGolem;
import net.minecraft.world.item.HoneycombItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jspecify.annotations.Nullable;
import snownee.jade.addon.access.AccessibilityPlugin;
import snownee.jade.addon.core.ObjectNameProvider;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IEntityComponentProvider;
import snownee.jade.api.IJadeProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.JadeIds;
import snownee.jade.api.StreamServerDataProvider;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.config.IWailaConfig;
import snownee.jade.api.ui.Element;
import snownee.jade.api.ui.JadeUI;
import snownee.jade.impl.ui.CompoundElement;

public class WaxedProvider
implements IJadeProvider {
    @Override
    public Identifier getUid() {
        return JadeIds.MC_WAXED;
    }

    @Override
    public int getDefaultPriority() {
        return ObjectNameProvider.BlockData.INSTANCE.getDefaultPriority() + 10;
    }

    public static class EntityData
    extends WaxedProvider
    implements StreamServerDataProvider<EntityAccessor, Unit> {
        public static final EntityData INSTANCE = new EntityData();

        @Override
        public @Nullable Unit streamData(EntityAccessor accessor) {
            CopperGolem golem = (CopperGolem)accessor.getEntity();
            return golem.nextWeatheringTick == -2L ? Unit.INSTANCE : null;
        }

        @Override
        public StreamCodec<RegistryFriendlyByteBuf, Unit> streamCodec() {
            return Unit.STREAM_CODEC.cast();
        }
    }

    public static class EntityComponent
    extends WaxedProvider
    implements IEntityComponentProvider {
        public static final EntityComponent INSTANCE = new EntityComponent();
        private static final Map<WeatheringCopper.WeatherState, Block> COPPER_GOLEM_STATUES = Map.of(WeatheringCopper.WeatherState.UNAFFECTED, Blocks.COPPER_GOLEM_STATUE, WeatheringCopper.WeatherState.EXPOSED, Blocks.EXPOSED_COPPER_GOLEM_STATUE, WeatheringCopper.WeatherState.WEATHERED, Blocks.WEATHERED_COPPER_GOLEM_STATUE, WeatheringCopper.WeatherState.OXIDIZED, Blocks.OXIDIZED_COPPER_GOLEM_STATUE);

        @Override
        public Element getIcon(EntityAccessor accessor, IPluginConfig config, @Nullable Element currentIcon) {
            CopperGolem golem = (CopperGolem)accessor.getEntity();
            WeatheringCopper.WeatherState state = golem.getWeatherState();
            Block statueBlock = COPPER_GOLEM_STATUES.get(state);
            boolean waxed = EntityData.INSTANCE.decodeFromData(accessor).isPresent();
            if (waxed) {
                statueBlock = HoneycombItem.getWaxed((BlockState)statueBlock.defaultBlockState()).orElse(statueBlock.defaultBlockState()).getBlock();
            }
            return BlockComponent.waxedIcon(JadeUI.item(new ItemStack((ItemLike)statueBlock)), waxed);
        }

        @Override
        public void appendTooltip(ITooltip tooltip, EntityAccessor accessor, IPluginConfig config) {
            boolean waxed;
            if (IWailaConfig.get().accessibility().getEnableAccessibilityPlugin() && config.get(JadeIds.ACCESS_ENTITY_DETAILS) && (waxed = EntityData.INSTANCE.decodeFromData(accessor).isPresent())) {
                String objectName = tooltip.getString(JadeIds.CORE_OBJECT_NAME);
                AccessibilityPlugin.replaceTitle(tooltip, objectName, "waxed");
            }
        }
    }

    public static class BlockComponent
    extends WaxedProvider
    implements IBlockComponentProvider {
        public static final BlockComponent INSTANCE = new BlockComponent();

        public static Element waxedIcon(Element icon, boolean waxed) {
            if (waxed) {
                return new CompoundElement(icon, JadeUI.item(Items.HONEYCOMB.getDefaultInstance(), 0.5f));
            }
            return icon;
        }

        @Override
        public @Nullable Element getIcon(BlockAccessor accessor, IPluginConfig config, @Nullable Element currentIcon) {
            BlockEntity blockEntity;
            ItemStack pickedResult = accessor.getPickedResult();
            if (!pickedResult.isEmpty() && (blockEntity = accessor.getBlockEntity()) instanceof SignBlockEntity) {
                SignBlockEntity sign = (SignBlockEntity)blockEntity;
                return BlockComponent.waxedIcon(JadeUI.item(pickedResult), sign.isWaxed());
            }
            return currentIcon;
        }

        @Override
        public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
            SignBlockEntity sign;
            BlockEntity blockEntity;
            if (IWailaConfig.get().accessibility().getEnableAccessibilityPlugin() && config.get(JadeIds.ACCESS_BLOCK_DETAILS) && (blockEntity = accessor.getBlockEntity()) instanceof SignBlockEntity && (sign = (SignBlockEntity)blockEntity).isWaxed()) {
                String objectName = tooltip.getString(JadeIds.CORE_OBJECT_NAME);
                AccessibilityPlugin.replaceTitle(tooltip, objectName, "waxed");
            }
        }
    }
}

