/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.api;

import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import org.jetbrains.annotations.ApiStatus;
import org.jspecify.annotations.Nullable;
import snownee.jade.api.Accessor;

public interface EntityAccessor
extends Accessor<EntityHitResult> {
    public Entity getEntity();

    public Entity getRawEntity();

    @Override
    default public Class<? extends Accessor<?>> getAccessorType() {
        return EntityAccessor.class;
    }

    @ApiStatus.NonExtendable
    public static interface Builder {
        public Builder level(Level var1);

        public Builder player(Player var1);

        public Builder serverData(@Nullable CompoundTag var1);

        public Builder serverConnected(boolean var1);

        public Builder showDetails(boolean var1);

        default public Builder hit(EntityHitResult hit) {
            return this.hit(() -> hit);
        }

        public Builder hit(Supplier<EntityHitResult> var1);

        default public Builder entity(Entity entity) {
            return this.entity(() -> entity);
        }

        public Builder entity(Supplier<Entity> var1);

        public Builder from(EntityAccessor var1);

        default public Builder requireVerification() {
            return this.requireVerification(true);
        }

        public Builder requireVerification(boolean var1);

        public EntityAccessor build();
    }
}

