/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.impl.ui;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import org.jspecify.annotations.Nullable;
import snownee.jade.api.ui.Element;

public class CompoundElement
extends Element {
    protected final Element large;
    protected final Element small;

    public CompoundElement(Element large, Element small) {
        this.large = large;
        this.small = small;
        this.width = large.getWidth();
        this.height = large.getHeight();
    }

    @Override
    public @Nullable Component getNarration() {
        return this.large.getNarration();
    }

    @Override
    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.large.render(graphics, mouseX, mouseY, partialTicks);
        graphics.pose().pushMatrix();
        this.small.render(graphics, mouseX, mouseY, partialTicks);
        graphics.pose().popMatrix();
    }

    @Override
    public void setX(int x) {
        super.setX(x);
        this.large.setX(x);
        this.small.setX(x + this.large.getWidth() - this.small.getWidth());
    }

    @Override
    public void setY(int y) {
        super.setY(y);
        this.large.setY(y);
        this.small.setY(y + this.large.getHeight() - this.small.getHeight());
    }
}

