/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.overlay;

import com.mojang.blaze3d.platform.Window;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import org.joml.Matrix3x2fStack;
import org.joml.Vector2i;
import org.jspecify.annotations.Nullable;
import snownee.jade.Jade;
import snownee.jade.JadeClient;
import snownee.jade.JadeInternals;
import snownee.jade.api.JadeIds;
import snownee.jade.api.JadeKeys;
import snownee.jade.api.callback.JadeBeforeRenderCallback;
import snownee.jade.api.config.IWailaConfig;
import snownee.jade.api.theme.IThemeHelper;
import snownee.jade.api.theme.Theme;
import snownee.jade.api.ui.Element;
import snownee.jade.api.ui.JadeUI;
import snownee.jade.api.ui.Rect2f;
import snownee.jade.api.ui.TooltipAnimation;
import snownee.jade.gui.BaseOptionsScreen;
import snownee.jade.gui.PreviewOptionsScreen;
import snownee.jade.impl.Tooltip;
import snownee.jade.impl.WailaClientRegistration;
import snownee.jade.impl.config.WailaConfig;
import snownee.jade.impl.ui.BoxElementImpl;
import snownee.jade.overlay.WailaTickHandler;
import snownee.jade.util.ClientProxy;
import snownee.jade.util.JadeGuiGraphics;
import snownee.jade.util.ModIdentification;

public class OverlayRenderer {
    public static final TooltipAnimation animation = new TooltipAnimation();
    public static float ticks;
    public static boolean shown;
    private static @Nullable BoxElementImpl lingerTooltip;
    private static float disappearTicks;

    public static boolean shouldShow() {
        if (JadeClient.tickHandler().rootElement == null) {
            return false;
        }
        IWailaConfig.General general = IWailaConfig.get().general();
        if (!general.shouldDisplayTooltip()) {
            return false;
        }
        if (general.getDisplayMode() == IWailaConfig.DisplayMode.HOLD_KEY && !JadeKeys.showOverlay().isDown()) {
            return false;
        }
        IWailaConfig.BossBarOverlapMode mode = general.getBossBarOverlapMode();
        return mode != IWailaConfig.BossBarOverlapMode.HIDE_TOOLTIP || Minecraft.getInstance().screen instanceof BaseOptionsScreen || ClientProxy.getBossBarRect() == null;
    }

    public static boolean shouldShowImmediately(BoxElementImpl box) {
        if (box.getTooltip().isEmpty()) {
            return false;
        }
        Minecraft mc = Minecraft.getInstance();
        if (!ClientProxy.shouldShowWithGui(mc, mc.screen)) {
            return false;
        }
        box.updateExpectedRect(animation);
        Screen screen = mc.screen;
        if (screen instanceof PreviewOptionsScreen) {
            double y;
            PreviewOptionsScreen optionsScreen = (PreviewOptionsScreen)screen;
            if (optionsScreen.forcePreviewOverlay()) {
                return true;
            }
            if (!Jade.history().previewOverlay) {
                return false;
            }
            Window window = mc.getWindow();
            double x = mc.mouseHandler.getScaledXPos(window);
            if (OverlayRenderer.animation.expectedRect.contains((int)x, (int)(y = mc.mouseHandler.getScaledYPos(window)))) {
                return false;
            }
        }
        WailaConfig.General general = Jade.config().general();
        if (mc.getOverlay() != null || mc.options.hideGui) {
            return false;
        }
        return !mc.gui.getTabList().visible || !general.shouldHideFromTabList();
    }

    public static void renderOverlay478757(GuiGraphics graphics, float delta) {
        boolean show;
        ticks += delta;
        shown = false;
        BoxElementImpl root = JadeClient.tickHandler().rootElement;
        if (root == null && PreviewOptionsScreen.isAdjustingPosition()) {
            Tooltip tooltip = new Tooltip();
            tooltip.add((Component)IThemeHelper.get().title(Blocks.GRASS_BLOCK.getName()));
            tooltip.add(IThemeHelper.get().modName(ModIdentification.getModName(Blocks.GRASS_BLOCK)));
            Theme theme = IThemeHelper.get().theme();
            tooltip.setIcon(theme.modifyIcon(JadeUI.item(new ItemStack((ItemLike)Blocks.GRASS_BLOCK))));
            root = new BoxElementImpl(tooltip, theme.tooltipStyle);
            root.tag(JadeIds.ROOT);
            root.updateExpectedRect(animation);
            show = true;
        } else {
            show = OverlayRenderer.shouldShow();
        }
        IWailaConfig.Overlay overlay = IWailaConfig.get().overlay();
        IWailaConfig.General general = IWailaConfig.get().general();
        if (root != null) {
            lingerTooltip = root;
        }
        if (root == null && lingerTooltip != null) {
            if ((disappearTicks += delta) < overlay.getDisappearingDelay()) {
                root = lingerTooltip;
                show = true;
            }
        } else {
            disappearTicks = 0.0f;
        }
        if (overlay.getAnimation() && lingerTooltip != null) {
            root = lingerTooltip;
            float speed = general.isDebug() ? 0.1f : 0.6f;
            OverlayRenderer.animation.showHideAlpha = OverlayRenderer.animation.showHideAlpha + (show ? speed : -speed) * delta;
            OverlayRenderer.animation.showHideAlpha = Mth.clamp((float)OverlayRenderer.animation.showHideAlpha, (float)0.0f, (float)1.0f);
        } else {
            float f = OverlayRenderer.animation.showHideAlpha = show ? 1.0f : 0.0f;
        }
        if (root == null) {
            return;
        }
        if (!(!(OverlayRenderer.animation.showHideAlpha < 0.1f) && OverlayRenderer.shouldShowImmediately(root) || PreviewOptionsScreen.isAdjustingPosition())) {
            lingerTooltip = null;
            OverlayRenderer.animation.rect.setWidth(0.0f);
            return;
        }
        int mouseX = -1;
        int mouseY = -1;
        Minecraft mc = Minecraft.getInstance();
        if (JadeUI.isPinned()) {
            Window window = mc.getWindow();
            mouseX = (int)mc.mouseHandler.getScaledXPos(window);
            mouseY = (int)mc.mouseHandler.getScaledYPos(window);
        }
        Profiler.get().push("Jade Overlay");
        OverlayRenderer.renderOverlay(root, graphics, mouseX, mouseY, delta);
        Profiler.get().pop();
    }

    public static void renderOverlay(BoxElementImpl root, GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        BoxElementImpl boxElementImpl;
        Rect2f bossBarRect;
        boolean renderDebug;
        root.updateRect(animation);
        WailaTickHandler tickHandler = JadeClient.tickHandler();
        if (tickHandler.state != null) {
            for (JadeBeforeRenderCallback callback2 : WailaClientRegistration.instance().beforeRenderCallback.callbacks()) {
                if (!callback2.beforeRender(root, animation, graphics, tickHandler.state.accessor())) continue;
                return;
            }
        }
        boolean bl = renderDebug = IWailaConfig.get().general().isDebug() && JadeUI.hasControlDown();
        if (renderDebug && (bossBarRect = ClientProxy.getBossBarRect()) != null) {
            JadeInternals.getDisplayHelper().drawBorder(graphics, bossBarRect, 2, -1996553985, true);
        }
        Matrix3x2fStack matrixStack = graphics.pose();
        matrixStack.pushMatrix();
        Rect2f rect = OverlayRenderer.animation.rect;
        matrixStack.translate(rect.getX(), rect.getY());
        float scale = OverlayRenderer.animation.scale;
        if (scale != 1.0f) {
            matrixStack.scale(scale);
        }
        Vector2i mouse = new Vector2i(mouseX, mouseY);
        if (mouseX != -1) {
            animation.mapMousePosition(mouseX, mouseY, (x, y) -> mouse.set(x.intValue(), y.intValue()));
        }
        root.setWidgetAlpha(OverlayRenderer.animation.alpha);
        ((JadeGuiGraphics)graphics).jade$setIgnoreScissorTest(true);
        graphics.deferredTooltip = null;
        root.render(graphics, mouse.x, mouse.y, partialTicks);
        ((JadeGuiGraphics)graphics).jade$setIgnoreScissorTest(false);
        if (renderDebug) {
            root.renderDebug(graphics, mouse.x, mouse.y, partialTicks, new Element.RenderDebugContext(root, rect, true));
        } else if (JadeUI.isPinned() && JadeUI.hasControlDown() && (boxElementImpl = root.getChildAt(mouse.x, mouse.y).orElse(root)) instanceof Element) {
            Element element = boxElementImpl;
            element.renderDebug(graphics, mouse.x, mouse.y, partialTicks, new Element.RenderDebugContext(root, rect, false));
        }
        if (tickHandler.state != null) {
            WailaClientRegistration.instance().afterRenderCallback.call(callback -> callback.afterRender(root, animation, graphics, tickHandler.state.accessor()));
        }
        matrixStack.popMatrix();
        graphics.renderDeferredElements();
        if (IWailaConfig.get().accessibility().shouldEnableTextToSpeech()) {
            tickHandler.narrate(root, true);
        }
        shown = true;
    }

    public static void clearLingerTooltip() {
        lingerTooltip = null;
    }
}

