/*
 * Decompiled with CFR 0.152.
 */
package bl4ckscor3.mod.snowundertrees;

import bl4ckscor3.mod.snowundertrees.Configuration;
import bl4ckscor3.mod.snowundertrees.EternalWinterHandler;
import bl4ckscor3.mod.snowundertrees.SnowUnderTrees;
import com.mojang.serialization.MapCodec;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.resources.Identifier;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.common.world.ClimateSettingsBuilder;
import net.neoforged.neoforge.common.world.ModifiableBiomeInfo;

public record SnowUnderTreesBiomeModifier(Holder<PlacedFeature> snowUnderTreesFeature) implements BiomeModifier
{
    public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
        if (phase == BiomeModifier.Phase.ADD && ((Boolean)Configuration.CONFIG.enableBiomeFeature.get()).booleanValue()) {
            boolean isEternalWinterActive;
            boolean bl = isEternalWinterActive = SnowUnderTrees.isEternalWinterLoaded() && EternalWinterHandler.isActive(biome);
            if (isEternalWinterActive || this.shouldAddToBiome(biome, builder.getClimateSettings())) {
                builder.getGenerationSettings().addFeature(GenerationStep.Decoration.TOP_LAYER_MODIFICATION.ordinal(), this.snowUnderTreesFeature);
            }
        }
    }

    public boolean shouldAddToBiome(Holder<Biome> biome, ClimateSettingsBuilder climate) {
        if (this.isFiltered(biome)) {
            return false;
        }
        return this.isPrecipitationSnow(climate) || this.isManuallyAdded(biome);
    }

    public boolean isPrecipitationSnow(ClimateSettingsBuilder climate) {
        return climate.hasPrecipitation() && climate.getTemperature() < 0.15f;
    }

    public boolean isManuallyAdded(Holder<Biome> biome) {
        return SnowUnderTrees.biomesToAddTo().stream().anyMatch(arg_0 -> biome.is(arg_0));
    }

    public boolean isFiltered(Holder<Biome> biome) {
        return ((List)Configuration.CONFIG.filteredBiomes.get()).stream().map(Identifier::parse).anyMatch(arg_0 -> biome.is(arg_0));
    }

    public MapCodec<? extends BiomeModifier> codec() {
        return (MapCodec)SnowUnderTrees.SNOW_UNDER_TREES_BIOME_MODIFIER_CODEC.get();
    }
}

