/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.littlejoys.handler;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.blay09.mods.balm.Balm;
import net.blay09.mods.balm.platform.event.callback.BlockCallback;
import net.blay09.mods.balm.platform.event.callback.ServerTickCallback;
import net.blay09.mods.littlejoys.LittleJoysConfig;
import net.blay09.mods.littlejoys.entity.DropRushItemEntity;
import net.blay09.mods.littlejoys.handler.DropRushInstance;
import net.blay09.mods.littlejoys.mixin.RecipeManagerAccessor;
import net.blay09.mods.littlejoys.network.protocol.ClientboundStartDropRushPacket;
import net.blay09.mods.littlejoys.network.protocol.ClientboundStopDropRushPacket;
import net.blay09.mods.littlejoys.recipe.DropRushRecipe;
import net.blay09.mods.littlejoys.recipe.ModRecipeTypes;
import net.blay09.mods.littlejoys.recipe.condition.EventContextImpl;
import net.blay09.mods.littlejoys.stats.ModStats;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeMap;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;

public class DropRushHandler {
    private static final RandomSource random = RandomSource.create();
    private static final int DROP_TICKS = 50;
    private static final Table<ResourceKey<Level>, BlockPos, DropRushInstance> activeDropRushes = HashBasedTable.create();

    public static void initialize() {
        BlockCallback.Break.Before.EVENT.register((level, pos, state, blockEntity, player) -> {
            ServerLevel serverLevel;
            block7: {
                block6: {
                    if (player.getAbilities().instabuild) {
                        return true;
                    }
                    if (Balm.hooks().isFakePlayer(player)) {
                        return true;
                    }
                    Boolean hasSilkTouch = level.registryAccess().lookup(Registries.ENCHANTMENT).flatMap(it -> it.get(Enchantments.SILK_TOUCH)).map(it -> EnchantmentHelper.getEnchantmentLevel((Holder)it, (LivingEntity)player) > 0).orElse(false);
                    if (hasSilkTouch.booleanValue()) {
                        return true;
                    }
                    if (!(level instanceof ServerLevel)) break block6;
                    serverLevel = (ServerLevel)level;
                    if (player instanceof ServerPlayer) break block7;
                }
                return true;
            }
            ServerPlayer serverPlayer = (ServerPlayer)player;
            DropRushHandler.rollForDropRush(serverLevel, pos, state, serverPlayer);
            return true;
        });
        ServerTickCallback.ServerLevelTick.BEFORE.register(level -> {
            for (DropRushInstance dropRush : activeDropRushes.row((Object)level.dimension()).values()) {
                Player player;
                dropRush.setTicksPassed(dropRush.getTicksPassed() + 1);
                dropRush.setDropCooldownTicks(dropRush.getDropCooldownTicks() - 1);
                List<ItemStack> dropsLeft = dropRush.getDrops();
                if (dropRush.getDropCooldownTicks() <= 0 && !dropsLeft.isEmpty()) {
                    ItemStack nextDropItemStack = dropsLeft.removeLast();
                    DropRushHandler.spawnDropRushItem((Level)level, dropRush, nextDropItemStack);
                    dropRush.setDropCooldownTicks(dropRush.getTicksPerDrop());
                } else if (dropRush.getTicksPassed() >= 50) {
                    for (ItemStack itemStack : dropsLeft) {
                        DropRushHandler.spawnDropRushItem((Level)level, dropRush, itemStack);
                    }
                }
                dropRush.getEntities().removeIf(DropRushItemEntity::isPickedUp);
                if (dropRush.getEntities().isEmpty()) {
                    player = level.getPlayerByUUID(dropRush.getPlayerId());
                    if (player == null) continue;
                    Balm.networking().sendTo(player, (CustomPacketPayload)new ClientboundStopDropRushPacket(ClientboundStopDropRushPacket.Reason.FULL_CLEAR));
                    continue;
                }
                if (dropRush.getTicksPassed() < dropRush.getMaxTicks() || (player = level.getPlayerByUUID(dropRush.getPlayerId())) == null) continue;
                Balm.networking().sendTo(player, (CustomPacketPayload)new ClientboundStopDropRushPacket(ClientboundStopDropRushPacket.Reason.TIME_UP));
            }
            activeDropRushes.values().removeIf(it -> it.getTicksPassed() >= it.getMaxTicks() || it.getEntities().isEmpty());
        });
    }

    public static boolean rollForDropRush(ServerLevel level, BlockPos pos, BlockState state, ServerPlayer player) {
        return DropRushHandler.rollRecipe(level, pos, state, player, false).map(recipeHolder -> {
            DropRushHandler.startDropRush(level, pos, player, (RecipeHolder<DropRushRecipe>)recipeHolder);
            return true;
        }).orElse(false);
    }

    public static boolean startDropRush(ServerLevel level, BlockPos pos, BlockState state, ServerPlayer player) {
        return DropRushHandler.rollRecipe(level, pos, state, player, true).map(recipeHolder -> {
            DropRushHandler.startDropRush(level, pos, player, (RecipeHolder<DropRushRecipe>)recipeHolder);
            return true;
        }).orElse(false);
    }

    public static void startDropRush(ServerLevel level, BlockPos pos, ServerPlayer player, RecipeHolder<DropRushRecipe> recipeHolder) {
        DropRushRecipe recipe = (DropRushRecipe)recipeHolder.value();
        DropRushInstance dropRushInstance = new DropRushInstance(player.getUUID(), pos, recipe.lootTable(), (int)Math.floor(20.0f * recipe.seconds()));
        LootParams.Builder lootParamsBuilder = new LootParams.Builder(level).withParameter(LootContextParams.ORIGIN, (Object)Vec3.atCenterOf((Vec3i)pos)).withParameter(LootContextParams.TOOL, (Object)ItemStack.EMPTY).withOptionalParameter(LootContextParams.BLOCK_ENTITY, (Object)level.getBlockEntity(pos));
        ResourceKey<LootTable> lootTableId = recipe.lootTable();
        LootParams lootParams = lootParamsBuilder.withParameter(LootContextParams.BLOCK_STATE, (Object)level.getBlockState(pos)).create(LootContextParamSets.BLOCK);
        LootTable lootTable = level.getServer().reloadableRegistries().getLootTable(lootTableId);
        for (int i = 0; i < recipe.rolls(); ++i) {
            lootTable.getRandomItems(lootParams).forEach(dropRushInstance::addDrop);
        }
        dropRushInstance.setTicksPerDrop(Math.max(50 / Math.max(1, dropRushInstance.getDrops().size()), 1));
        Balm.networking().sendTo((Player)player, (CustomPacketPayload)new ClientboundStartDropRushPacket(dropRushInstance.getMaxTicks()));
        player.awardStat(ModStats.dropRushesTriggered);
        activeDropRushes.put((Object)level.dimension(), (Object)pos, (Object)dropRushInstance);
    }

    private static void spawnDropRushItem(Level level, DropRushInstance dropRush, ItemStack itemStack) {
        float deltaX = (random.nextFloat() - 0.5f) * 0.7f;
        float deltaY = random.nextFloat() * 0.5f + 0.2f;
        float deltaZ = (random.nextFloat() - 0.5f) * 0.7f;
        float x = (float)dropRush.getPos().getX() + 0.5f;
        float y = (float)dropRush.getPos().getY() + 0.25f;
        float z = (float)dropRush.getPos().getZ() + 0.5f;
        DropRushItemEntity itemEntity = new DropRushItemEntity(level, x, y, z, itemStack, deltaX, deltaY, deltaZ);
        itemEntity.setPickUpDelay(20);
        itemEntity.setUnlimitedLifetime();
        itemEntity.setActualLifetime(dropRush.getMaxTicks() - dropRush.getTicksPassed());
        itemEntity.setTarget(dropRush.getPlayerId());
        level.addFreshEntity((Entity)itemEntity);
        dropRush.addEntity(itemEntity);
    }

    private static Optional<RecipeHolder<DropRushRecipe>> rollRecipe(ServerLevel level, BlockPos pos, BlockState state, ServerPlayer player, boolean force) {
        RecipeManager recipeManager = level.getServer().getRecipeManager();
        RecipeMap recipeMap = ((RecipeManagerAccessor)recipeManager).getRecipes();
        Collection recipes = recipeMap.byType(ModRecipeTypes.dropRush.type());
        ArrayList<RecipeHolder> candidates = new ArrayList<RecipeHolder>();
        float baseChance = LittleJoysConfig.getActive().dropRush.baseChance;
        float roll = random.nextFloat();
        for (RecipeHolder recipeHolder : recipes) {
            if (!DropRushHandler.isValidRecipeFor((RecipeHolder<DropRushRecipe>)recipeHolder, level, pos, state, player) || !force && !(roll <= baseChance * ((DropRushRecipe)recipeHolder.value()).chanceMultiplier())) continue;
            candidates.add(recipeHolder);
        }
        return WeightedRandom.getRandomItem((RandomSource)random, candidates, it -> ((DropRushRecipe)it.value()).weight());
    }

    private static boolean isValidRecipeFor(RecipeHolder<DropRushRecipe> recipe, ServerLevel level, BlockPos pos, BlockState state, ServerPlayer player) {
        EventContextImpl context = new EventContextImpl((Level)level, pos, state, (Player)player);
        return ((DropRushRecipe)recipe.value()).eventCondition().test(context);
    }
}

