/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.trashslot.client;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.platform.Window;
import net.blay09.mods.balm.client.platform.event.callback.ScreenCallback;
import net.blay09.mods.balm.mixin.AbstractContainerScreenAccessor;
import net.blay09.mods.balm.mixin.SlotAccessor;
import net.blay09.mods.trashslot.TrashSlot;
import net.blay09.mods.trashslot.TrashSlotConfig;
import net.blay09.mods.trashslot.TrashSlotSaveState;
import net.blay09.mods.trashslot.api.IGuiContainerLayout;
import net.blay09.mods.trashslot.client.ContainerSettings;
import net.blay09.mods.trashslot.client.Hint;
import net.blay09.mods.trashslot.client.LayoutManager;
import net.blay09.mods.trashslot.client.ModKeyMappings;
import net.blay09.mods.trashslot.client.TrashSlotSlot;
import net.blay09.mods.trashslot.client.deletion.DeletionProvider;
import net.blay09.mods.trashslot.client.gui.TrashSlotComponent;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.input.InputWithModifiers;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.Identifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.joml.Matrix3x2fStack;

public class TrashSlotGuiHandler {
    private static final Identifier SLOT_HIGHLIGHT_BACK_SPRITE = Identifier.withDefaultNamespace((String)"container/slot_highlight_back");
    private static final Identifier SLOT_HIGHLIGHT_FRONT_SPRITE = Identifier.withDefaultNamespace((String)"container/slot_highlight_front");
    private static final TrashSlotSlot trashSlot = new TrashSlotSlot();
    private static TrashSlotComponent trashSlotComponent;
    private static ContainerSettings currentContainerSettings;
    private static boolean ignoreMouseUp;
    private static boolean sentMissingMessage;
    private static boolean isLeftMouseDown;
    private static Hint currentHint;

    public static void initialize() {
        ScreenCallback.Init.After.EVENT.register(TrashSlotGuiHandler::onScreenInit);
        ScreenCallback.MouseRelease.Before.EVENT.register(TrashSlotGuiHandler::onMouseRelease);
        ScreenCallback.MousePress.Before.EVENT.register(TrashSlotGuiHandler::onMouseClick);
        ScreenCallback.KeyPress.After.EVENT.register(TrashSlotGuiHandler::onKeyPress);
        ScreenCallback.Render.AFTER_BACKGROUND.register(TrashSlotGuiHandler::onBackgroundDrawn);
    }

    private static void onScreenInit(Screen screen) {
        if (screen.getClass().getName().startsWith("com.replaymod")) {
            return;
        }
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null && player.isSpectator()) {
            return;
        }
        if (screen instanceof CreativeModeInventoryScreen) {
            currentContainerSettings = ContainerSettings.NONE;
            trashSlotComponent = null;
            return;
        }
        if (screen instanceof AbstractContainerScreen) {
            AbstractContainerScreen containerScreen = (AbstractContainerScreen)screen;
            if (!TrashSlot.isServerSideInstalled && !sentMissingMessage) {
                TrashSlot.logger.info("TrashSlot is not installed on the server and thus will be unavailable.");
                MutableComponent noHabloEspanol = Component.translatable((String)"trashslot.serverNotInstalled");
                noHabloEspanol.withStyle(ChatFormatting.RED);
                TrashSlotGuiHandler.showHint("serverNotInstalled", noHabloEspanol, 5000, true);
                sentMissingMessage = true;
                return;
            }
            if (containerScreen instanceof InventoryScreen && player != null && player.getAbilities().instabuild) {
                return;
            }
            IGuiContainerLayout layout = LayoutManager.getLayout(containerScreen);
            currentContainerSettings = TrashSlotSaveState.getSettings(containerScreen, layout);
            if (currentContainerSettings != ContainerSettings.NONE) {
                trashSlotComponent = new TrashSlotComponent(containerScreen, layout, currentContainerSettings, trashSlot);
                if (!(currentContainerSettings.isEnabled() || layout.isEnabledByDefault() || ModKeyMappings.keyBindToggleSlot.getBinding().key().equals((Object)InputConstants.UNKNOWN))) {
                    MutableComponent hintMessage = Component.translatable((String)"trashslot.hint.toggleOn", (Object[])new Object[]{ModKeyMappings.keyBindToggleSlot.getBinding().key().getDisplayName()});
                    TrashSlotGuiHandler.showHint("toggleOn", hintMessage, 5000);
                }
            } else {
                trashSlotComponent = null;
            }
        } else {
            currentContainerSettings = ContainerSettings.NONE;
            trashSlotComponent = null;
        }
    }

    private static boolean onMouseRelease(Screen screen, double mouseX, double mouseY, int button) {
        if (button == 0) {
            isLeftMouseDown = false;
        }
        if (ignoreMouseUp) {
            ignoreMouseUp = false;
            return true;
        }
        return false;
    }

    private static boolean onMouseClick(Screen screen, MouseButtonEvent event) {
        DeletionProvider deletionProvider;
        if (event.button() == 0) {
            isLeftMouseDown = true;
        }
        if ((deletionProvider = TrashSlotConfig.getDeletionProvider()) == null || !currentContainerSettings.isEnabled()) {
            return false;
        }
        if (TrashSlotGuiHandler.runKeyBindings(screen, (InputWithModifiers)event)) {
            return true;
        }
        if (screen instanceof AbstractContainerScreen) {
            AbstractContainerScreen containerScreen = (AbstractContainerScreen)screen;
            if (((AbstractContainerScreenAccessor)containerScreen).callIsHovering((Slot)trashSlot, event.x(), event.y())) {
                LocalPlayer player = Minecraft.getInstance().player;
                if (player != null) {
                    ItemStack mouseItem = containerScreen.getMenu().getCarried();
                    boolean isRightClick = event.isRight();
                    if (mouseItem.isEmpty()) {
                        deletionProvider.undeleteLast((Player)player, trashSlot, isRightClick);
                    } else {
                        Identifier registryName = BuiltInRegistries.ITEM.getKey((Object)mouseItem.getItem());
                        if (registryName == null || !TrashSlotConfig.getActive().deletionDenyList.contains(registryName.toString())) {
                            deletionProvider.deleteMouseItem((Player)player, mouseItem, trashSlot, isRightClick);
                        } else {
                            MutableComponent hintMessage = Component.translatable((String)"trashslot.hint.deletionDenied");
                            hintMessage.withStyle(ChatFormatting.RED);
                            TrashSlotGuiHandler.showHint("deletionDenied", hintMessage, 1000, true);
                        }
                    }
                    ignoreMouseUp = true;
                    return true;
                }
            } else if (trashSlotComponent.isInside((int)event.x(), (int)event.y())) {
                ignoreMouseUp = true;
                return true;
            }
        }
        return false;
    }

    private static boolean onKeyPress(Screen screen, KeyEvent event) {
        DeletionProvider deletionProvider = TrashSlotConfig.getDeletionProvider();
        if (deletionProvider == null) {
            return false;
        }
        return TrashSlotGuiHandler.runKeyBindings(screen, (InputWithModifiers)event);
    }

    private static boolean runKeyBindings(Screen screen, InputWithModifiers input) {
        Slot mouseSlot;
        CreativeModeInventoryScreen containerScreen;
        DeletionProvider deletionProvider = TrashSlotConfig.getDeletionProvider();
        if (deletionProvider == null) {
            return false;
        }
        boolean isDelete = ModKeyMappings.keyBindDelete.isActiveAndMatchesInput(input);
        boolean isDeleteAll = ModKeyMappings.keyBindDeleteAll.isActiveAndMatchesInput(input);
        LocalPlayer player = Minecraft.getInstance().player;
        if ((isDelete || isDeleteAll) && TrashSlotConfig.getActive().enableDeleteKeysInCreative && screen instanceof CreativeModeInventoryScreen) {
            containerScreen = (CreativeModeInventoryScreen)screen;
            if (player != null) {
                mouseSlot = ((AbstractContainerScreenAccessor)containerScreen).getHoveredSlot();
                DeletionProvider creativeDeletionProvider = TrashSlotConfig.getCreativeDeletionProvider();
                if (mouseSlot != null && mouseSlot.getClass() == Slot.class) {
                    creativeDeletionProvider.deleteContainerItem((Player)player, containerScreen.getMenu(), mouseSlot.index - 9, isDeleteAll, trashSlot);
                } else if (mouseSlot != null && mouseSlot.getClass().getSimpleName().equals("SlotWrapper")) {
                    creativeDeletionProvider.deleteContainerItem((Player)player, containerScreen.getMenu(), mouseSlot.getContainerSlot(), isDeleteAll, trashSlot);
                }
            }
        }
        if ((currentContainerSettings.isEnabled() || TrashSlotConfig.getActive().allowDeletionWhileTrashSlotIsInvisible) && (isDelete || isDeleteAll) && player != null && screen instanceof AbstractContainerScreen) {
            containerScreen = (AbstractContainerScreen)screen;
            mouseSlot = ((AbstractContainerScreenAccessor)containerScreen).getHoveredSlot();
            if (mouseSlot != null && mouseSlot.hasItem()) {
                Identifier registryName = BuiltInRegistries.ITEM.getKey((Object)mouseSlot.getItem().getItem());
                if (registryName == null || !TrashSlotConfig.getActive().deletionDenyList.contains(registryName.toString())) {
                    deletionProvider.deleteContainerItem((Player)player, containerScreen.getMenu(), mouseSlot.index, isDeleteAll, trashSlot);
                    if (!currentContainerSettings.isEnabled()) {
                        MutableComponent hintMessage = Component.translatable((String)"trashslot.hint.deletedWhileHidden");
                        hintMessage.withStyle(ChatFormatting.GOLD);
                        TrashSlotGuiHandler.showHint("deletedWhileHidden", hintMessage, 800, true);
                    }
                } else {
                    MutableComponent hintMessage = Component.translatable((String)"trashslot.hint.deletionDenied");
                    hintMessage.withStyle(ChatFormatting.RED);
                    TrashSlotGuiHandler.showHint("deletionDenied", hintMessage, 1000, true);
                }
            } else {
                double mouseY;
                Window mainWindow = Minecraft.getInstance().getWindow();
                double rawMouseX = Minecraft.getInstance().mouseHandler.xpos();
                double rawMouseY = Minecraft.getInstance().mouseHandler.ypos();
                double mouseX = rawMouseX * (double)mainWindow.getGuiScaledWidth() / (double)mainWindow.getWidth();
                if (((AbstractContainerScreenAccessor)containerScreen).callIsHovering((Slot)trashSlot, mouseX, mouseY = rawMouseY * (double)mainWindow.getGuiScaledHeight() / (double)mainWindow.getHeight())) {
                    deletionProvider.emptyTrashSlot((Player)player, trashSlot);
                }
            }
            return true;
        }
        if (screen instanceof AbstractContainerScreen && currentContainerSettings != ContainerSettings.NONE) {
            MutableComponent hintMessage;
            if (ModKeyMappings.keyBindToggleSlot.isActiveAndMatchesInput(input)) {
                currentContainerSettings.setEnabled(!currentContainerSettings.isEnabled());
                if (!currentContainerSettings.isEnabled() && !ModKeyMappings.keyBindToggleSlot.getBinding().key().equals((Object)InputConstants.UNKNOWN)) {
                    hintMessage = Component.translatable((String)"trashslot.hint.toggledOff", (Object[])new Object[]{ModKeyMappings.keyBindToggleSlot.getBinding().key().getDisplayName()});
                    TrashSlotGuiHandler.showHint("toggledOff", hintMessage, 5000);
                }
                TrashSlotSaveState.save();
                return true;
            }
            if (ModKeyMappings.keyBindToggleSlotLock.isActiveAndMatchesInput(input)) {
                currentContainerSettings.setLocked(!currentContainerSettings.isLocked());
                if (currentContainerSettings.isLocked()) {
                    hintMessage = Component.translatable((String)"trashslot.hint.locked", (Object[])new Object[]{ModKeyMappings.keyBindToggleSlotLock.getBinding().key().getDisplayName()});
                    hintMessage.withStyle(ChatFormatting.GOLD);
                    TrashSlotGuiHandler.showHint("locked", hintMessage, 5000, true);
                } else {
                    hintMessage = Component.translatable((String)"trashslot.hint.unlocked", (Object[])new Object[]{ModKeyMappings.keyBindToggleSlotLock.getBinding().key().getDisplayName()});
                    hintMessage.withStyle(ChatFormatting.GOLD);
                    TrashSlotGuiHandler.showHint("unlocked", hintMessage, 5000, true);
                }
                TrashSlotSaveState.save();
                return true;
            }
        }
        return false;
    }

    private static void showHint(String id, MutableComponent message, int timeToDisplay) {
        TrashSlotGuiHandler.showHint(id, message, timeToDisplay, false);
    }

    private static void showHint(String id, MutableComponent message, int timeToDisplay, boolean force) {
        TrashSlotSaveState saveState = TrashSlotSaveState.getInstance();
        if (force || !saveState.hasSeenHint(id) && TrashSlotConfig.getActive().enableHints) {
            currentHint = new Hint(id, (Component)message, timeToDisplay);
        }
    }

    public static void onBackgroundDrawn(Screen screen, GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        DeletionProvider deletionProvider = TrashSlotConfig.getDeletionProvider();
        if (deletionProvider == null || !currentContainerSettings.isEnabled()) {
            return;
        }
        if (screen instanceof AbstractContainerScreen) {
            AbstractContainerScreen containerScreen = (AbstractContainerScreen)screen;
            if (trashSlotComponent != null) {
                boolean isMouseSlot;
                trashSlotComponent.update(mouseX, mouseY);
                trashSlotComponent.drawBackground(guiGraphics);
                Matrix3x2fStack poseStack = guiGraphics.pose();
                AbstractContainerScreenAccessor screenAccessor = (AbstractContainerScreenAccessor)containerScreen;
                boolean hovering = screenAccessor.callIsHovering((Slot)trashSlot, (double)mouseX, (double)mouseY);
                if (hovering) {
                    poseStack.pushMatrix();
                    poseStack.translate((float)screenAccessor.getLeftPos(), (float)screenAccessor.getTopPos());
                    guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, SLOT_HIGHLIGHT_BACK_SPRITE, TrashSlotGuiHandler.trashSlot.x - 4, TrashSlotGuiHandler.trashSlot.y - 4, 24, 24);
                    poseStack.popMatrix();
                }
                TrashSlotSlot trashSlot = TrashSlotGuiHandler.trashSlot;
                SlotAccessor slotAccessor = (SlotAccessor)trashSlot;
                slotAccessor.setX(trashSlot.x + screenAccessor.getLeftPos());
                slotAccessor.setY(trashSlot.y + screenAccessor.getTopPos());
                screenAccessor.callRenderSlot(guiGraphics, (Slot)trashSlot, mouseX, mouseY);
                slotAccessor.setX(trashSlot.x - screenAccessor.getLeftPos());
                slotAccessor.setY(trashSlot.y - screenAccessor.getTopPos());
                if (hovering) {
                    poseStack.pushMatrix();
                    poseStack.translate((float)screenAccessor.getLeftPos(), (float)screenAccessor.getTopPos());
                    guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, SLOT_HIGHLIGHT_FRONT_SPRITE, trashSlot.x - 4, trashSlot.y - 4, 24, 24);
                    poseStack.popMatrix();
                }
                if (isMouseSlot = screenAccessor.callIsHovering((Slot)trashSlot, (double)mouseX, (double)mouseY)) {
                    if (containerScreen.getMenu().getCarried().isEmpty() && trashSlot.hasItem()) {
                        guiGraphics.setTooltipForNextFrame(Minecraft.getInstance().font, trashSlot.getItem(), mouseX, mouseY);
                    } else if (!trashSlotComponent.isDragging()) {
                        if (TrashSlotConfig.getActive().instantDeletion) {
                            guiGraphics.setTooltipForNextFrame(Minecraft.getInstance().font, (Component)Component.translatable((String)"tooltip.trashslot.destroy_item"), mouseX, mouseY);
                        } else {
                            guiGraphics.setTooltipForNextFrame(Minecraft.getInstance().font, (Component)Component.translatable((String)"tooltip.trashslot.trash_item"), mouseX, mouseY);
                        }
                    }
                }
            }
        }
        if (currentHint != null) {
            currentHint.render(screen, guiGraphics);
            if (currentHint.isComplete()) {
                TrashSlotSaveState.getInstance().markHintAsSeen(currentHint.getId());
                TrashSlotSaveState.save();
                currentHint = null;
            }
        }
    }

    public static TrashSlotComponent getTrashSlotComponent() {
        return trashSlotComponent;
    }

    public static TrashSlotSlot getTrashSlot() {
        return trashSlot;
    }

    public static boolean isLeftMouseDown() {
        return isLeftMouseDown;
    }

    static {
        currentContainerSettings = ContainerSettings.NONE;
    }
}

