/*
 * Decompiled with CFR 0.152.
 */
package net.irisshaders.iris.layer;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Objects;
import java.util.Optional;
import net.irisshaders.iris.layer.RenderingWrapper;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.rendertype.RenderSetup;
import net.minecraft.client.renderer.rendertype.RenderType;
import org.jetbrains.annotations.Nullable;

public class OuterWrappedRenderType
extends RenderType {
    private static final RenderSetup FAKE_SETUP = RenderSetup.builder((RenderPipeline)RenderPipelines.GUI_TEXTURED).createRenderSetup();
    private final RenderingWrapper extra;
    private final RenderType wrapped;

    public OuterWrappedRenderType(String name, RenderType wrapped, RenderingWrapper extra) {
        super(name, FAKE_SETUP);
        this.extra = extra;
        this.wrapped = wrapped;
    }

    public static OuterWrappedRenderType wrapExactlyOnce(String name, RenderType wrapped, RenderingWrapper extra) {
        while (wrapped instanceof OuterWrappedRenderType) {
            wrapped = ((OuterWrappedRenderType)wrapped).unwrap();
        }
        return new OuterWrappedRenderType(name, wrapped, extra);
    }

    private RenderType unwrap() {
        return this.wrapped;
    }

    public Optional<RenderType> outline() {
        return this.wrapped.outline();
    }

    public boolean isOutline() {
        return this.wrapped.isOutline();
    }

    public RenderPipeline pipeline() {
        return this.wrapped.pipeline();
    }

    public void draw(MeshData meshData) {
        this.extra.setup();
        this.wrapped.draw(meshData);
        this.extra.clear();
    }

    public boolean sortOnUpload() {
        return this.wrapped.sortOnUpload();
    }

    public RenderPipeline iris$getPipeline() {
        return this.wrapped.iris$getPipeline();
    }

    public RenderTarget iris$getRenderTarget() {
        return this.wrapped.iris$getRenderTarget();
    }

    public boolean canConsolidateConsecutiveGeometry() {
        return this.wrapped.canConsolidateConsecutiveGeometry();
    }

    public boolean affectsCrumbling() {
        return this.wrapped.affectsCrumbling();
    }

    public int bufferSize() {
        return this.wrapped.bufferSize();
    }

    public VertexFormat format() {
        return this.wrapped.format();
    }

    public VertexFormat.Mode mode() {
        return this.wrapped.mode();
    }

    public boolean equals(@Nullable Object object) {
        if (object == null) {
            return false;
        }
        if (object.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        OuterWrappedRenderType other = (OuterWrappedRenderType)((Object)object);
        return Objects.equals(this.wrapped, other.wrapped) && Objects.equals(this.extra, other.extra);
    }

    public int hashCode() {
        return this.wrapped.hashCode() + 1;
    }

    public String toString() {
        return "iris_wrapped:" + this.wrapped.toString();
    }
}

