/*
 * Decompiled with CFR 0.152.
 */
package net.irisshaders.iris.mixin;

import com.mojang.blaze3d.opengl.GlCommandEncoder;
import com.mojang.blaze3d.opengl.GlConst;
import com.mojang.blaze3d.opengl.GlProgram;
import com.mojang.blaze3d.opengl.GlRenderPass;
import com.mojang.blaze3d.opengl.GlStateManager;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.platform.DepthTestFunction;
import com.mojang.blaze3d.platform.PolygonMode;
import com.mojang.blaze3d.textures.GpuTextureView;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.irisshaders.iris.Iris;
import net.irisshaders.iris.gl.blending.DepthColorStorage;
import net.irisshaders.iris.pipeline.IrisRenderingPipeline;
import net.irisshaders.iris.pipeline.WorldRenderingPipeline;
import net.irisshaders.iris.pipeline.programs.ExtendedShader;
import net.irisshaders.iris.pipeline.programs.IrisProgram;
import net.irisshaders.iris.shadows.ShadowRenderingState;
import net.irisshaders.iris.vertices.ImmediateState;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={GlCommandEncoder.class})
public class MixinGlCommandEncoder {
    @Shadow
    @Nullable
    private RenderPipeline lastPipeline;
    @Shadow
    private boolean inRenderPass;
    @Shadow
    @Nullable
    private GlProgram lastProgram;
    @Unique
    private int tempFBO;
    @Unique
    private List<IrisProgram> programsToClear = new ArrayList<IrisProgram>();
    @Unique
    private static GlRenderPass lastPass;

    @Redirect(method={"createRenderPass(Ljava/util/function/Supplier;Lcom/mojang/blaze3d/textures/GpuTextureView;Ljava/util/OptionalInt;Lcom/mojang/blaze3d/textures/GpuTextureView;Ljava/util/OptionalDouble;)Lcom/mojang/blaze3d/systems/RenderPass;"}, at=@At(value="INVOKE", target="Lcom/mojang/blaze3d/opengl/GlStateManager;_viewport(IIII)V"))
    private void changeViewport(int i, int j, int k, int l) {
        if (ShadowRenderingState.areShadowsCurrentlyBeingRendered()) {
            return;
        }
        GlStateManager._viewport((int)i, (int)j, (int)k, (int)l);
    }

    @Redirect(method={"createRenderPass(Ljava/util/function/Supplier;Lcom/mojang/blaze3d/textures/GpuTextureView;Ljava/util/OptionalInt;Lcom/mojang/blaze3d/textures/GpuTextureView;Ljava/util/OptionalDouble;)Lcom/mojang/blaze3d/systems/RenderPass;"}, at=@At(value="INVOKE", target="Lcom/mojang/blaze3d/opengl/GlStateManager;_glBindFramebuffer(II)V"))
    private void changeFramebuffer(int i, int j) {
        if (ShadowRenderingState.areShadowsCurrentlyBeingRendered() || ImmediateState.safeToMultiply) {
            this.tempFBO = j;
            return;
        }
        GlStateManager._glBindFramebuffer((int)i, (int)j);
    }

    @Redirect(method={"finishRenderPass"}, at=@At(value="INVOKE", target="Lcom/mojang/blaze3d/opengl/GlStateManager;_glBindFramebuffer(II)V"))
    private void finishFramebuffer(int i, int j) {
        if (!ImmediateState.safeToMultiply) {
            GlStateManager._glBindFramebuffer((int)i, (int)j);
        }
    }

    @Redirect(method={"writeToBuffer"}, at=@At(value="FIELD", target="Lcom/mojang/blaze3d/opengl/GlCommandEncoder;inRenderPass:Z"))
    private boolean ignore(GlCommandEncoder instance) {
        if (ImmediateState.temporarilyIgnorePass) {
            return false;
        }
        return this.inRenderPass;
    }

    @Redirect(method={"writeToTexture(Lcom/mojang/blaze3d/textures/GpuTexture;Ljava/nio/ByteBuffer;Lcom/mojang/blaze3d/platform/NativeImage$Format;IIIIII)V", "writeToTexture(Lcom/mojang/blaze3d/textures/GpuTexture;Lcom/mojang/blaze3d/platform/NativeImage;IIIIIIII)V"}, at=@At(value="FIELD", target="Lcom/mojang/blaze3d/opengl/GlCommandEncoder;inRenderPass:Z"))
    private boolean ignore2(GlCommandEncoder instance) {
        if (ImmediateState.temporarilyIgnorePass) {
            return false;
        }
        return this.inRenderPass;
    }

    @Redirect(method={"createRenderPass(Ljava/util/function/Supplier;Lcom/mojang/blaze3d/textures/GpuTextureView;Ljava/util/OptionalInt;Lcom/mojang/blaze3d/textures/GpuTextureView;Ljava/util/OptionalDouble;)Lcom/mojang/blaze3d/systems/RenderPass;"}, at=@At(value="FIELD", target="Lcom/mojang/blaze3d/opengl/GlCommandEncoder;inRenderPass:Z", ordinal=0))
    private boolean ignore3(GlCommandEncoder instance) {
        if (ImmediateState.temporarilyIgnorePass) {
            return false;
        }
        return this.inRenderPass;
    }

    @Inject(method={"trySetup"}, at={@At(value="HEAD")}, cancellable=true)
    private void iris$bypassSetup(GlRenderPass glRenderPass, Collection<String> collection, CallbackInfoReturnable<Boolean> cir) {
        DepthColorStorage.unlockDepthColor();
        if (ImmediateState.safeToMultiply && !(glRenderPass.pipeline.program() instanceof ExtendedShader)) {
            GlStateManager._glBindFramebuffer((int)36160, (int)this.tempFBO);
        }
        lastPass = glRenderPass;
        if (glRenderPass.iris$getCustomPass() != null) {
            this.lastProgram = null;
            cir.setReturnValue((Object)true);
            glRenderPass.iris$getCustomPass().setupState();
            RenderPipeline renderPipeline = glRenderPass.pipeline.info();
            if (glRenderPass.isScissorEnabled()) {
                GlStateManager._enableScissorTest();
                GlStateManager._scissorBox((int)glRenderPass.getScissorX(), (int)glRenderPass.getScissorY(), (int)glRenderPass.getScissorWidth(), (int)glRenderPass.getScissorHeight());
            } else {
                GlStateManager._disableScissorTest();
            }
            if (this.lastPipeline != renderPipeline) {
                this.lastPipeline = renderPipeline;
                if (renderPipeline.getDepthTestFunction() != DepthTestFunction.NO_DEPTH_TEST) {
                    GlStateManager._enableDepthTest();
                    GlStateManager._depthFunc((int)GlConst.toGl((DepthTestFunction)renderPipeline.getDepthTestFunction()));
                } else {
                    GlStateManager._disableDepthTest();
                }
                if (renderPipeline.isCull()) {
                    GlStateManager._enableCull();
                } else {
                    GlStateManager._disableCull();
                }
                GlStateManager._polygonMode((int)1032, (int)GlConst.toGl((PolygonMode)renderPipeline.getPolygonMode()));
                GlStateManager._depthMask((boolean)renderPipeline.isWriteDepth());
                GlStateManager._colorMask((boolean)renderPipeline.isWriteColor(), (boolean)renderPipeline.isWriteColor(), (boolean)renderPipeline.isWriteColor(), (boolean)renderPipeline.isWriteAlpha());
                if (renderPipeline.getDepthBiasConstant() == 0.0f && renderPipeline.getDepthBiasScaleFactor() == 0.0f) {
                    GlStateManager._disablePolygonOffset();
                } else {
                    GlStateManager._polygonOffset((float)renderPipeline.getDepthBiasScaleFactor(), (float)renderPipeline.getDepthBiasConstant());
                    GlStateManager._enablePolygonOffset();
                }
                switch (renderPipeline.getColorLogic()) {
                    case NONE: {
                        GlStateManager._disableColorLogicOp();
                        break;
                    }
                    case OR_REVERSE: {
                        GlStateManager._enableColorLogicOp();
                        GlStateManager._logicOp((int)5387);
                    }
                }
            }
        }
    }

    @Inject(method={"trySetup"}, at={@At(value="RETURN")})
    private void iris$setupState(GlRenderPass glRenderPass, Collection<String> collection, CallbackInfoReturnable<Boolean> cir) {
        IrisProgram is;
        GlProgram glProgram = glRenderPass.pipeline.program();
        if (glProgram instanceof IrisProgram && !(is = (IrisProgram)glProgram).iris$isSetUp()) {
            WorldRenderingPipeline worldRenderingPipeline;
            GlRenderPass.TextureViewAndSampler sam = (GlRenderPass.TextureViewAndSampler)glRenderPass.samplers.get("Sampler0");
            if (sam != null && (worldRenderingPipeline = Iris.getPipelineManager().getPipelineNullable()) instanceof IrisRenderingPipeline) {
                IrisRenderingPipeline irp = (IrisRenderingPipeline)worldRenderingPipeline;
                irp.onSetAlbedoTex((GpuTextureView)sam.view());
            }
            is.iris$setupState((GpuTextureView)(sam == null ? null : sam.view()));
            this.programsToClear.add(is);
        }
    }

    @Inject(method={"finishRenderPass"}, at={@At(value="HEAD")})
    private void iris$clearState(CallbackInfo ci) {
        this.programsToClear.forEach(IrisProgram::iris$clearState);
        this.programsToClear.clear();
    }
}

