/*
 * Decompiled with CFR 0.152.
 */
package net.irisshaders.iris.mixin.entity_render_context;

import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalIntRef;
import com.mojang.blaze3d.vertex.PoseStack;
import net.irisshaders.iris.mixinterface.ItemContextState;
import net.irisshaders.iris.shaderpack.materialmap.NamespacedId;
import net.irisshaders.iris.shaderpack.materialmap.WorldRenderingSettings;
import net.irisshaders.iris.uniforms.CapturedRenderingState;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.Identifier;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SolidBucketItem;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemStackRenderState.LayerRenderState.class})
public class ItemStackStateLayerMixin {
    @Unique
    private ItemStackRenderState parentState;

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void iris$catchParent(ItemStackRenderState itemStackRenderState, CallbackInfo ci) {
        this.parentState = itemStackRenderState;
    }

    @Inject(method={"submit"}, at={@At(value="HEAD")})
    private void onRender(PoseStack poseStack, SubmitNodeCollector submitNodeCollector, int i, int j, int k, CallbackInfo ci, @Share(value="lastBState") LocalIntRef ref) {
        ref.set(CapturedRenderingState.INSTANCE.getCurrentRenderedBlockEntity());
        this.iris$setupId(((ItemContextState)this.parentState).getDisplayItem(), ((ItemContextState)this.parentState).getDisplayItemModel());
    }

    @Inject(method={"submit"}, at={@At(value="TAIL")})
    private void onRenderEnd(PoseStack poseStack, SubmitNodeCollector submitNodeCollector, int i, int j, int k, CallbackInfo ci, @Share(value="lastBState") LocalIntRef ref) {
        CapturedRenderingState.INSTANCE.setCurrentBlockEntity(ref.get());
        CapturedRenderingState.INSTANCE.setCurrentRenderedItem(0);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Unique
    private void iris$setupId(Item item, Identifier modelId) {
        if (WorldRenderingSettings.INSTANCE.getItemIds() == null) {
            return;
        }
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            if (!(item instanceof SolidBucketItem)) {
                if (WorldRenderingSettings.INSTANCE.getBlockStateIds() == null) {
                    return;
                }
                CapturedRenderingState.INSTANCE.setCurrentBlockEntity(1);
                CapturedRenderingState.INSTANCE.setCurrentRenderedItem(WorldRenderingSettings.INSTANCE.getBlockStateIds().getOrDefault((Object)blockItem.getBlock().defaultBlockState(), 0));
                return;
            }
        }
        Identifier location = modelId != null ? modelId : BuiltInRegistries.ITEM.getKey((Object)item);
        CapturedRenderingState.INSTANCE.setCurrentRenderedItem(WorldRenderingSettings.INSTANCE.getItemIds().applyAsInt((Object)new NamespacedId(location.getNamespace(), location.getPath())));
    }
}

