/*
 * Decompiled with CFR 0.152.
 */
package net.irisshaders.iris.pathways;

import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderPipelines;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.joml.Vector4fc;

public class HorizonRenderer {
    private static final float TOP = 16.0f;
    private static final float BOTTOM = -16.0f;
    private GpuBuffer buffer;
    private int currentRenderDistance;
    private int indexCount = -1;

    public HorizonRenderer() {
        this.currentRenderDistance = Minecraft.getInstance().options.getEffectiveRenderDistance();
        this.rebuildBuffer();
    }

    private void rebuildBuffer() {
        if (this.buffer != null) {
            this.buffer.close();
        }
        BufferBuilder buffer = Tesselator.getInstance().begin(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.POSITION);
        this.buildHorizon(this.currentRenderDistance * 16, (VertexConsumer)buffer);
        MeshData meshData = buffer.buildOrThrow();
        this.buffer = RenderSystem.getDevice().createBuffer(() -> "Horizon", 40, meshData.vertexBuffer());
        this.indexCount = meshData.drawState().indexCount();
        meshData.close();
        Tesselator.getInstance().clear();
    }

    private void buildHorizon(int radius, VertexConsumer consumer) {
        if (radius > 256) {
            radius = 256;
        }
        consumer.addVertex(0.0f, -16.0f, 0.0f);
        for (int i = 0; i <= 8; ++i) {
            float angle = (float)((double)(-i) * Math.PI / 4.0);
            float x = (float)((double)radius * Math.cos(angle));
            float z = (float)((double)radius * Math.sin(angle));
            consumer.addVertex(x, 16.0f, z);
        }
    }

    public void renderHorizon(Matrix4fc modelView, Matrix4fc projection, Vector4f fogColor) {
        if (this.currentRenderDistance != Minecraft.getInstance().options.getEffectiveRenderDistance()) {
            this.currentRenderDistance = Minecraft.getInstance().options.getEffectiveRenderDistance();
            this.rebuildBuffer();
        }
        RenderSystem.AutoStorageIndexBuffer indices = RenderSystem.getSequentialBuffer((VertexFormat.Mode)VertexFormat.Mode.TRIANGLE_FAN);
        GpuBuffer indexBuffer = indices.getBuffer(this.indexCount);
        GpuBufferSlice gpuBufferSlice = RenderSystem.getDynamicUniforms().writeTransform(modelView, (Vector4fc)fogColor, (Vector3fc)new Vector3f(), (Matrix4fc)new Matrix4f());
        try (RenderPass pass = RenderSystem.getDevice().createCommandEncoder().createRenderPass(() -> "Sky", Minecraft.getInstance().getMainRenderTarget().getColorTextureView(), OptionalInt.empty(), Minecraft.getInstance().getMainRenderTarget().getDepthTextureView(), OptionalDouble.empty());){
            RenderSystem.bindDefaultUniforms((RenderPass)pass);
            pass.setUniform("DynamicTransforms", gpuBufferSlice);
            pass.setVertexBuffer(0, this.buffer);
            pass.setIndexBuffer(indexBuffer, indices.type());
            pass.setPipeline(RenderPipelines.SKY);
            pass.drawIndexed(0, 0, this.indexCount, 1);
        }
    }

    public void destroy() {
        this.buffer.close();
    }
}

