/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.biolith.impl.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.terraformersmc.biolith.api.biome.sub.Criterion;
import com.terraformersmc.biolith.impl.Biolith;
import com.terraformersmc.biolith.impl.biome.BiomeCoordinator;
import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.dimension.DimensionType;

public record BiomePlacementMarshaller(List<AddBiomeMarshaller> additions, List<RemoveBiomeMarshaller> removals, List<ReplaceBiomeMarshaller> replacements, List<AddSubBiomeMarshaller> subBiomes) {
    public static final Codec<BiomePlacementMarshaller> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)AddBiomeMarshaller.CODEC.listOf().optionalFieldOf("additions", List.of()).forGetter(BiomePlacementMarshaller::additions), (App)RemoveBiomeMarshaller.CODEC.listOf().optionalFieldOf("removals", List.of()).forGetter(BiomePlacementMarshaller::removals), (App)ReplaceBiomeMarshaller.CODEC.listOf().optionalFieldOf("replacements", List.of()).forGetter(BiomePlacementMarshaller::replacements), (App)AddSubBiomeMarshaller.CODEC.listOf().optionalFieldOf("sub_biomes", List.of()).forGetter(BiomePlacementMarshaller::subBiomes)).apply((Applicative)instance, BiomePlacementMarshaller::new));

    public void unmarshall() {
        for (AddBiomeMarshaller addBiomeMarshaller : this.additions) {
            addBiomeMarshaller.unmarshall();
        }
        for (RemoveBiomeMarshaller removeBiomeMarshaller : this.removals) {
            removeBiomeMarshaller.unmarshall();
        }
        for (ReplaceBiomeMarshaller replaceBiomeMarshaller : this.replacements) {
            replaceBiomeMarshaller.unmarshall();
        }
        for (AddSubBiomeMarshaller addSubBiomeMarshaller : this.subBiomes) {
            addSubBiomeMarshaller.unmarshall();
        }
    }

    public record AddBiomeMarshaller(ResourceKey<DimensionType> dimension, ResourceKey<Biome> biome, Climate.ParameterPoint noisePoint) {
        public static Codec<AddBiomeMarshaller> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceKey.codec((ResourceKey)Registries.DIMENSION_TYPE).fieldOf("dimension").forGetter(AddBiomeMarshaller::dimension), (App)ResourceKey.codec((ResourceKey)Registries.BIOME).fieldOf("biome").forGetter(AddBiomeMarshaller::biome), (App)Climate.ParameterPoint.CODEC.fieldOf("noise").forGetter(AddBiomeMarshaller::noisePoint)).apply((Applicative)instance, AddBiomeMarshaller::new));

        public void unmarshall() {
            if (this.dimension.equals((Object)BuiltinDimensionTypes.OVERWORLD)) {
                BiomeCoordinator.OVERWORLD.addPlacement(this.biome, this.noisePoint, true);
            } else if (this.dimension.equals((Object)BuiltinDimensionTypes.NETHER)) {
                BiomeCoordinator.NETHER.addPlacement(this.biome, this.noisePoint, true);
            } else if (this.dimension.equals((Object)BuiltinDimensionTypes.END)) {
                BiomeCoordinator.END.addPlacement(this.biome, this.noisePoint, true);
            } else {
                Biolith.LOGGER.warn("Ignored unknown dimension type '{}' while serializing biome placement.", (Object)this.dimension.identifier());
            }
        }
    }

    public record RemoveBiomeMarshaller(ResourceKey<DimensionType> dimension, ResourceKey<Biome> biome) {
        public static Codec<RemoveBiomeMarshaller> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceKey.codec((ResourceKey)Registries.DIMENSION_TYPE).fieldOf("dimension").forGetter(RemoveBiomeMarshaller::dimension), (App)ResourceKey.codec((ResourceKey)Registries.BIOME).fieldOf("biome").forGetter(RemoveBiomeMarshaller::biome)).apply((Applicative)instance, RemoveBiomeMarshaller::new));

        public void unmarshall() {
            if (this.dimension.equals((Object)BuiltinDimensionTypes.OVERWORLD)) {
                BiomeCoordinator.OVERWORLD.addRemoval(this.biome, true);
            } else if (this.dimension.equals((Object)BuiltinDimensionTypes.NETHER)) {
                BiomeCoordinator.NETHER.addRemoval(this.biome, true);
            } else if (this.dimension.equals((Object)BuiltinDimensionTypes.END)) {
                BiomeCoordinator.END.addRemoval(this.biome, true);
            } else {
                Biolith.LOGGER.warn("Ignored unknown dimension type '{}' while serializing biome placement.", (Object)this.dimension.identifier());
            }
        }
    }

    public record ReplaceBiomeMarshaller(ResourceKey<DimensionType> dimension, ResourceKey<Biome> target, ResourceKey<Biome> biome, double proportion) {
        public static Codec<ReplaceBiomeMarshaller> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceKey.codec((ResourceKey)Registries.DIMENSION_TYPE).fieldOf("dimension").forGetter(ReplaceBiomeMarshaller::dimension), (App)ResourceKey.codec((ResourceKey)Registries.BIOME).fieldOf("target").forGetter(ReplaceBiomeMarshaller::target), (App)ResourceKey.codec((ResourceKey)Registries.BIOME).fieldOf("biome").forGetter(ReplaceBiomeMarshaller::biome), (App)Codec.DOUBLE.optionalFieldOf("proportion", (Object)1.0).forGetter(ReplaceBiomeMarshaller::proportion)).apply((Applicative)instance, ReplaceBiomeMarshaller::new));

        public void unmarshall() {
            if (this.dimension.equals((Object)BuiltinDimensionTypes.OVERWORLD)) {
                BiomeCoordinator.OVERWORLD.addReplacement(this.target, this.biome, this.proportion, true);
            } else if (this.dimension.equals((Object)BuiltinDimensionTypes.NETHER)) {
                BiomeCoordinator.NETHER.addReplacement(this.target, this.biome, this.proportion, true);
            } else if (this.dimension.equals((Object)BuiltinDimensionTypes.END)) {
                BiomeCoordinator.END.addReplacement(this.target, this.biome, this.proportion, true);
            } else {
                Biolith.LOGGER.warn("Ignored unknown dimension type '{}' while serializing biome placement.", (Object)this.dimension.identifier());
            }
        }
    }

    public record AddSubBiomeMarshaller(ResourceKey<DimensionType> dimension, ResourceKey<Biome> target, ResourceKey<Biome> biome, Criterion criterion) {
        public static Codec<AddSubBiomeMarshaller> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceKey.codec((ResourceKey)Registries.DIMENSION_TYPE).fieldOf("dimension").forGetter(AddSubBiomeMarshaller::dimension), (App)ResourceKey.codec((ResourceKey)Registries.BIOME).fieldOf("target").forGetter(AddSubBiomeMarshaller::target), (App)ResourceKey.codec((ResourceKey)Registries.BIOME).fieldOf("biome").forGetter(AddSubBiomeMarshaller::biome), (App)Criterion.MATCHER_CODEC.fieldOf("criterion").forGetter(AddSubBiomeMarshaller::criterion)).apply((Applicative)instance, AddSubBiomeMarshaller::new));

        public void unmarshall() {
            if (this.dimension.equals((Object)BuiltinDimensionTypes.OVERWORLD)) {
                BiomeCoordinator.OVERWORLD.addSubBiome(this.target, this.biome, this.criterion, true);
            } else if (this.dimension.equals((Object)BuiltinDimensionTypes.NETHER)) {
                BiomeCoordinator.NETHER.addSubBiome(this.target, this.biome, this.criterion, true);
            } else if (this.dimension.equals((Object)BuiltinDimensionTypes.END)) {
                BiomeCoordinator.END.addSubBiome(this.target, this.biome, this.criterion, true);
            } else {
                Biolith.LOGGER.warn("Ignored unknown dimension type '{}' while serializing biome placement.", (Object)this.dimension.identifier());
            }
        }
    }
}

