/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft;

import com.google.common.base.Suppliers;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.OctahedralGroup;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCClientEventHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.IDisguisable;
import net.geforcemods.securitycraft.api.IPasscodeProtected;
import net.geforcemods.securitycraft.api.IReinforcedBlock;
import net.geforcemods.securitycraft.blockentities.AlarmBlockEntity;
import net.geforcemods.securitycraft.blockentities.FrameBlockEntity;
import net.geforcemods.securitycraft.blockentities.InventoryScannerBlockEntity;
import net.geforcemods.securitycraft.blockentities.LaserBlockBlockEntity;
import net.geforcemods.securitycraft.blockentities.RiftStabilizerBlockEntity;
import net.geforcemods.securitycraft.blockentities.SecretHangingSignBlockEntity;
import net.geforcemods.securitycraft.blockentities.SecretSignBlockEntity;
import net.geforcemods.securitycraft.blockentities.SecureRedstoneInterfaceBlockEntity;
import net.geforcemods.securitycraft.blockentities.SonicSecuritySystemBlockEntity;
import net.geforcemods.securitycraft.blockentities.UsernameLoggerBlockEntity;
import net.geforcemods.securitycraft.blocks.InventoryScannerFieldBlock;
import net.geforcemods.securitycraft.blocks.LaserFieldBlock;
import net.geforcemods.securitycraft.blocks.SecureRedstoneInterfaceBlock;
import net.geforcemods.securitycraft.components.SavedBlockState;
import net.geforcemods.securitycraft.entity.camera.SecurityCamera;
import net.geforcemods.securitycraft.items.properties.BlockLinked;
import net.geforcemods.securitycraft.items.properties.CodebreakerState;
import net.geforcemods.securitycraft.items.properties.KeycardCount;
import net.geforcemods.securitycraft.items.properties.ReinforcedTint;
import net.geforcemods.securitycraft.items.properties.SentryLinked;
import net.geforcemods.securitycraft.misc.LayerToggleHandler;
import net.geforcemods.securitycraft.models.BulletModel;
import net.geforcemods.securitycraft.models.DisguisableBlockStateModel;
import net.geforcemods.securitycraft.models.DisplayCaseModel;
import net.geforcemods.securitycraft.models.IMSBombModel;
import net.geforcemods.securitycraft.models.SecureRedstoneInterfaceBlockStateModel;
import net.geforcemods.securitycraft.models.SecureRedstoneInterfaceDishModel;
import net.geforcemods.securitycraft.models.SecurityCameraModel;
import net.geforcemods.securitycraft.models.SentryModel;
import net.geforcemods.securitycraft.models.SonicSecuritySystemModel;
import net.geforcemods.securitycraft.network.client.BlockPocketManagerFailedActivation;
import net.geforcemods.securitycraft.network.client.InteractWithFrame;
import net.geforcemods.securitycraft.network.client.OpenScreen;
import net.geforcemods.securitycraft.network.client.PlayAlarmSound;
import net.geforcemods.securitycraft.network.client.RefreshDisguisableModel;
import net.geforcemods.securitycraft.network.client.SendManualPages;
import net.geforcemods.securitycraft.network.client.SetCameraView;
import net.geforcemods.securitycraft.network.client.SetTrophySystemTarget;
import net.geforcemods.securitycraft.network.client.UpdateLaserColors;
import net.geforcemods.securitycraft.network.client.UpdateLogger;
import net.geforcemods.securitycraft.particle.FloorTrapCloudParticle;
import net.geforcemods.securitycraft.particle.InterfaceHighlightParticle;
import net.geforcemods.securitycraft.renderers.BlockPocketManagerRenderer;
import net.geforcemods.securitycraft.renderers.BouncingBettyRenderer;
import net.geforcemods.securitycraft.renderers.BulletRenderer;
import net.geforcemods.securitycraft.renderers.ClaymoreRenderer;
import net.geforcemods.securitycraft.renderers.DisguisableBlockEntityRenderer;
import net.geforcemods.securitycraft.renderers.DisplayCaseRenderer;
import net.geforcemods.securitycraft.renderers.DisplayCaseSpecialRenderer;
import net.geforcemods.securitycraft.renderers.FrameBlockEntityRenderer;
import net.geforcemods.securitycraft.renderers.IMSBombRenderer;
import net.geforcemods.securitycraft.renderers.KeypadChestRenderer;
import net.geforcemods.securitycraft.renderers.ProjectorRenderer;
import net.geforcemods.securitycraft.renderers.ReinforcedPistonHeadRenderer;
import net.geforcemods.securitycraft.renderers.RetinalScannerRenderer;
import net.geforcemods.securitycraft.renderers.SecretHangingSignRenderer;
import net.geforcemods.securitycraft.renderers.SecretSignRenderer;
import net.geforcemods.securitycraft.renderers.SecureRedstoneInterfaceRenderer;
import net.geforcemods.securitycraft.renderers.SecurityCameraRenderer;
import net.geforcemods.securitycraft.renderers.SecurityCameraSpecialRenderer;
import net.geforcemods.securitycraft.renderers.SecuritySeaBoatRenderer;
import net.geforcemods.securitycraft.renderers.SecuritySeaRaftRenderer;
import net.geforcemods.securitycraft.renderers.SentryRenderer;
import net.geforcemods.securitycraft.renderers.SonicSecuritySystemRenderer;
import net.geforcemods.securitycraft.renderers.TrophySystemRenderer;
import net.geforcemods.securitycraft.screen.AlarmScreen;
import net.geforcemods.securitycraft.screen.BlockChangeDetectorScreen;
import net.geforcemods.securitycraft.screen.BlockPocketManagerScreen;
import net.geforcemods.securitycraft.screen.BlockReinforcerScreen;
import net.geforcemods.securitycraft.screen.BriefcasePasscodeScreen;
import net.geforcemods.securitycraft.screen.CameraMonitorScreen;
import net.geforcemods.securitycraft.screen.CheckPasscodeScreen;
import net.geforcemods.securitycraft.screen.CustomizeBlockScreen;
import net.geforcemods.securitycraft.screen.DisguiseModuleScreen;
import net.geforcemods.securitycraft.screen.EditModuleScreen;
import net.geforcemods.securitycraft.screen.FrameScreen;
import net.geforcemods.securitycraft.screen.InventoryScannerScreen;
import net.geforcemods.securitycraft.screen.ItemInventoryScreen;
import net.geforcemods.securitycraft.screen.KeyChangerScreen;
import net.geforcemods.securitycraft.screen.KeycardReaderScreen;
import net.geforcemods.securitycraft.screen.KeypadBlastFurnaceScreen;
import net.geforcemods.securitycraft.screen.KeypadFurnaceScreen;
import net.geforcemods.securitycraft.screen.KeypadSmokerScreen;
import net.geforcemods.securitycraft.screen.LaserBlockScreen;
import net.geforcemods.securitycraft.screen.MineRemoteAccessToolScreen;
import net.geforcemods.securitycraft.screen.ProjectorScreen;
import net.geforcemods.securitycraft.screen.ReinforcedLecternScreen;
import net.geforcemods.securitycraft.screen.RiftStabilizerScreen;
import net.geforcemods.securitycraft.screen.SCManualScreen;
import net.geforcemods.securitycraft.screen.SSSItemScreen;
import net.geforcemods.securitycraft.screen.SecureRedstoneInterfaceScreen;
import net.geforcemods.securitycraft.screen.SentryRemoteAccessToolScreen;
import net.geforcemods.securitycraft.screen.SetPasscodeScreen;
import net.geforcemods.securitycraft.screen.SingleLensScreen;
import net.geforcemods.securitycraft.screen.SonicSecuritySystemScreen;
import net.geforcemods.securitycraft.screen.TrophySystemScreen;
import net.geforcemods.securitycraft.screen.UsernameLoggerScreen;
import net.geforcemods.securitycraft.screen.components.GuiBlockModelRenderState;
import net.geforcemods.securitycraft.screen.components.GuiBlockModelRenderer;
import net.geforcemods.securitycraft.util.BlockEntityRenderDelegate;
import net.geforcemods.securitycraft.util.Reinforced;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.HangingSignEditScreen;
import net.minecraft.client.gui.screens.inventory.SignEditScreen;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.blockentity.LecternRenderer;
import net.minecraft.client.renderer.blockentity.ShelfRenderer;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;
import net.minecraft.client.renderer.entity.NoopRenderer;
import net.minecraft.client.renderer.rendertype.LayeringTransform;
import net.minecraft.client.renderer.rendertype.OutputTarget;
import net.minecraft.client.renderer.rendertype.RenderSetup;
import net.minecraft.client.renderer.rendertype.RenderType;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;
import net.minecraft.util.ARGB;
import net.minecraft.util.Util;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GrassColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SnowyDirtBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.asm.enumextension.EnumProxy;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.client.event.RegisterParticleProvidersEvent;
import net.neoforged.neoforge.client.event.RegisterPictureInPictureRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterRangeSelectItemModelPropertyEvent;
import net.neoforged.neoforge.client.event.RegisterRenderPipelinesEvent;
import net.neoforged.neoforge.client.event.RegisterSelectItemModelPropertyEvent;
import net.neoforged.neoforge.client.event.RegisterSpecialModelRendererEvent;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.client.model.standalone.SimpleUnbakedStandaloneModel;
import net.neoforged.neoforge.client.model.standalone.StandaloneModelKey;
import net.neoforged.neoforge.client.model.standalone.StandaloneModelLoader;
import net.neoforged.neoforge.client.model.standalone.UnbakedStandaloneModel;
import net.neoforged.neoforge.client.network.event.RegisterClientPayloadHandlersEvent;
import net.neoforged.neoforge.registries.DeferredBlock;

@EventBusSubscriber(modid="securitycraft", value={Dist.CLIENT})
public class ClientHandler {
    public static final ModelLayerLocation BULLET_LOCATION = new ModelLayerLocation(SecurityCraft.resLoc("bullet"), "main");
    public static final ModelLayerLocation IMS_BOMB_LOCATION = new ModelLayerLocation(SecurityCraft.resLoc("ims_bomb"), "main");
    public static final ModelLayerLocation DISPLAY_CASE_LOCATION = new ModelLayerLocation(SecurityCraft.resLoc("display_case"), "main");
    public static final ModelLayerLocation SENTRY_LOCATION = new ModelLayerLocation(SecurityCraft.resLoc("sentry"), "main");
    public static final ModelLayerLocation SECURE_REDSTONE_INTERFACE_DISH_LAYER_LOCATION = new ModelLayerLocation(SecurityCraft.resLoc("secure_redstone_interface_dish"), "main");
    public static final ModelLayerLocation SECURITY_CAMERA_LOCATION = new ModelLayerLocation(SecurityCraft.resLoc("security_camera"), "main");
    public static final ModelLayerLocation SONIC_SECURITY_SYSTEM_LOCATION = new ModelLayerLocation(SecurityCraft.resLoc("sonic_security_system"), "main");
    public static final BlockEntityRenderDelegate DISGUISED_BLOCK_RENDER_DELEGATE = new BlockEntityRenderDelegate();
    public static final BlockEntityRenderDelegate PROJECTOR_RENDER_DELEGATE = new BlockEntityRenderDelegate();
    public static final Identifier CAMERA_LAYER = SecurityCraft.resLoc("camera_overlay");
    private static Map<Block, Integer> blocksWithReinforcedTint = new HashMap<Block, Integer>();
    private static Map<Block, Integer> blocksWithCustomTint = new HashMap<Block, Integer>();
    private static Supplier<Block[]> disguisableBlocks = Suppliers.memoize(() -> new Block[]{(Block)SCContent.BLOCK_CHANGE_DETECTOR.get(), (Block)SCContent.CAGE_TRAP.get(), (Block)SCContent.FLOOR_TRAP.get(), (Block)SCContent.INVENTORY_SCANNER.get(), (Block)SCContent.KEYCARD_READER.get(), (Block)SCContent.KEYPAD.get(), (Block)SCContent.KEYPAD_BARREL.get(), (Block)SCContent.KEYPAD_BLAST_FURNACE.get(), (Block)SCContent.KEYPAD_CHEST.get(), (Block)SCContent.KEYPAD_DOOR.get(), (Block)SCContent.KEYPAD_FURNACE.get(), (Block)SCContent.KEYPAD_SMOKER.get(), (Block)SCContent.KEYPAD_TRAPDOOR.get(), (Block)SCContent.LASER_BLOCK.get(), (Block)SCContent.PROJECTOR.get(), (Block)SCContent.PROTECTO.get(), (Block)SCContent.REINFORCED_DISPENSER.get(), (Block)SCContent.REINFORCED_DROPPER.get(), (Block)SCContent.REINFORCED_HOPPER.get(), (Block)SCContent.REINFORCED_OBSERVER.get(), (Block)SCContent.RETINAL_SCANNER.get(), (Block)SCContent.RIFT_STABILIZER.get(), (Block)SCContent.SCANNER_DOOR.get(), (Block)SCContent.SCANNER_TRAPDOOR.get(), (Block)SCContent.SECURITY_CAMERA.get(), (Block)SCContent.SENTRY_DISGUISE.get(), (Block)SCContent.SONIC_SECURITY_SYSTEM.get(), (Block)SCContent.TROPHY_SYSTEM.get(), (Block)SCContent.USERNAME_LOGGER.get()});
    private static final Identifier SRI_BASE_MODEL_LOCATION = SecurityCraft.resLoc("block/secure_redstone_interface");
    private static final Identifier SRI_SENDER_ON_MODEL_LOCATION = SRI_BASE_MODEL_LOCATION.withSuffix("_sender_on");
    private static final Identifier SRI_RECEIVER_ON_MODEL_LOCATION = SRI_BASE_MODEL_LOCATION.withSuffix("_receiver_on");
    private static final Map<SRIKey, StandaloneModelKey<BlockStateModel>> SRI_MODEL_KEYS = (Map)Util.make(new HashMap(), map -> Arrays.stream(Direction.values()).forEach(direction -> {
        map.put(new SRIKey(true, (Direction)direction), new StandaloneModelKey(() -> String.valueOf(SRI_SENDER_ON_MODEL_LOCATION) + "$" + direction.getName()));
        map.put(new SRIKey(false, (Direction)direction), new StandaloneModelKey(() -> String.valueOf(SRI_RECEIVER_ON_MODEL_LOCATION) + "$" + direction.getName()));
    }));
    public static final RenderType OVERLAY_LINES = RenderType.create((String)"overlay_lines", (RenderSetup)RenderSetup.builder((RenderPipeline)RenderPipelines.LINES).setLayeringTransform(LayeringTransform.VIEW_OFFSET_Z_LAYERING).setOutputTarget(OutputTarget.OUTLINE_TARGET).createRenderSetup());
    public static final EnumProxy<HumanoidModel.ArmPose> TASER_ARM_POSE_PARAMS = new EnumProxy(HumanoidModel.ArmPose.class, new Object[]{true, true, (model, entity, arm) -> {
        ModelPart leftArm = model.leftArm;
        ModelPart rightArm = model.rightArm;
        leftArm.yRot = 0.5f;
        rightArm.yRot = -0.5f;
        rightArm.xRot = -1.5f;
        leftArm.xRot = -1.5f;
    }});

    private ClientHandler() {
    }

    @SubscribeEvent
    public static void onModelRegisterAdditional(ModelEvent.RegisterStandalone event) {
        SRI_MODEL_KEYS.forEach((sriKey, modelKey) -> event.register(modelKey, (UnbakedStandaloneModel)SimpleUnbakedStandaloneModel.blockStateModel((Identifier)sriKey.location(), (ModelState)sriKey.modelRotation())));
    }

    @SubscribeEvent
    public static void onModelBakingCompleted(ModelEvent.ModifyBakingResult event) {
        Map modelRegistry = event.getBakingResult().blockStateModels();
        StandaloneModelLoader.BakedModels standaloneModels = event.getBakingResult().standaloneModels();
        Block sri = (Block)SCContent.SECURE_REDSTONE_INTERFACE.get();
        for (Block block : disguisableBlocks.get()) {
            for (BlockState state : block.getStateDefinition().getPossibleStates()) {
                ClientHandler.registerDisguisedModel(modelRegistry, state, DisguisableBlockStateModel::new);
            }
        }
        for (BlockState state : sri.getStateDefinition().getPossibleStates()) {
            boolean sender = (Boolean)state.getValue((Property)SecureRedstoneInterfaceBlock.SENDER);
            Direction direction = (Direction)state.getValue(SecureRedstoneInterfaceBlock.FACING);
            ClientHandler.registerDisguisedModel(modelRegistry, state, oldModel -> new SecureRedstoneInterfaceBlockStateModel((BlockStateModel)standaloneModels.get(SRI_MODEL_KEYS.get(new SRIKey(sender, direction))), (BlockStateModel)oldModel));
        }
    }

    private static void registerDisguisedModel(Map<BlockState, BlockStateModel> modelRegistry, BlockState state, UnaryOperator<BlockStateModel> modelFunction) {
        modelRegistry.put(state, (BlockStateModel)modelFunction.apply(modelRegistry.get(state)));
    }

    @SubscribeEvent
    public static void onRegisterRangeSelectItemModelProperty(RegisterRangeSelectItemModelPropertyEvent event) {
        event.register(SecurityCraft.resLoc("keycard_count"), KeycardCount.MAP_CODEC);
    }

    @SubscribeEvent
    public static void onRegisterSelectItemModelProperty(RegisterSelectItemModelPropertyEvent event) {
        event.register(SecurityCraft.resLoc("block_linked"), BlockLinked.TYPE);
        event.register(SecurityCraft.resLoc("codebreaker_state"), CodebreakerState.TYPE);
        event.register(SecurityCraft.resLoc("sentry_linked"), SentryLinked.TYPE);
    }

    @SubscribeEvent
    public static void onRegisterSpecialModelRenderer(RegisterSpecialModelRendererEvent event) {
        event.register(SecurityCraft.resLoc("display_case"), DisplayCaseSpecialRenderer.Unbaked.MAP_CODEC);
        event.register(SecurityCraft.resLoc("security_camera"), SecurityCameraSpecialRenderer.Unbaked.MAP_CODEC);
    }

    @SubscribeEvent
    public static void onRegisterItemTintSources(RegisterColorHandlersEvent.ItemTintSources event) {
        event.register(SecurityCraft.resLoc("reinforced"), ReinforcedTint.MAP_CODEC);
    }

    @SubscribeEvent
    public static void onFMLClientSetup(FMLClientSetupEvent event) {
        ChunkSectionLayer cutout = ChunkSectionLayer.CUTOUT;
        ChunkSectionLayer translucent = ChunkSectionLayer.TRANSLUCENT;
        ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)SCContent.FAKE_WATER.get()), (ChunkSectionLayer)translucent);
        ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)SCContent.FLOWING_FAKE_WATER.get()), (ChunkSectionLayer)translucent);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)SCContent.REINFORCED_COPPER_BARS.get()), (ChunkSectionLayer)cutout);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)SCContent.REINFORCED_EXPOSED_COPPER_BARS.get()), (ChunkSectionLayer)cutout);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)SCContent.REINFORCED_WEATHERED_COPPER_BARS.get()), (ChunkSectionLayer)cutout);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)SCContent.REINFORCED_OXIDIZED_COPPER_BARS.get()), (ChunkSectionLayer)cutout);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)SCContent.REINFORCED_GLASS.get()), (ChunkSectionLayer)translucent);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)SCContent.REINFORCED_GLASS_PANE.get()), (ChunkSectionLayer)translucent);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)SCContent.REINFORCED_IRON_BARS.get()), (ChunkSectionLayer)cutout);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)SCContent.REINFORCED_LIGHTNING_ROD.get()), (ChunkSectionLayer)cutout);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)SCContent.REINFORCED_EXPOSED_LIGHTNING_ROD.get()), (ChunkSectionLayer)cutout);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)SCContent.REINFORCED_WEATHERED_LIGHTNING_ROD.get()), (ChunkSectionLayer)cutout);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)SCContent.REINFORCED_OXIDIZED_LIGHTNING_ROD.get()), (ChunkSectionLayer)cutout);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)SCContent.REINFORCED_WHITE_STAINED_GLASS.get()), (ChunkSectionLayer)translucent);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)SCContent.REINFORCED_ORANGE_STAINED_GLASS.get()), (ChunkSectionLayer)translucent);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)SCContent.REINFORCED_MAGENTA_STAINED_GLASS.get()), (ChunkSectionLayer)translucent);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)SCContent.REINFORCED_LIGHT_BLUE_STAINED_GLASS.get()), (ChunkSectionLayer)translucent);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)SCContent.REINFORCED_YELLOW_STAINED_GLASS.get()), (ChunkSectionLayer)translucent);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)SCContent.REINFORCED_LIME_STAINED_GLASS.get()), (ChunkSectionLayer)translucent);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)SCContent.REINFORCED_PINK_STAINED_GLASS.get()), (ChunkSectionLayer)translucent);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)SCContent.REINFORCED_GRAY_STAINED_GLASS.get()), (ChunkSectionLayer)translucent);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)SCContent.REINFORCED_LIGHT_GRAY_STAINED_GLASS.get()), (ChunkSectionLayer)translucent);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)SCContent.REINFORCED_CYAN_STAINED_GLASS.get()), (ChunkSectionLayer)translucent);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)SCContent.REINFORCED_PURPLE_STAINED_GLASS.get()), (ChunkSectionLayer)translucent);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)SCContent.REINFORCED_BLUE_STAINED_GLASS.get()), (ChunkSectionLayer)translucent);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)SCContent.REINFORCED_BROWN_STAINED_GLASS.get()), (ChunkSectionLayer)translucent);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)SCContent.REINFORCED_GREEN_STAINED_GLASS.get()), (ChunkSectionLayer)translucent);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)SCContent.REINFORCED_RED_STAINED_GLASS.get()), (ChunkSectionLayer)translucent);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)SCContent.REINFORCED_BLACK_STAINED_GLASS.get()), (ChunkSectionLayer)translucent);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)SCContent.REINFORCED_WHITE_STAINED_GLASS_PANE.get()), (ChunkSectionLayer)translucent);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)SCContent.REINFORCED_ORANGE_STAINED_GLASS_PANE.get()), (ChunkSectionLayer)translucent);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)SCContent.REINFORCED_MAGENTA_STAINED_GLASS_PANE.get()), (ChunkSectionLayer)translucent);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)SCContent.REINFORCED_LIGHT_BLUE_STAINED_GLASS_PANE.get()), (ChunkSectionLayer)translucent);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)SCContent.REINFORCED_YELLOW_STAINED_GLASS_PANE.get()), (ChunkSectionLayer)translucent);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)SCContent.REINFORCED_LIME_STAINED_GLASS_PANE.get()), (ChunkSectionLayer)translucent);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)SCContent.REINFORCED_PINK_STAINED_GLASS_PANE.get()), (ChunkSectionLayer)translucent);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)SCContent.REINFORCED_GRAY_STAINED_GLASS_PANE.get()), (ChunkSectionLayer)translucent);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)SCContent.REINFORCED_LIGHT_GRAY_STAINED_GLASS_PANE.get()), (ChunkSectionLayer)translucent);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)SCContent.REINFORCED_CYAN_STAINED_GLASS_PANE.get()), (ChunkSectionLayer)translucent);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)SCContent.REINFORCED_PURPLE_STAINED_GLASS_PANE.get()), (ChunkSectionLayer)translucent);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)SCContent.REINFORCED_BLUE_STAINED_GLASS_PANE.get()), (ChunkSectionLayer)translucent);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)SCContent.REINFORCED_BROWN_STAINED_GLASS_PANE.get()), (ChunkSectionLayer)translucent);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)SCContent.REINFORCED_GREEN_STAINED_GLASS_PANE.get()), (ChunkSectionLayer)translucent);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)SCContent.REINFORCED_RED_STAINED_GLASS_PANE.get()), (ChunkSectionLayer)translucent);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)SCContent.REINFORCED_BLACK_STAINED_GLASS_PANE.get()), (ChunkSectionLayer)translucent);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)SCContent.REINFORCED_PALE_MOSS_CARPET.get()), (ChunkSectionLayer)cutout);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)SCContent.TRACK_MINE.get()), (ChunkSectionLayer)cutout);
    }

    @SubscribeEvent
    public static void registerMenuScreens(RegisterMenuScreensEvent event) {
        event.register((MenuType)SCContent.BLOCK_REINFORCER_MENU.get(), BlockReinforcerScreen::new);
        event.register((MenuType)SCContent.BRIEFCASE_INVENTORY_MENU.get(), ItemInventoryScreen.Briefcase::new);
        event.register((MenuType)SCContent.CUSTOMIZE_BLOCK_MENU.get(), CustomizeBlockScreen::new);
        event.register((MenuType)SCContent.CUSTOMIZE_ENTITY_MENU.get(), CustomizeBlockScreen::new);
        event.register((MenuType)SCContent.DISGUISE_MODULE_MENU.get(), DisguiseModuleScreen::new);
        event.register((MenuType)SCContent.INVENTORY_SCANNER_MENU.get(), InventoryScannerScreen::new);
        event.register((MenuType)SCContent.KEYPAD_FURNACE_MENU.get(), KeypadFurnaceScreen::new);
        event.register((MenuType)SCContent.KEYPAD_SMOKER_MENU.get(), KeypadSmokerScreen::new);
        event.register((MenuType)SCContent.KEYPAD_BLAST_FURNACE_MENU.get(), KeypadBlastFurnaceScreen::new);
        event.register((MenuType)SCContent.KEYCARD_READER_MENU.get(), KeycardReaderScreen::new);
        event.register((MenuType)SCContent.BLOCK_POCKET_MANAGER_MENU.get(), BlockPocketManagerScreen::new);
        event.register((MenuType)SCContent.PROJECTOR_MENU.get(), ProjectorScreen::new);
        event.register((MenuType)SCContent.BLOCK_CHANGE_DETECTOR_MENU.get(), BlockChangeDetectorScreen::new);
        event.register((MenuType)SCContent.KEYCARD_HOLDER_MENU.get(), ItemInventoryScreen.KeycardHolder::new);
        event.register((MenuType)SCContent.TROPHY_SYSTEM_MENU.get(), TrophySystemScreen::new);
        event.register((MenuType)SCContent.SINGLE_LENS_MENU.get(), SingleLensScreen::new);
        event.register((MenuType)SCContent.LASER_BLOCK_MENU.get(), LaserBlockScreen::new);
        event.register((MenuType)SCContent.REINFORCED_LECTERN_MENU.get(), ReinforcedLecternScreen::new);
    }

    @SubscribeEvent
    public static void registerGuiLayers(RegisterGuiLayersEvent event) {
        event.registerAboveAll(CAMERA_LAYER, SCClientEventHandler::cameraOverlay);
        LayerToggleHandler.disable(CAMERA_LAYER);
    }

    @SubscribeEvent
    public static void registerPipRenderers(RegisterPictureInPictureRenderersEvent event) {
        event.register(GuiBlockModelRenderState.class, GuiBlockModelRenderer::new);
    }

    @SubscribeEvent
    public static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)SCContent.BOUNCING_BETTY_ENTITY.get(), BouncingBettyRenderer::new);
        event.registerEntityRenderer((EntityType)SCContent.IMS_BOMB_ENTITY.get(), IMSBombRenderer::new);
        event.registerEntityRenderer((EntityType)SCContent.SECURITY_CAMERA_ENTITY.get(), NoopRenderer::new);
        event.registerEntityRenderer((EntityType)SCContent.SENTRY_ENTITY.get(), SentryRenderer::new);
        event.registerEntityRenderer((EntityType)SCContent.BULLET_ENTITY.get(), BulletRenderer::new);
        event.registerEntityRenderer((EntityType)SCContent.OAK_SECURITY_SEA_BOAT_ENTITY.get(), ctx -> new SecuritySeaBoatRenderer(ctx, ModelLayers.OAK_CHEST_BOAT));
        event.registerEntityRenderer((EntityType)SCContent.SPRUCE_SECURITY_SEA_BOAT_ENTITY.get(), ctx -> new SecuritySeaBoatRenderer(ctx, ModelLayers.SPRUCE_CHEST_BOAT));
        event.registerEntityRenderer((EntityType)SCContent.BIRCH_SECURITY_SEA_BOAT_ENTITY.get(), ctx -> new SecuritySeaBoatRenderer(ctx, ModelLayers.BIRCH_CHEST_BOAT));
        event.registerEntityRenderer((EntityType)SCContent.JUNGLE_SECURITY_SEA_BOAT_ENTITY.get(), ctx -> new SecuritySeaBoatRenderer(ctx, ModelLayers.JUNGLE_CHEST_BOAT));
        event.registerEntityRenderer((EntityType)SCContent.ACACIA_SECURITY_SEA_BOAT_ENTITY.get(), ctx -> new SecuritySeaBoatRenderer(ctx, ModelLayers.ACACIA_CHEST_BOAT));
        event.registerEntityRenderer((EntityType)SCContent.DARK_OAK_SECURITY_SEA_BOAT_ENTITY.get(), ctx -> new SecuritySeaBoatRenderer(ctx, ModelLayers.DARK_OAK_CHEST_BOAT));
        event.registerEntityRenderer((EntityType)SCContent.MANGROVE_SECURITY_SEA_BOAT_ENTITY.get(), ctx -> new SecuritySeaBoatRenderer(ctx, ModelLayers.MANGROVE_CHEST_BOAT));
        event.registerEntityRenderer((EntityType)SCContent.CHERRY_SECURITY_SEA_BOAT_ENTITY.get(), ctx -> new SecuritySeaBoatRenderer(ctx, ModelLayers.CHERRY_CHEST_BOAT));
        event.registerEntityRenderer((EntityType)SCContent.PALE_OAK_SECURITY_SEA_BOAT_ENTITY.get(), ctx -> new SecuritySeaBoatRenderer(ctx, ModelLayers.PALE_OAK_CHEST_BOAT));
        event.registerEntityRenderer((EntityType)SCContent.BAMBOO_SECURITY_SEA_RAFT_ENTITY.get(), ctx -> new SecuritySeaRaftRenderer(ctx, ModelLayers.BAMBOO_CHEST_RAFT));
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.BLOCK_POCKET_MANAGER_BLOCK_ENTITY.get(), BlockPocketManagerRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.CLAYMORE_BLOCK_ENTITY.get(), ClaymoreRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.KEYPAD_CHEST_BLOCK_ENTITY.get(), KeypadChestRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.DISPLAY_CASE_BLOCK_ENTITY.get(), ctx -> new DisplayCaseRenderer(ctx, false));
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.GLOW_DISPLAY_CASE_BLOCK_ENTITY.get(), ctx -> new DisplayCaseRenderer(ctx, true));
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.FRAME_BLOCK_ENTITY.get(), FrameBlockEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.REINFORCED_LECTERN_BLOCK_ENTITY.get(), LecternRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.PROJECTOR_BLOCK_ENTITY.get(), ProjectorRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.REINFORCED_PISTON_BLOCK_ENTITY.get(), ReinforcedPistonHeadRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.REINFORCED_SHELF_BLOCK_ENTITY.get(), ShelfRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.RETINAL_SCANNER_BLOCK_ENTITY.get(), RetinalScannerRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.SECURE_REDSTONE_INTERFACE_BLOCK_ENTITY.get(), SecureRedstoneInterfaceRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.SECURITY_CAMERA_BLOCK_ENTITY.get(), SecurityCameraRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.SECRET_HANGING_SIGN_BLOCK_ENTITY.get(), SecretHangingSignRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.SECRET_SIGN_BLOCK_ENTITY.get(), SecretSignRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.SONIC_SECURITY_SYSTEM_BLOCK_ENTITY.get(), SonicSecuritySystemRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.TROPHY_SYSTEM_BLOCK_ENTITY.get(), TrophySystemRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.BLOCK_CHANGE_DETECTOR_BLOCK_ENTITY.get(), DisguisableBlockEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.CAGE_TRAP_BLOCK_ENTITY.get(), DisguisableBlockEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.DISGUISABLE_BLOCK_ENTITY.get(), DisguisableBlockEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.FLOOR_TRAP_BLOCK_ENTITY.get(), DisguisableBlockEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.INVENTORY_SCANNER_BLOCK_ENTITY.get(), DisguisableBlockEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.KEYCARD_READER_BLOCK_ENTITY.get(), DisguisableBlockEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.KEYPAD_BLOCK_ENTITY.get(), DisguisableBlockEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.KEYPAD_BARREL_BLOCK_ENTITY.get(), DisguisableBlockEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.KEYPAD_BLAST_FURNACE_BLOCK_ENTITY.get(), DisguisableBlockEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.KEYPAD_DOOR_BLOCK_ENTITY.get(), DisguisableBlockEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.KEYPAD_TRAPDOOR_BLOCK_ENTITY.get(), DisguisableBlockEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.KEYPAD_FURNACE_BLOCK_ENTITY.get(), DisguisableBlockEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.KEYPAD_SMOKER_BLOCK_ENTITY.get(), DisguisableBlockEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.LASER_BLOCK_BLOCK_ENTITY.get(), DisguisableBlockEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.OBSERVER_BLOCK_ENTITY.get(), DisguisableBlockEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.PROTECTO_BLOCK_ENTITY.get(), DisguisableBlockEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.REINFORCED_DISPENSER_BLOCK_ENTITY.get(), DisguisableBlockEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.REINFORCED_DROPPER_BLOCK_ENTITY.get(), DisguisableBlockEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.REINFORCED_HOPPER_BLOCK_ENTITY.get(), DisguisableBlockEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.RIFT_STABILIZER_BLOCK_ENTITY.get(), DisguisableBlockEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.SCANNER_DOOR_BLOCK_ENTITY.get(), DisguisableBlockEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.SCANNER_TRAPDOOR_BLOCK_ENTITY.get(), DisguisableBlockEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.USERNAME_LOGGER_BLOCK_ENTITY.get(), DisguisableBlockEntityRenderer::new);
    }

    @SubscribeEvent
    public static void registerLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(BULLET_LOCATION, BulletModel::createLayer);
        event.registerLayerDefinition(IMS_BOMB_LOCATION, IMSBombModel::createLayer);
        event.registerLayerDefinition(DISPLAY_CASE_LOCATION, DisplayCaseModel::createModelLayer);
        event.registerLayerDefinition(SENTRY_LOCATION, SentryModel::createLayer);
        event.registerLayerDefinition(SECURITY_CAMERA_LOCATION, SecurityCameraModel::createLayer);
        event.registerLayerDefinition(SONIC_SECURITY_SYSTEM_LOCATION, SonicSecuritySystemModel::createLayer);
        event.registerLayerDefinition(SECURE_REDSTONE_INTERFACE_DISH_LAYER_LOCATION, SecureRedstoneInterfaceDishModel::createLayer);
    }

    @SubscribeEvent
    public static void registerParticleProviders(RegisterParticleProvidersEvent event) {
        event.registerSpriteSet((ParticleType)SCContent.FLOOR_TRAP_CLOUD.get(), FloorTrapCloudParticle.Provider::new);
        event.registerSpriteSet((ParticleType)SCContent.INTERFACE_HIGHLIGHT.get(), InterfaceHighlightParticle.Provider::new);
    }

    @SubscribeEvent
    public static void onRegisterRenderPipelines(RegisterRenderPipelinesEvent event) {
        event.registerPipeline(FrameBlockEntityRenderer.FRAME_PIPELINE);
    }

    @SubscribeEvent
    public static void onRegisterClientExtensions(RegisterClientExtensionsEvent event) {
        event.registerItem(new IClientItemExtensions(){
            private static final HumanoidModel.ArmPose TASER_ARM_POSE = (HumanoidModel.ArmPose)TASER_ARM_POSE_PARAMS.getValue();

            public boolean applyForgeHandTransform(PoseStack pose, LocalPlayer player, HumanoidArm arm, ItemStack stack, float partialTick, float equippedProgress, float swingProgress) {
                if (swingProgress < 0.001f) {
                    pose.translate(0.02f, -0.4f, -0.5f);
                    return true;
                }
                return false;
            }

            public HumanoidModel.ArmPose getArmPose(LivingEntity entity, InteractionHand hand, ItemStack stack) {
                return TASER_ARM_POSE;
            }
        }, new Item[]{(Item)SCContent.TASER.get(), (Item)SCContent.TASER_POWERED.get()});
    }

    @SubscribeEvent
    public static void onRegisterClientPayloadsHandlers(RegisterClientPayloadHandlersEvent event) {
        event.register(BlockPocketManagerFailedActivation.TYPE, BlockPocketManagerFailedActivation::handle);
        event.register(InteractWithFrame.TYPE, InteractWithFrame::handle);
        event.register(OpenScreen.TYPE, OpenScreen::handle);
        event.register(PlayAlarmSound.TYPE, PlayAlarmSound::handle);
        event.register(RefreshDisguisableModel.TYPE, RefreshDisguisableModel::handle);
        event.register(SendManualPages.TYPE, SendManualPages::handle);
        event.register(SetCameraView.TYPE, SetCameraView::handle);
        event.register(SetTrophySystemTarget.TYPE, SetTrophySystemTarget::handle);
        event.register(UpdateLaserColors.TYPE, UpdateLaserColors::handle);
        event.register(UpdateLogger.TYPE, UpdateLogger::handle);
    }

    private static void initTint() {
        for (Field field : SCContent.class.getFields()) {
            if (!field.isAnnotationPresent(Reinforced.class)) continue;
            try {
                Block block = (Block)((DeferredBlock)field.get(null)).get();
                int customTint = field.getAnnotation(Reinforced.class).customTint();
                if (field.getAnnotation(Reinforced.class).hasReinforcedTint()) {
                    blocksWithReinforcedTint.put(block, customTint);
                    continue;
                }
                if (customTint == -1) continue;
                blocksWithCustomTint.put(block, customTint);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
        blocksWithReinforcedTint.put((Block)SCContent.BLOCK_POCKET_MANAGER.get(), -15354974);
        blocksWithReinforcedTint.put((Block)SCContent.BLOCK_POCKET_WALL.get(), -15354974);
        blocksWithCustomTint.put((Block)SCContent.CRYSTAL_QUARTZ_SLAB.get(), -15354974);
        blocksWithCustomTint.put((Block)SCContent.SMOOTH_CRYSTAL_QUARTZ.get(), -15354974);
        blocksWithCustomTint.put((Block)SCContent.CHISELED_CRYSTAL_QUARTZ.get(), -15354974);
        blocksWithCustomTint.put((Block)SCContent.CRYSTAL_QUARTZ_BLOCK.get(), -15354974);
        blocksWithCustomTint.put((Block)SCContent.CRYSTAL_QUARTZ_BRICKS.get(), -15354974);
        blocksWithCustomTint.put((Block)SCContent.CRYSTAL_QUARTZ_PILLAR.get(), -15354974);
        blocksWithCustomTint.put((Block)SCContent.CRYSTAL_QUARTZ_STAIRS.get(), -15354974);
        blocksWithCustomTint.put((Block)SCContent.SMOOTH_CRYSTAL_QUARTZ_SLAB.get(), -15354974);
        blocksWithCustomTint.put((Block)SCContent.SMOOTH_CRYSTAL_QUARTZ_STAIRS.get(), -15354974);
    }

    @SubscribeEvent
    public static void onRegisterBlockColorHandlers(RegisterColorHandlersEvent.Block event) {
        ClientHandler.initTint();
        blocksWithReinforcedTint.forEach((block, tint) -> event.register((state, level, pos, tintIndex) -> {
            if (tintIndex == 0) {
                return ClientHandler.mixWithReinforcedTintIfEnabled(tint);
            }
            return -1;
        }, new Block[]{block}));
        blocksWithCustomTint.forEach((block, tint) -> event.register((state, level, pos, tintIndex) -> {
            if (tintIndex == 0) {
                return tint;
            }
            return -1;
        }, new Block[]{block}));
        BlockColor disguisableBlockColor = (state, level, pos, tintIndex) -> {
            IDisguisable disguisedBlock;
            Block blockFromItem;
            BlockState defaultBlockState;
            Block block = state.getBlock();
            if (block instanceof IDisguisable && !(defaultBlockState = (blockFromItem = Block.byItem((Item)(disguisedBlock = (IDisguisable)block).getDisguisedStack((BlockGetter)level, pos).getItem())).defaultBlockState()).isAir() && !(blockFromItem instanceof IDisguisable)) {
                return Minecraft.getInstance().getBlockColors().getColor(defaultBlockState, level, pos, tintIndex);
            }
            if (block instanceof IReinforcedBlock) {
                return ClientHandler.mixWithReinforcedTintIfEnabled(-1);
            }
            return -1;
        };
        event.register(disguisableBlockColor, disguisableBlocks.get());
        event.register(disguisableBlockColor, new Block[]{(Block)SCContent.SECURE_REDSTONE_INTERFACE.get()});
        event.register((state, level, pos, tintIndex) -> {
            if (tintIndex == 1 && !((Boolean)state.getValue((Property)SnowyDirtBlock.SNOWY)).booleanValue()) {
                int grassTint = level != null && pos != null ? BiomeColors.getAverageGrassColor((BlockAndTintGetter)level, (BlockPos)pos) : GrassColor.get((double)0.5, (double)1.0);
                return ClientHandler.mixWithReinforcedTintIfEnabled(grassTint);
            }
            return ClientHandler.mixWithReinforcedTintIfEnabled(-1);
        }, new Block[]{(Block)SCContent.REINFORCED_GRASS_BLOCK.get()});
        event.register((state, level, pos, tintIndex) -> {
            if (tintIndex == 1) {
                return level != null && pos != null ? BiomeColors.getAverageWaterColor((BlockAndTintGetter)level, (BlockPos)pos) : -1;
            }
            return ClientHandler.mixWithReinforcedTintIfEnabled(-1);
        }, new Block[]{(Block)SCContent.REINFORCED_WATER_CAULDRON.get()});
        event.register((state, level, pos, tintIndex) -> {
            Direction direction = LaserFieldBlock.getFieldDirection(state);
            return ClientHandler.iterateFields(level, pos, direction, (Integer)ConfigHandler.SERVER.laserBlockRange.get(), (Block)SCContent.LASER_BLOCK.get(), LaserBlockBlockEntity.class::isInstance, be -> ((LaserBlockBlockEntity)be).getLensContainer().getItem(direction.getOpposite().ordinal()));
        }, new Block[]{(Block)SCContent.LASER_FIELD.get()});
        event.register((state, level, pos, tintIndex) -> {
            Direction direction = (Direction)state.getValue(InventoryScannerFieldBlock.FACING);
            return ClientHandler.iterateFields(level, pos, direction, (Integer)ConfigHandler.SERVER.inventoryScannerRange.get(), (Block)SCContent.INVENTORY_SCANNER.get(), InventoryScannerBlockEntity.class::isInstance, be -> ((InventoryScannerBlockEntity)be).getLensContainer().getItem(0));
        }, new Block[]{(Block)SCContent.INVENTORY_SCANNER_FIELD.get()});
    }

    public static int iterateFields(BlockAndTintGetter level, BlockPos pos, Direction direction, int range, Block block, Predicate<BlockEntity> beTest, Function<BlockEntity, ItemStack> lensGetter) {
        try {
            return ClientHandler.iterateFieldsInternal(level, pos, direction, range, block, beTest, lensGetter);
        }
        catch (Exception e1) {
            direction = direction.getOpposite();
            try {
                return ClientHandler.iterateFieldsInternal(level, pos, direction, range, block, beTest, lensGetter);
            }
            catch (Exception exception) {
                return -1;
            }
        }
    }

    private static int iterateFieldsInternal(BlockAndTintGetter level, BlockPos pos, Direction direction, int range, Block block, Predicate<BlockEntity> beTest, Function<BlockEntity, ItemStack> lensGetter) throws ArrayIndexOutOfBoundsException {
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos(pos.getX(), pos.getY(), pos.getZ());
        for (int i = 0; i < range; ++i) {
            BlockEntity be;
            if (level.getBlockState((BlockPos)mutablePos).is(block) && beTest.test(be = level.getBlockEntity((BlockPos)mutablePos))) {
                ItemStack stack = lensGetter.apply(be);
                if (!stack.has(DataComponents.DYED_COLOR)) break;
                return ((DyedItemColor)stack.get(DataComponents.DYED_COLOR)).rgb();
            }
            mutablePos.move(direction);
        }
        return -1;
    }

    public static int mixWithReinforcedTintIfEnabled(int tint) {
        boolean tintReinforcedBlocks = Minecraft.getInstance().level == null ? ((Boolean)ConfigHandler.CLIENT.reinforcedBlockTint.get()).booleanValue() : ((Boolean)ConfigHandler.SERVER.forceReinforcedBlockTint.get() != false ? (Boolean)ConfigHandler.SERVER.reinforcedBlockTint.get() : (Boolean)ConfigHandler.CLIENT.reinforcedBlockTint.get()).booleanValue();
        return tintReinforcedBlocks ? ARGB.multiply((int)tint, (int)(0xFF000000 | (Integer)ConfigHandler.CLIENT.reinforcedBlockTintColor.get())) : tint;
    }

    public static Player getClientPlayer() {
        return Minecraft.getInstance().player;
    }

    public static Level getClientLevel() {
        return Minecraft.getInstance().level;
    }

    public static void displayMRATScreen(ItemStack stack) {
        Minecraft.getInstance().setScreen((Screen)new MineRemoteAccessToolScreen(stack));
    }

    public static void displaySRATScreen(ItemStack stack) {
        Minecraft.getInstance().setScreen((Screen)new SentryRemoteAccessToolScreen(stack));
    }

    public static void displayEditModuleScreen(ItemStack stack) {
        Minecraft.getInstance().setScreen((Screen)new EditModuleScreen(stack));
    }

    public static void displayCameraMonitorScreen(ItemStack stack) {
        Minecraft.getInstance().setScreen((Screen)new CameraMonitorScreen(stack));
    }

    public static void displayFrameScreen(FrameBlockEntity be, boolean readOnly) {
        Minecraft.getInstance().setScreen((Screen)new FrameScreen(readOnly, be));
    }

    public static void displaySCManualScreen() {
        Minecraft.getInstance().setScreen((Screen)new SCManualScreen());
    }

    public static void displayEditSecretSignScreen(SecretSignBlockEntity be, boolean isFront) {
        Minecraft.getInstance().setScreen((Screen)new SignEditScreen((SignBlockEntity)be, isFront, Minecraft.getInstance().isTextFilteringEnabled()));
    }

    public static void displayEditSecretHangingSignScreen(SecretHangingSignBlockEntity be, boolean isFront) {
        Minecraft.getInstance().setScreen((Screen)new HangingSignEditScreen((SignBlockEntity)be, isFront, Minecraft.getInstance().isTextFilteringEnabled()));
    }

    public static void displaySonicSecuritySystemScreen(SonicSecuritySystemBlockEntity be) {
        Minecraft.getInstance().setScreen((Screen)new SonicSecuritySystemScreen(be));
    }

    public static void displayBriefcasePasscodeScreen(Component title) {
        Minecraft.getInstance().setScreen((Screen)new BriefcasePasscodeScreen(title, false));
    }

    public static void displayBriefcaseSetupScreen(Component title) {
        Minecraft.getInstance().setScreen((Screen)new BriefcasePasscodeScreen(title, true));
    }

    public static void displayUsernameLoggerScreen(UsernameLoggerBlockEntity be) {
        Minecraft.getInstance().setScreen((Screen)new UsernameLoggerScreen(be));
    }

    public static void displayUniversalKeyChangerScreen(BlockEntity be) {
        Minecraft.getInstance().setScreen((Screen)new KeyChangerScreen((IPasscodeProtected)be));
    }

    public static void displayUniversalKeyChangerScreen(Entity entity) {
        Minecraft.getInstance().setScreen((Screen)new KeyChangerScreen((IPasscodeProtected)entity));
    }

    public static void displayCheckPasscodeScreen(BlockEntity be) {
        Component component;
        if (be instanceof Nameable) {
            Nameable nameable = (Nameable)be;
            component = nameable.getDisplayName();
        } else {
            component = Component.translatable((String)be.getBlockState().getBlock().getDescriptionId());
        }
        Component displayName = component;
        Minecraft.getInstance().setScreen((Screen)new CheckPasscodeScreen((IPasscodeProtected)be, displayName));
    }

    public static void displayCheckPasscodeScreen(Entity entity) {
        Minecraft.getInstance().setScreen((Screen)new CheckPasscodeScreen((IPasscodeProtected)entity, entity.getDisplayName()));
    }

    public static void displaySetPasscodeScreen(BlockEntity be) {
        Component component;
        if (be instanceof Nameable) {
            Nameable nameable = (Nameable)be;
            component = nameable.getDisplayName();
        } else {
            component = Component.translatable((String)be.getBlockState().getBlock().getDescriptionId());
        }
        Component displayName = component;
        Minecraft.getInstance().setScreen((Screen)new SetPasscodeScreen((IPasscodeProtected)be, displayName));
    }

    public static void displaySetPasscodeScreen(Entity entity) {
        Minecraft.getInstance().setScreen((Screen)new SetPasscodeScreen((IPasscodeProtected)entity, entity.getDisplayName()));
    }

    public static void displaySSSItemScreen(ItemStack stack) {
        Minecraft.getInstance().setScreen((Screen)new SSSItemScreen(stack));
    }

    public static void displayRiftStabilizerScreen(RiftStabilizerBlockEntity be) {
        Minecraft.getInstance().setScreen((Screen)new RiftStabilizerScreen(be));
    }

    public static void displaySecureRedstoneInterfaceScreen(SecureRedstoneInterfaceBlockEntity be) {
        Minecraft.getInstance().setScreen((Screen)new SecureRedstoneInterfaceScreen(be));
    }

    public static void displayAlarmScreen(AlarmBlockEntity be) {
        Minecraft.getInstance().setScreen((Screen)new AlarmScreen(be, be.getSound().location()));
    }

    public static void refreshModelData(BlockEntity be) {
        BlockPos pos = be.getBlockPos();
        be.requestModelDataUpdate();
        be.getLevel().getModelData(pos);
        Minecraft.getInstance().levelRenderer.setBlocksDirty(pos.getX(), pos.getY(), pos.getZ(), pos.getX(), pos.getY(), pos.getZ());
    }

    public static boolean isPlayerMountedOnCamera() {
        return Minecraft.getInstance().getCameraEntity() instanceof SecurityCamera;
    }

    public static void putDisguisedBeRenderer(BlockEntity disguisableBlockEntity, ItemStack stack) {
        DISGUISED_BLOCK_RENDER_DELEGATE.putDelegateFor(disguisableBlockEntity, ((SavedBlockState)stack.getOrDefault(SCContent.SAVED_BLOCK_STATE, (Object)SavedBlockState.EMPTY)).state(), ((ItemContainerContents)stack.getOrDefault(DataComponents.CONTAINER, (Object)ItemContainerContents.EMPTY)).copyOne());
    }

    public static void updateBlockColorAroundPosition(BlockPos pos) {
        Minecraft.getInstance().levelRenderer.blockChanged((BlockGetter)Minecraft.getInstance().level, pos, null, null, 0);
    }

    private record SRIKey(boolean sender, Direction direction) {
        public Identifier location() {
            return this.sender ? SRI_SENDER_ON_MODEL_LOCATION : SRI_RECEIVER_ON_MODEL_LOCATION;
        }

        public BlockModelRotation modelRotation() {
            return BlockModelRotation.get((OctahedralGroup)(switch (this.direction) {
                default -> throw new MatchException(null, null);
                case Direction.DOWN -> OctahedralGroup.BLOCK_ROT_X_180;
                case Direction.UP -> OctahedralGroup.IDENTITY;
                case Direction.NORTH -> OctahedralGroup.BLOCK_ROT_X_90;
                case Direction.SOUTH -> OctahedralGroup.BLOCK_ROT_X_90.compose(OctahedralGroup.BLOCK_ROT_Y_180);
                case Direction.WEST -> OctahedralGroup.BLOCK_ROT_X_90.compose(OctahedralGroup.BLOCK_ROT_Y_270);
                case Direction.EAST -> OctahedralGroup.BLOCK_ROT_X_90.compose(OctahedralGroup.BLOCK_ROT_Y_90);
            }));
        }
    }
}

