/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.api;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IOwnable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class Owner {
    public static final Codec<Owner> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.STRING.fieldOf("owner").forGetter(Owner::getName), (App)Codec.STRING.fieldOf("ownerUUID").forGetter(Owner::getUUID), (App)Codec.BOOL.optionalFieldOf("ownerValidated", (Object)true).forGetter(Owner::isValidated)).apply((Applicative)i, Owner::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, Owner> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, Owner::getName, (StreamCodec)ByteBufCodecs.STRING_UTF8, Owner::getUUID, Owner::new);
    private String ownerName = "owner";
    private String ownerUUID = "ownerUUID";
    private boolean validated = true;

    public Owner() {
    }

    public Owner(Entity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            this.ownerName = player.getName().getString();
            this.ownerUUID = player.getGameProfile().id().toString();
        }
    }

    public Owner(Player player) {
        if (player != null) {
            this.ownerName = player.getName().getString();
            this.ownerUUID = player.getGameProfile().id().toString();
        }
    }

    public Owner(String playerName, String playerUUID) {
        this.ownerName = playerName;
        this.ownerUUID = playerUUID;
    }

    public Owner(String playerName, String playerUUID, boolean validated) {
        this.ownerName = playerName;
        this.ownerUUID = playerUUID;
        this.validated = validated;
    }

    public static Owner fromCompound(CompoundTag tag) {
        Owner owner = new Owner();
        if (tag != null) {
            owner.ownerName = tag.getStringOr("owner", owner.ownerName);
            owner.ownerUUID = tag.getStringOr("ownerUUID", owner.ownerUUID);
            owner.validated = tag.getBooleanOr("ownerValidated", owner.validated);
        }
        return owner;
    }

    public void load(ValueInput tag) {
        this.ownerName = tag.getStringOr("owner", this.ownerName);
        this.ownerUUID = tag.getStringOr("ownerUUID", this.ownerUUID);
        this.validated = tag.getBooleanOr("ownerValidated", this.validated);
    }

    public void save(ValueOutput tag, boolean saveValidationStatus) {
        tag.putString("owner", this.ownerName);
        tag.putString("ownerUUID", this.ownerUUID);
        if (saveValidationStatus) {
            tag.putBoolean("ownerValidated", this.validated);
        }
    }

    public boolean owns(IOwnable ... ownables) {
        for (IOwnable ownable : ownables) {
            if (ownable == null || ownable.isOwnedBy(this)) continue;
            return false;
        }
        return true;
    }

    public boolean isDefaultOwner() {
        return this.equals(new Owner());
    }

    public void set(String uuid, String name) {
        this.ownerName = name;
        this.ownerUUID = uuid;
    }

    public void setOwnerName(String name) {
        this.ownerName = name;
    }

    public void setOwnerUUID(String uuid) {
        this.ownerUUID = uuid;
    }

    public void setValidated(boolean validated) {
        this.validated = validated;
    }

    public String getName() {
        return this.ownerName;
    }

    public String getUUID() {
        return this.ownerUUID;
    }

    public boolean isValidated() {
        return this.validated;
    }

    public String toString() {
        return "Name: " + this.ownerName + "  UUID: " + this.ownerUUID;
    }

    public Owner copy() {
        return new Owner(this.ownerName, this.ownerUUID);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Deprecated
    public boolean equals(Object obj) {
        if (!(obj instanceof Owner)) return false;
        Owner owner = (Owner)obj;
        if (!this.getName().equals(owner.getName())) return false;
        if (!this.getUUID().equals(owner.getUUID())) return false;
        return true;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.ownerName).append((Object)this.ownerUUID).build();
    }

    public static EntityDataSerializer<Owner> getSerializer() {
        return (EntityDataSerializer)SCContent.OWNER_SERIALIZER.get();
    }
}

