/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;

public class FakeLavaBlock
extends LiquidBlock {
    private static final MobEffectInstance SHORT_FIRE_RESISTANCE = new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 1);

    public FakeLavaBlock(BlockBehaviour.Properties properties, FlowingFluid fluid) {
        super(fluid, properties);
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity, InsideBlockEffectApplier effectApplier, boolean stillInside) {
        super.entityInside(state, level, pos, entity, effectApplier, stillInside);
        if (entity instanceof LivingEntity) {
            LivingEntity lEntity = (LivingEntity)entity;
            lEntity.clearFire();
            lEntity.setSharedFlagOnFire(false);
            if (!level.isClientSide()) {
                lEntity.addEffect(SHORT_FIRE_RESISTANCE);
                if (!lEntity.hasEffect(MobEffects.REGENERATION)) {
                    lEntity.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 20, 2, false, false));
                }
            }
        }
    }

    public BlockState getAppearance(BlockState state, BlockAndTintGetter level, BlockPos pos, Direction side, BlockState queryState, BlockPos queryPos) {
        return (BlockState)Blocks.LAVA.defaultBlockState().setValue((Property)LEVEL, (Comparable)((Integer)state.getValue((Property)LEVEL)));
    }
}

