/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.reinforced;

import net.geforcemods.securitycraft.blockentities.ReinforcedDropperBlockEntity;
import net.geforcemods.securitycraft.blocks.reinforced.ReinforcedDispenserBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.DispenserBlockEntity;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.item.ContainerOrHandler;
import net.neoforged.neoforge.transfer.item.ItemUtil;

public class ReinforcedDropperBlock
extends ReinforcedDispenserBlock {
    private static final DispenseItemBehavior DISPENSE_BEHAVIOUR = new DefaultDispenseItemBehavior();

    public ReinforcedDropperBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public DispenseItemBehavior getDispenseMethod(Level level, ItemStack stack) {
        return DISPENSE_BEHAVIOUR;
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new ReinforcedDropperBlockEntity(pos, state);
    }

    @Override
    protected void dispenseFrom(ServerLevel level, BlockState state, BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof ReinforcedDropperBlockEntity) {
            ReinforcedDropperBlockEntity be = (ReinforcedDropperBlockEntity)blockEntity;
            BlockSource source = new BlockSource(level, pos, state, (DispenserBlockEntity)be);
            int randomSlot = be.getRandomSlot(level.random);
            if (randomSlot < 0) {
                level.levelEvent(1001, pos, 0);
            } else {
                ItemStack dispenseStack = be.getItem(randomSlot);
                if (!dispenseStack.isEmpty()) {
                    ItemStack afterDispenseStack;
                    Direction direction = (Direction)level.getBlockState(pos).getValue((Property)FACING);
                    ContainerOrHandler containerOrHandler = HopperBlockEntity.getContainerOrHandlerAt((Level)level, (BlockPos)pos.relative(direction), (Direction)direction.getOpposite());
                    if (containerOrHandler.isEmpty()) {
                        afterDispenseStack = DISPENSE_BEHAVIOUR.dispense(source, dispenseStack);
                    } else {
                        afterDispenseStack = containerOrHandler.container() != null ? HopperBlockEntity.addItem((Container)be, (Container)containerOrHandler.container(), (ItemStack)dispenseStack.copyWithCount(1), (Direction)direction.getOpposite()) : ItemUtil.insertItemReturnRemaining((ResourceHandler)containerOrHandler.itemHandler(), (ItemStack)dispenseStack.copyWithCount(1), (boolean)false, null);
                        if (afterDispenseStack.isEmpty()) {
                            afterDispenseStack = dispenseStack.copy();
                            afterDispenseStack.shrink(1);
                        } else {
                            afterDispenseStack = dispenseStack.copy();
                        }
                    }
                    be.setItem(randomSlot, afterDispenseStack);
                }
            }
        }
    }

    @Override
    public Block getVanillaBlock() {
        return Blocks.DROPPER;
    }
}

