/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.components;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.util.NullableListCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.ItemStack;

public interface GlobalPositionComponent<C, T, E> {
    public static final GlobalPos DUMMY_GLOBAL_POS = new GlobalPos(ResourceKey.create((ResourceKey)Registries.DIMENSION, (Identifier)SecurityCraft.resLoc("dummy")), BlockPos.ZERO);

    public static <A> Codec<List<A>> nullableSizedCodec(final Codec<A> baseCodec, int size) {
        return new NullableListCodec(new Codec<A>(){

            public <R> DataResult<Pair<A, R>> decode(DynamicOps<R> ops, R input) {
                return input.equals(ops.emptyMap()) ? DataResult.success((Object)Pair.of(null, input)) : baseCodec.decode(ops, input);
            }

            public <R> DataResult<R> encode(A input, DynamicOps<R> ops, R prefix) {
                return input == null ? DataResult.success((Object)ops.emptyMap()) : baseCodec.encode(input, ops, prefix);
            }
        }, size, size);
    }

    public static <A> StreamCodec<ByteBuf, List<A>> nullableSizedStreamCodec(StreamCodec<ByteBuf, A> baseStreamCodec, int size, A dummy) {
        return baseStreamCodec.map(globalPos -> globalPos.equals(dummy) ? null : globalPos, globalPos -> globalPos == null ? dummy : globalPos).apply(ByteBufCodecs.list((int)size));
    }

    public List<T> positions();

    public boolean isPositionAdded(GlobalPos var1);

    public GlobalPos getGlobalPos(T var1);

    public T createEntry(GlobalPos var1, E var2);

    public void setOnStack(Supplier<DataComponentType<C>> var1, ItemStack var2, List<T> var3);

    default public int size() {
        return this.positions().size();
    }

    default public boolean isEmpty() {
        return this.positions().stream().allMatch(Objects::isNull);
    }

    default public boolean add(Supplier<DataComponentType<C>> dataComponentType, ItemStack stack, GlobalPos globalPos, E extra) {
        if (!this.isPositionAdded(globalPos)) {
            ArrayList<T> newPositionsList = new ArrayList<T>(this.positions());
            for (int i = 0; i < newPositionsList.size(); ++i) {
                Object t = newPositionsList.get(i);
                if (t != null) continue;
                newPositionsList.set(i, this.createEntry(globalPos, extra));
                this.setOnStack(dataComponentType, stack, newPositionsList);
                return true;
            }
        }
        return false;
    }

    default public boolean remove(Supplier<DataComponentType<C>> dataComponentType, ItemStack stack, GlobalPos globalPos) {
        if (globalPos != null && !this.isEmpty()) {
            ArrayList<T> newPositionsList = new ArrayList<T>(this.positions());
            for (int i = 0; i < newPositionsList.size(); ++i) {
                Object t = newPositionsList.get(i);
                if (!globalPos.equals((Object)this.getGlobalPos(t))) continue;
                newPositionsList.set(i, null);
                this.setOnStack(dataComponentType, stack, newPositionsList);
                return true;
            }
        }
        return false;
    }
}

