/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.inventory;

import net.geforcemods.securitycraft.inventory.DisguiseModuleMenu;
import net.geforcemods.securitycraft.items.ModuleItem;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.Container;
import net.minecraft.world.entity.ContainerUser;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;

public class ModuleItemContainer
implements Container {
    private final ItemStack module;
    private NonNullList<ItemStack> moduleInventory;
    private DisguiseModuleMenu menu;
    private boolean changed;

    public ModuleItemContainer(ItemStack moduleStack) {
        this.module = moduleStack;
        if (!(moduleStack.getItem() instanceof ModuleItem)) {
            return;
        }
        this.moduleInventory = NonNullList.withSize((int)1, (Object)ItemStack.EMPTY);
        this.load();
    }

    public int getContainerSize() {
        return 1;
    }

    public ItemStack getItem(int index) {
        return (ItemStack)this.moduleInventory.get(index);
    }

    public void load() {
        ((ItemContainerContents)this.module.getOrDefault(DataComponents.CONTAINER, (Object)ItemContainerContents.EMPTY)).copyInto(this.moduleInventory);
    }

    public void save() {
        this.module.set(DataComponents.CONTAINER, (Object)ItemContainerContents.fromItems(this.moduleInventory));
    }

    public ItemStack removeItem(int index, int size) {
        ItemStack stack = this.getItem(index);
        if (!stack.isEmpty()) {
            if (stack.getCount() > size) {
                stack = stack.split(size);
            } else {
                this.setItem(index, ItemStack.EMPTY);
            }
            this.setChanged();
        }
        return stack;
    }

    public ItemStack removeItemNoUpdate(int index) {
        ItemStack stack = this.getItem(index);
        this.setItem(index, ItemStack.EMPTY);
        this.setChanged();
        return stack;
    }

    public void setItem(int index, ItemStack stack) {
        this.moduleInventory.set(index, (Object)stack);
        if (!stack.isEmpty() && stack.getCount() > this.getMaxStackSize()) {
            stack.setCount(this.getMaxStackSize());
        }
        this.setChanged();
    }

    public void setChanged() {
        for (int i = 0; i < this.getContainerSize(); ++i) {
            if (this.getItem(i).isEmpty() || this.getItem(i).getCount() != 0) continue;
            this.moduleInventory.set(i, (Object)ItemStack.EMPTY);
        }
        this.changed = true;
        if (this.menu != null) {
            this.menu.slotsChanged(this);
        }
    }

    public boolean stillValid(Player player) {
        return true;
    }

    public void startOpen(ContainerUser player) {
    }

    public void stopOpen(ContainerUser player) {
        if (this.changed) {
            this.save();
        }
    }

    public boolean canPlaceItem(int index, ItemStack stack) {
        return true;
    }

    public void clearContent() {
    }

    public boolean isEmpty() {
        for (ItemStack stack : this.moduleInventory) {
            if (stack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public void setMenu(DisguiseModuleMenu menu) {
        this.menu = menu;
    }

    public ItemStack getModule() {
        return this.module;
    }
}

