/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.particle;

import net.geforcemods.securitycraft.particle.InterfaceHighlightParticleOptions;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.DustParticleBase;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.particles.ScalableParticleOptionsBase;
import net.minecraft.util.RandomSource;
import org.joml.Vector3f;

public class InterfaceHighlightParticle
extends DustParticleBase<InterfaceHighlightParticleOptions> {
    private final TextureAtlasSprite permanentSprite;

    protected InterfaceHighlightParticle(ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, InterfaceHighlightParticleOptions options, SpriteSet sprites) {
        super(level, x, y, z, xSpeed, ySpeed, zSpeed, (ScalableParticleOptionsBase)options, sprites);
        float colorChangeMultiplier = this.random.nextFloat() * 0.4f + 0.6f;
        Vector3f color = options.getColor().mul(this.randomizeColor(1.0f, colorChangeMultiplier), new Vector3f());
        this.hasPhysics = false;
        this.setColor(color.x(), color.y(), color.z());
        this.setParticleSpeed(options.getDirection().x(), options.getDirection().y(), options.getDirection().z());
        this.permanentSprite = sprites.get(this.random);
        this.setSprite(this.permanentSprite);
        this.lifetime = (int)(20.0 / (this.random.nextDouble() * 0.3 + 0.7)) - 5;
    }

    public void tick() {
        super.tick();
        this.setSprite(this.permanentSprite);
    }

    protected int getLightColor(float partialTicks) {
        return 0xF000F0;
    }

    public static class Provider
    implements ParticleProvider<InterfaceHighlightParticleOptions> {
        private final SpriteSet sprites;

        public Provider(SpriteSet sprites) {
            this.sprites = sprites;
        }

        public Particle createParticle(InterfaceHighlightParticleOptions options, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, RandomSource random) {
            return new InterfaceHighlightParticle(level, x, y, z, xSpeed, ySpeed, zSpeed, options, this.sprites);
        }
    }
}

