/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.geforcemods.securitycraft.blockentities.ClaymoreBlockEntity;
import net.geforcemods.securitycraft.blocks.mines.ClaymoreBlock;
import net.geforcemods.securitycraft.renderers.state.ClaymoreRenderState;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.rendertype.RenderTypes;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.util.ARGB;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionfc;

public class ClaymoreRenderer
implements BlockEntityRenderer<ClaymoreBlockEntity, ClaymoreRenderState> {
    public ClaymoreRenderer(BlockEntityRendererProvider.Context ctx) {
    }

    public void submit(ClaymoreRenderState state, PoseStack poseStack, SubmitNodeCollector collector, CameraRenderState camera) {
        poseStack.pushPose();
        poseStack.translate(0.5, 0.0, 0.5);
        poseStack.mulPose((Quaternionfc)state.rotation);
        poseStack.translate(-0.5, 0.0, -0.5);
        collector.submitCustomGeometry(poseStack, RenderTypes.lines(), (pose, builder) -> {
            Vec3i normal = state.normal;
            float multiplier = 0.0625f;
            float xzStart = 9.0f * multiplier;
            float y = 4.5f * multiplier;
            int r = state.r;
            int g = state.g;
            int b = state.b;
            builder.addVertex(pose, xzStart, y, xzStart).setColor(r, g, b, 255).setNormal((float)normal.getX(), (float)normal.getY(), (float)normal.getZ()).setLineWidth(2.0f);
            builder.addVertex(pose, 11.0f * multiplier, y, 1.0f).setColor(r, g, b, 0).setNormal((float)normal.getX(), (float)normal.getY(), (float)normal.getZ()).setLineWidth(2.0f);
            builder.addVertex(pose, 7.0f * multiplier, y, xzStart).setColor(r, g, b, 255).setNormal((float)normal.getX(), (float)normal.getY(), (float)normal.getZ()).setLineWidth(2.0f);
            builder.addVertex(pose, 5.0f * multiplier, y, 1.0f).setColor(r, g, b, 0).setNormal((float)normal.getX(), (float)normal.getY(), (float)normal.getZ()).setLineWidth(2.0f);
        });
        poseStack.popPose();
    }

    public ClaymoreRenderState createRenderState() {
        return new ClaymoreRenderState();
    }

    public void extractRenderState(ClaymoreBlockEntity be, ClaymoreRenderState state, float partialTick, Vec3 cameraPos, ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        super.extractRenderState((BlockEntity)be, (BlockEntityRenderState)state, partialTick, cameraPos, crumblingOverlay);
        ItemStack lens = be.getLensContainer().getItem(0);
        Direction claymoreFacing = (Direction)be.getBlockState().getValue(ClaymoreBlock.FACING);
        Direction rotationDirection = switch (claymoreFacing) {
            case Direction.EAST, Direction.WEST -> claymoreFacing.getOpposite();
            default -> claymoreFacing;
        };
        state.isActivated = (Boolean)be.getBlockState().getValue((Property)ClaymoreBlock.DEACTIVATED);
        state.rotation = Axis.YP.rotationDegrees(rotationDirection.toYRot());
        state.normal = claymoreFacing.getUnitVec3i();
        if (lens.has(DataComponents.DYED_COLOR)) {
            int color = ((DyedItemColor)lens.get(DataComponents.DYED_COLOR)).rgb();
            state.r = ARGB.red((int)color);
            state.g = ARGB.green((int)color);
            state.b = ARGB.blue((int)color);
        } else {
            state.r = 255;
            state.g = 255;
            state.b = 255;
        }
    }

    public boolean shouldRenderOffScreen() {
        return true;
    }
}

