/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Calendar;
import net.geforcemods.securitycraft.ClientHandler;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.renderers.state.KeypadChestRenderState;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.ChestRenderer;
import net.minecraft.client.renderer.blockentity.state.ChestRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.resources.model.Material;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.phys.Vec3;

public class KeypadChestRenderer
extends ChestRenderer<ChestBlockEntity> {
    private static final Material ACTIVE = KeypadChestRenderer.createMaterial("active");
    private static final Material INACTIVE = KeypadChestRenderer.createMaterial("inactive");
    private static final Material LEFT_ACTIVE = KeypadChestRenderer.createMaterial("left_active");
    private static final Material LEFT_INACTIVE = KeypadChestRenderer.createMaterial("left_inactive");
    private static final Material RIGHT_ACTIVE = KeypadChestRenderer.createMaterial("right_active");
    private static final Material RIGHT_INACTIVE = KeypadChestRenderer.createMaterial("right_inactive");
    private static final Material CHRISTMAS = KeypadChestRenderer.createMaterial("christmas");
    private static final Material CHRISTMAS_LEFT = KeypadChestRenderer.createMaterial("christmas_left");
    private static final Material CHRISTMAS_RIGHT = KeypadChestRenderer.createMaterial("christmas_right");
    protected boolean isChristmas;

    public KeypadChestRenderer(BlockEntityRendererProvider.Context ctx) {
        super(ctx);
        Calendar calendar = Calendar.getInstance();
        if (calendar.get(2) + 1 == 12 && calendar.get(5) >= 24 && calendar.get(5) <= 26) {
            this.isChristmas = true;
        }
    }

    public void submit(ChestRenderState state, PoseStack pose, SubmitNodeCollector collector, CameraRenderState camera) {
        if (state instanceof KeypadChestRenderState) {
            KeypadChestRenderState keypadChestRenderState = (KeypadChestRenderState)state;
            ClientHandler.DISGUISED_BLOCK_RENDER_DELEGATE.trySubmitDelegate(keypadChestRenderState.disguiseRenderState, pose, collector, camera);
            if (!keypadChestRenderState.isDisguised) {
                super.submit(state, pose, collector, camera);
            }
        }
    }

    public ChestRenderState createRenderState() {
        return new KeypadChestRenderState();
    }

    public void extractRenderState(ChestBlockEntity be, ChestRenderState state, float partialTick, Vec3 cameraPos, ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        super.extractRenderState((BlockEntity)be, state, partialTick, cameraPos, crumblingOverlay);
        if (state instanceof KeypadChestRenderState) {
            IModuleInventory moduleInv;
            KeypadChestRenderState keypadChestRenderState = (KeypadChestRenderState)state;
            keypadChestRenderState.disguiseRenderState = ClientHandler.DISGUISED_BLOCK_RENDER_DELEGATE.tryExtractFromDelegate((BlockEntity)be, partialTick, cameraPos, crumblingOverlay);
            boolean bl = keypadChestRenderState.isDisguised = be instanceof IModuleInventory && (moduleInv = (IModuleInventory)be).isModuleEnabled(ModuleType.DISGUISE);
        }
        state.customMaterial = this.isChristmas ? this.getMaterialForType(state.type, CHRISTMAS_LEFT, CHRISTMAS_RIGHT, CHRISTMAS) : (be.getOpenNess(0.0f) >= 0.9f ? this.getMaterialForType(state.type, LEFT_ACTIVE, RIGHT_ACTIVE, ACTIVE) : this.getMaterialForType(state.type, LEFT_INACTIVE, RIGHT_INACTIVE, INACTIVE));
    }

    private Material getMaterialForType(ChestType type, Material left, Material right, Material single) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case ChestType.LEFT -> left;
            case ChestType.RIGHT -> right;
            case ChestType.SINGLE -> single;
        };
    }

    private static Material createMaterial(String name) {
        return new Material(Sheets.CHEST_SHEET, SecurityCraft.resLoc("entity/chest/" + name));
    }
}

