/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import net.geforcemods.securitycraft.blockentities.SecretSignBlockEntity;
import net.geforcemods.securitycraft.renderers.state.SecretSignRenderState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.SignRenderer;
import net.minecraft.client.renderer.blockentity.state.SignRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.phys.Vec3;

public class SecretSignRenderer
extends SignRenderer {
    public SecretSignRenderer(BlockEntityRendererProvider.Context ctx) {
        super(ctx);
    }

    public void submitSignText(SignRenderState state, PoseStack pose, SubmitNodeCollector collector, boolean isFrontText) {
        if (state instanceof SecretSignRenderState) {
            boolean isSecret;
            SecretSignRenderState secretSignRenderState = (SecretSignRenderState)state;
            boolean bl = isSecret = isFrontText ? secretSignRenderState.isFrontSecret : secretSignRenderState.isBackSecret;
            if (!isSecret) {
                super.submitSignText(state, pose, collector, isFrontText);
            }
        }
    }

    public SignRenderState createRenderState() {
        return new SecretSignRenderState();
    }

    public void extractRenderState(SignBlockEntity be, SignRenderState state, float partialTick, Vec3 cameraPos, ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        super.extractRenderState(be, state, partialTick, cameraPos, crumblingOverlay);
        if (be instanceof SecretSignBlockEntity) {
            SecretSignBlockEntity secretSignBlockEntity = (SecretSignBlockEntity)be;
            if (state instanceof SecretSignRenderState) {
                SecretSignRenderState secretSignRenderState = (SecretSignRenderState)state;
                LocalPlayer player = Minecraft.getInstance().player;
                secretSignRenderState.isFrontSecret = !secretSignBlockEntity.isPlayerAllowedToSeeText((Player)player, true);
                secretSignRenderState.isBackSecret = !secretSignBlockEntity.isPlayerAllowedToSeeText((Player)player, false);
            }
        }
    }
}

