/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import net.geforcemods.securitycraft.ClientHandler;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.blockentities.SecureRedstoneInterfaceBlockEntity;
import net.geforcemods.securitycraft.blocks.SecureRedstoneInterfaceBlock;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.models.SecureRedstoneInterfaceDishModel;
import net.geforcemods.securitycraft.renderers.state.SecureRedstoneInterfaceRenderState;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.rendertype.RenderTypes;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.resources.Identifier;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionfc;

public class SecureRedstoneInterfaceRenderer
implements BlockEntityRenderer<SecureRedstoneInterfaceBlockEntity, SecureRedstoneInterfaceRenderState> {
    private static final Identifier TEXTURE = SecurityCraft.resLoc("textures/block/secure_redstone_interface_dish.png");
    private final SecureRedstoneInterfaceDishModel model;

    public SecureRedstoneInterfaceRenderer(BlockEntityRendererProvider.Context ctx) {
        this.model = new SecureRedstoneInterfaceDishModel(ctx.bakeLayer(ClientHandler.SECURE_REDSTONE_INTERFACE_DISH_LAYER_LOCATION));
    }

    public void submit(SecureRedstoneInterfaceRenderState state, PoseStack pose, SubmitNodeCollector collector, CameraRenderState camera) {
        ClientHandler.DISGUISED_BLOCK_RENDER_DELEGATE.trySubmitDelegate(state.disguiseRenderState, pose, collector, camera);
        if (!state.isDisguised && !state.isSender) {
            pose.translate(0.5, 0.5, 0.5);
            pose.mulPose((Quaternionfc)state.modelRotation);
            pose.translate(0.0, -0.49999, 0.0);
            collector.submitModel((Model)this.model, (Object)Float.valueOf(state.dishRotation), pose, RenderTypes.entitySolid((Identifier)TEXTURE), state.lightCoords, OverlayTexture.NO_OVERLAY, 0, state.breakProgress);
        }
    }

    public SecureRedstoneInterfaceRenderState createRenderState() {
        return new SecureRedstoneInterfaceRenderState();
    }

    public void extractRenderState(SecureRedstoneInterfaceBlockEntity be, SecureRedstoneInterfaceRenderState state, float partialTick, Vec3 cameraPos, ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        super.extractRenderState((BlockEntity)be, (BlockEntityRenderState)state, partialTick, cameraPos, crumblingOverlay);
        state.disguiseRenderState = ClientHandler.DISGUISED_BLOCK_RENDER_DELEGATE.tryExtractFromDelegate(be, partialTick, cameraPos, crumblingOverlay);
        state.modelRotation = ((Direction)be.getBlockState().getValue(SecureRedstoneInterfaceBlock.FACING)).getRotation();
        state.isDisguised = be.isModuleEnabled(ModuleType.DISGUISE);
        state.isSender = (Boolean)be.getBlockState().getValue((Property)SecureRedstoneInterfaceBlock.SENDER);
        state.dishRotation = Mth.lerp((float)partialTick, (float)be.getOriginalDishRotationDegrees(), (float)be.getDishRotationDegrees());
    }
}

