/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen.components;

import net.geforcemods.securitycraft.screen.components.ColorChooser;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.InputWithModifiers;
import net.minecraft.network.chat.Component;

public class ColorChooserButton
extends Button.Plain {
    private final ColorChooser colorChooser;

    public ColorChooserButton(int x, int y, int width, int height, ColorChooser colorChooser) {
        super(x, y, width, height, (Component)Component.empty(), b -> {}, s -> Component.empty());
        this.colorChooser = colorChooser;
    }

    public void renderContents(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        int color = this.colorChooser.getRGBColor();
        super.renderContents(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.fillGradient(this.getX() + 2, this.getY() + 2, this.getX() + this.width - 2, this.getY() + this.height - 2, color, color);
    }

    public void onPress(InputWithModifiers input) {
        if (this.colorChooser.disabled) {
            Minecraft.getInstance().pushGuiLayer((Screen)this.colorChooser);
        } else {
            Minecraft.getInstance().popGuiLayer();
        }
        this.colorChooser.disabled = !this.colorChooser.disabled;
    }
}

