/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.lithium.common.entity.pushable;

import net.caffeinemc.mods.lithium.common.entity.EntityClassGroup;
import net.caffeinemc.mods.lithium.common.reflection.ReflectionUtil;
import net.caffeinemc.mods.lithium.common.services.PlatformMappingInformation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ambient.Bat;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.monster.creaking.Creaking;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.player.Player;

public class PushableEntityClassGroup {
    public static final EntityClassGroup CACHABLE_UNPUSHABILITY;
    public static final EntityClassGroup MAYBE_PUSHABLE;

    static {
        String remapped_isClimbing = PlatformMappingInformation.INSTANCE.mapMethodName("intermediary", "net.minecraft.class_1309", "method_6101", "()Z", "onClimbable");
        String remapped_isPushable = PlatformMappingInformation.INSTANCE.mapMethodName("intermediary", "net.minecraft.class_1297", "method_5810", "()Z", "isPushable");
        CACHABLE_UNPUSHABILITY = new EntityClassGroup((entityClass, entityType) -> {
            if (LivingEntity.class.isAssignableFrom((Class<?>)entityClass) && !Player.class.isAssignableFrom((Class<?>)entityClass) && !ReflectionUtil.hasMethodOverride(entityClass, LivingEntity.class, true, remapped_isClimbing, new Class[0])) {
                if (Creaking.class.isAssignableFrom((Class<?>)entityClass)) {
                    return !ReflectionUtil.hasMethodOverride(entityClass, Creaking.class, true, remapped_isPushable, new Class[0]);
                }
                if (Warden.class.isAssignableFrom((Class<?>)entityClass)) {
                    return !ReflectionUtil.hasMethodOverride(entityClass, Warden.class, true, remapped_isPushable, new Class[0]);
                }
                return !ReflectionUtil.hasMethodOverride(entityClass, LivingEntity.class, true, remapped_isPushable, new Class[0]);
            }
            return false;
        });
        MAYBE_PUSHABLE = new EntityClassGroup((entityClass, entityType) -> {
            if (ReflectionUtil.hasMethodOverride(entityClass, Entity.class, true, remapped_isPushable, new Class[0])) {
                if (EnderDragon.class.isAssignableFrom((Class<?>)entityClass)) {
                    return false;
                }
                if (ArmorStand.class.isAssignableFrom((Class<?>)entityClass)) {
                    return ReflectionUtil.hasMethodOverride(entityClass, ArmorStand.class, true, remapped_isPushable, new Class[0]);
                }
                if (Bat.class.isAssignableFrom((Class<?>)entityClass)) {
                    return ReflectionUtil.hasMethodOverride(entityClass, Bat.class, true, remapped_isPushable, new Class[0]);
                }
                return true;
            }
            return Player.class.isAssignableFrom((Class<?>)entityClass);
        });
    }
}

