/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.lithium.common.util;

import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;

public class Distances {
    public static long getMinChunkToBlockDistanceL2Sq(BlockPos origin, int chunkX, int chunkZ) {
        int zDistance;
        int chunkMinX = SectionPos.sectionToBlockCoord((int)chunkX);
        int chunkMinZ = SectionPos.sectionToBlockCoord((int)chunkZ);
        int xDistance = origin.getX() - chunkMinX;
        if (xDistance > 0) {
            xDistance = Math.max(0, xDistance - 15);
        }
        if ((zDistance = origin.getZ() - chunkMinZ) > 0) {
            zDistance = Math.max(0, zDistance - 15);
        }
        return (long)xDistance * (long)xDistance + (long)zDistance * (long)zDistance;
    }

    public static BlockPos getClosestPosInChunk(BlockPos origin, int chunkX, int chunkZ) {
        int closestX = Distances.getClosestBlockCoordInSection(origin.getX(), chunkX);
        int closestZ = Distances.getClosestBlockCoordInSection(origin.getZ(), chunkZ);
        return new BlockPos(closestX, origin.getY(), closestZ);
    }

    public static boolean isWithinCubeRadius(BlockPos origin, int radius, BlockPos pos) {
        return Math.abs(pos.getX() - origin.getX()) <= radius && Math.abs(pos.getZ() - origin.getZ()) <= radius;
    }

    public static boolean isWithinSphereRadius(BlockPos origin, long radiusSq, BlockPos pos) {
        return Distances.distanceSq(origin, pos) <= radiusSq;
    }

    public static int getClosestBlockCoordInSection(int blockCoord, int sectionCoord) {
        int minBlockInSection = SectionPos.sectionToBlockCoord((int)sectionCoord);
        return Math.min(Math.max(blockCoord, minBlockInSection), minBlockInSection + 15);
    }

    public static long getMinSectionDistanceSq(BlockPos origin, int chunkX, int chunkY, int chunkZ) {
        int originX = origin.getX();
        int originY = origin.getY();
        int originZ = origin.getZ();
        long distX = Distances.getClosestBlockCoordInSection(originX, chunkX) - originX;
        long distY = Distances.getClosestBlockCoordInSection(originY, chunkY) - originY;
        long distZ = Distances.getClosestBlockCoordInSection(originZ, chunkZ) - originZ;
        return distX * distX + distY * distY + distZ * distZ;
    }

    public static long distanceSq(BlockPos a, BlockPos b) {
        long dx = a.getX() - b.getX();
        long dy = a.getY() - b.getY();
        long dz = a.getZ() - b.getZ();
        return dx * dx + dy * dy + dz * dz;
    }

    public static int distanceSqInt(BlockPos a, BlockPos b) {
        int dx = a.getX() - b.getX();
        int dy = a.getY() - b.getY();
        int dz = a.getZ() - b.getZ();
        return Math.addExact(Math.addExact(Math.multiplyExact(dx, dx), Math.multiplyExact(dy, dy)), Math.multiplyExact(dz, dz));
    }
}

