/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.lithium.mixin.block.moving_block_shapes;

import net.caffeinemc.mods.lithium.common.shapes.OffsetVoxelShapeCache;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.spongepowered.asm.mixin.Mixin;

@Mixin(value={VoxelShape.class})
public class VoxelShapeMixin
implements OffsetVoxelShapeCache {
    private volatile VoxelShape[] offsetAndSimplified;

    @Override
    public void lithium$setShape(float offset, Direction direction, VoxelShape offsetShape) {
        if (offsetShape == null) {
            throw new IllegalArgumentException("offsetShape must not be null!");
        }
        int index = VoxelShapeMixin.getIndexForOffsetSimplifiedShapes(offset, direction);
        VoxelShape[] offsetAndSimplifiedShapes = this.offsetAndSimplified;
        offsetAndSimplifiedShapes = offsetAndSimplifiedShapes == null ? new VoxelShape[13] : (VoxelShape[])offsetAndSimplifiedShapes.clone();
        offsetAndSimplifiedShapes[index] = offsetShape;
        this.offsetAndSimplified = offsetAndSimplifiedShapes;
    }

    @Override
    public VoxelShape lithium$getOffsetSimplifiedShape(float offset, Direction direction) {
        VoxelShape[] offsetAndSimplified = this.offsetAndSimplified;
        if (offsetAndSimplified == null) {
            return null;
        }
        int index = VoxelShapeMixin.getIndexForOffsetSimplifiedShapes(offset, direction);
        return offsetAndSimplified[index];
    }

    private static int getIndexForOffsetSimplifiedShapes(float offset, Direction direction) {
        if (offset != 0.0f && offset != 0.5f && offset != 1.0f) {
            throw new IllegalArgumentException("offset must be one of {0f, 0.5f, 1f}");
        }
        if (offset == 0.0f) {
            return 0;
        }
        return (int)(2.0f * offset) + 2 * direction.get3DDataValue();
    }
}

