/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.lithium.mixin.entity.equipment_tracking.equipment_changes;

import java.util.Map;
import net.caffeinemc.mods.lithium.common.entity.EquipmentInfo;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityEquipment;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity {
    @Shadow
    @Final
    protected EntityEquipment equipment;

    public LivingEntityMixin(EntityType<?> type, Level world) {
        super(type, world);
    }

    @Inject(method={"collectEquipmentChanges()Ljava/util/Map;"}, at={@At(value="HEAD")}, cancellable=true)
    private void skipSentEquipmentComparison(CallbackInfoReturnable<@Nullable Map<EquipmentSlot, ItemStack>> cir) {
        if (!((EquipmentInfo)this.equipment).lithium$hasUnsentEquipmentChanges()) {
            cir.setReturnValue(null);
        }
    }

    @Inject(method={"detectEquipmentUpdates()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;handleHandSwap(Ljava/util/Map;)V")})
    private void resetEquipmentChanged(CallbackInfo ci) {
        if (!(this instanceof Player)) {
            ((EquipmentInfo)this.equipment).lithium$onEquipmentChangesSent();
        }
    }
}

