/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.easyvillagers.blocks.tileentity;

import de.maxhenkel.easyvillagers.EasyVillagersMod;
import de.maxhenkel.easyvillagers.blocks.FarmerBlock;
import de.maxhenkel.easyvillagers.blocks.ModBlocks;
import de.maxhenkel.easyvillagers.blocks.VillagerBlockBase;
import de.maxhenkel.easyvillagers.blocks.tileentity.ModTileEntities;
import de.maxhenkel.easyvillagers.blocks.tileentity.VillagerTileentity;
import de.maxhenkel.easyvillagers.corelib.blockentity.IServerTickableBlockEntity;
import de.maxhenkel.easyvillagers.corelib.codec.ValueInputOutputUtils;
import de.maxhenkel.easyvillagers.corelib.inventory.ItemListInventory;
import de.maxhenkel.easyvillagers.entity.EasyVillagerEntity;
import de.maxhenkel.easyvillagers.inventory.ListAccessItemStacksResourceHandler;
import de.maxhenkel.easyvillagers.inventory.OutputOnlyResourceHandler;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.npc.villager.VillagerProfession;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.neoforged.neoforge.transfer.transaction.Transaction;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;

public class FarmerTileentity
extends VillagerTileentity
implements IServerTickableBlockEntity {
    protected BlockState crop;
    protected ListAccessItemStacksResourceHandler inventory = new ListAccessItemStacksResourceHandler(4);
    protected OutputOnlyResourceHandler outputInventoryDelegate = new OutputOnlyResourceHandler((ResourceHandler<ItemResource>)this.inventory);

    public FarmerTileentity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModTileEntities.FARMER.get(), ((FarmerBlock)((Object)ModBlocks.FARMER.get())).defaultBlockState(), pos, state);
    }

    @Override
    protected void onAddVillager(EasyVillagerEntity villager) {
        super.onAddVillager(villager);
        if (villager.getVillagerXp() <= 0 && !villager.getVillagerData().profession().is(VillagerProfession.NITWIT)) {
            villager.setVillagerData(villager.getVillagerData().withProfession((HolderGetter.Provider)this.level.registryAccess(), VillagerProfession.FARMER));
        }
    }

    public void setCrop(Item seed) {
        this.crop = seed == null ? null : this.getSeedCrop(seed);
        this.setChanged();
        this.sync();
    }

    public Block removeSeed() {
        if (this.crop == null) {
            return null;
        }
        Block s = this.crop.getBlock();
        this.setCrop(null);
        return s;
    }

    public boolean isValidSeed(Item seed) {
        return this.getSeedCrop(seed) != null;
    }

    public BlockState getSeedCrop(Item seed) {
        ItemStack seedStack = new ItemStack((ItemLike)seed);
        if (!(seed instanceof BlockItem)) {
            return null;
        }
        BlockItem blockitem = (BlockItem)seed;
        if (!seedStack.is(ItemTags.VILLAGER_PLANTABLE_SEEDS)) {
            return null;
        }
        if (EasyVillagersMod.SERVER_CONFIG.farmCropsBlacklist.stream().anyMatch(itemTag -> itemTag.contains(seed))) {
            return null;
        }
        return blockitem.getBlock().defaultBlockState();
    }

    @Nullable
    public BlockState getCrop() {
        return this.crop;
    }

    @Override
    public void tickServer() {
        EasyVillagerEntity v = this.getVillagerEntity();
        if (v != null) {
            VillagerBlockBase.playRandomVillagerSound(this.level, this.getBlockPos(), SoundEvents.VILLAGER_AMBIENT);
            if (this.advanceAge()) {
                this.sync();
            }
            this.setChanged();
        }
        if (this.level.getGameTime() % 20L == 0L && this.level.random.nextInt(((Integer)EasyVillagersMod.SERVER_CONFIG.farmSpeed.get()).intValue()) == 0 && this.ageCrop(v)) {
            this.sync();
            this.setChanged();
        }
    }

    private boolean ageCrop(@Nullable EasyVillagerEntity villager) {
        BlockState c = this.getCrop();
        if (c == null) {
            return false;
        }
        Optional<Property> ageProp = c.getProperties().stream().filter(p -> p.getName().equals("age")).findFirst();
        if (!ageProp.isPresent() || !(ageProp.get() instanceof IntegerProperty)) {
            return false;
        }
        IntegerProperty p2 = (IntegerProperty)ageProp.get();
        Integer max = (Integer)p2.getPossibleValues().stream().max(Integer::compare).get();
        int age = (Integer)c.getValue((Property)p2);
        if (age >= max) {
            if (villager == null || villager.isBaby() || !villager.getVillagerData().profession().is(VillagerProfession.FARMER)) {
                return false;
            }
            LootParams.Builder context = new LootParams.Builder((ServerLevel)this.level).withParameter(LootContextParams.ORIGIN, (Object)new Vec3((double)this.worldPosition.getX(), (double)this.worldPosition.getY(), (double)this.worldPosition.getZ())).withParameter(LootContextParams.BLOCK_STATE, (Object)c).withParameter(LootContextParams.TOOL, (Object)ItemStack.EMPTY);
            List drops = c.getDrops(context);
            try (Transaction transaction = Transaction.open(null);){
                for (ItemStack stack : drops) {
                    this.inventory.insert((Resource)ItemResource.of((ItemStack)stack), stack.getCount(), (TransactionContext)transaction);
                }
                transaction.commit();
            }
            this.crop = (BlockState)this.crop.setValue((Property)p2, (Comparable)Integer.valueOf(0));
            VillagerBlockBase.playVillagerSound(this.level, this.getBlockPos(), SoundEvents.VILLAGER_WORK_FARMER);
            return true;
        }
        this.crop = (BlockState)this.crop.setValue((Property)p2, (Comparable)Integer.valueOf(age + 1));
        return true;
    }

    public Container getOutputInventory() {
        return new ItemListInventory(this.inventory.getRaw(), () -> ((FarmerTileentity)this).setChanged());
    }

    @Override
    protected void saveAdditional(ValueOutput valueOutput) {
        super.saveAdditional(valueOutput);
        if (this.crop != null) {
            ValueInputOutputUtils.setTag(valueOutput, "Crop", NbtUtils.writeBlockState((BlockState)this.crop));
        }
        ContainerHelper.saveAllItems((ValueOutput)valueOutput, this.inventory.getRaw(), (boolean)false);
    }

    @Override
    protected void loadAdditional(ValueInput valueInput) {
        Optional<BlockState> optionalCrop = ValueInputOutputUtils.getTag(valueInput, "Crop").map(t -> NbtUtils.readBlockState((HolderGetter)valueInput.lookup().lookupOrThrow(Registries.BLOCK), (CompoundTag)t));
        if (optionalCrop.isPresent()) {
            this.crop = optionalCrop.get();
        } else {
            this.removeSeed();
        }
        ContainerHelper.loadAllItems((ValueInput)valueInput, this.inventory.getRaw());
        super.loadAdditional(valueInput);
    }

    public ResourceHandler<ItemResource> getItemHandler() {
        return this.outputInventoryDelegate;
    }
}

