/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.easyvillagers.datacomponents;

import com.mojang.serialization.Codec;
import de.maxhenkel.easyvillagers.corelib.codec.ValueInputOutputUtils;
import de.maxhenkel.easyvillagers.entity.EasyVillagerEntity;
import de.maxhenkel.easyvillagers.items.ModItems;
import de.maxhenkel.easyvillagers.items.VillagerItem;
import java.lang.ref.WeakReference;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.npc.villager.Villager;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public class VillagerData {
    public static final Codec<VillagerData> CODEC = CompoundTag.CODEC.xmap(VillagerData::of, villagerData -> villagerData.nbt);
    public static final StreamCodec<RegistryFriendlyByteBuf, VillagerData> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, VillagerData>(){

        public VillagerData decode(RegistryFriendlyByteBuf buf) {
            return new VillagerData(buf.readNbt());
        }

        public void encode(RegistryFriendlyByteBuf buf, VillagerData villager) {
            buf.writeNbt((Tag)villager.nbt);
        }
    };
    private WeakReference<EasyVillagerEntity> villager = new WeakReference<Object>(null);
    private final CompoundTag nbt;

    private VillagerData(CompoundTag nbt) {
        this.nbt = nbt;
    }

    public static VillagerData of(CompoundTag nbt) {
        return new VillagerData(nbt.copy());
    }

    public static VillagerData of(Villager villager) {
        TagValueOutput valueOutput = ValueInputOutputUtils.createValueOutput((Entity)villager, (HolderLookup.Provider)villager.registryAccess());
        villager.addAdditionalSaveData((ValueOutput)valueOutput);
        return new VillagerData(ValueInputOutputUtils.toTag(valueOutput));
    }

    @Nullable
    public static VillagerData get(ItemStack stack) {
        if (!(stack.getItem() instanceof VillagerItem)) {
            throw new IllegalArgumentException("Tried to set villager data to non-villager item (%s)".formatted(stack.getHoverName().getString()));
        }
        return (VillagerData)stack.get(ModItems.VILLAGER_DATA_COMPONENT);
    }

    public static VillagerData getOrCreate(ItemStack stack) {
        VillagerData villagerData = VillagerData.get(stack);
        if (villagerData == null) {
            villagerData = VillagerData.setEmptyVillagerTag(stack);
        }
        return villagerData;
    }

    public EasyVillagerEntity getCacheVillager(Level level) {
        EasyVillagerEntity easyVillager = (EasyVillagerEntity)((Object)this.villager.get());
        if (easyVillager == null) {
            easyVillager = this.createEasyVillager(level, null);
            this.villager = new WeakReference<EasyVillagerEntity>(easyVillager);
        }
        return easyVillager;
    }

    public EasyVillagerEntity createEasyVillager(Level level, @Nullable ItemStack stack) {
        Component customName;
        EasyVillagerEntity v = new EasyVillagerEntity((EntityType<? extends Villager>)EntityType.VILLAGER, level);
        v.readAdditionalSaveData((ValueInput)ValueInputOutputUtils.createValueInput("easy_villagers", (HolderLookup.Provider)level.registryAccess(), this.nbt));
        if (stack != null && (customName = (Component)stack.get(DataComponents.CUSTOM_NAME)) != null) {
            v.setCustomName(customName);
        }
        v.hurtTime = 0;
        v.yHeadRot = 0.0f;
        v.yHeadRotO = 0.0f;
        return v;
    }

    public static EasyVillagerEntity createEasyVillager(ItemStack stack, Level level) {
        VillagerData villagerData = VillagerData.getOrCreate(stack);
        return villagerData.createEasyVillager(level, stack);
    }

    public static void applyToItem(ItemStack stack, Villager villager) {
        if (stack.isEmpty()) {
            return;
        }
        stack.set(ModItems.VILLAGER_DATA_COMPONENT, (Object)VillagerData.of(villager));
        if (villager.hasCustomName()) {
            stack.set(DataComponents.CUSTOM_NAME, (Object)villager.getCustomName());
        }
    }

    public static EasyVillagerEntity getCacheVillager(ItemStack stack, Level level) {
        return VillagerData.getOrCreate(stack).getCacheVillager(level);
    }

    private static VillagerData setEmptyVillagerTag(ItemStack stack) {
        VillagerData villagerData = new VillagerData(new CompoundTag());
        stack.set(ModItems.VILLAGER_DATA_COMPONENT, (Object)villagerData);
        return villagerData;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VillagerData villager1 = (VillagerData)o;
        return Objects.equals(this.nbt, villager1.nbt);
    }

    public int hashCode() {
        return Objects.hashCode(this.nbt);
    }
}

