/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.easyvillagers.gui;

import de.maxhenkel.easyvillagers.corelib.inventory.ScreenBase;
import de.maxhenkel.easyvillagers.gui.ArrowButton;
import de.maxhenkel.easyvillagers.gui.AutoTraderContainer;
import de.maxhenkel.easyvillagers.net.MessageSelectTrade;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.Identifier;
import net.minecraft.world.entity.player.Inventory;
import net.neoforged.neoforge.client.network.ClientPacketDistributor;

public class AutoTraderScreen
extends ScreenBase<AutoTraderContainer> {
    public static final Identifier BACKGROUND = Identifier.fromNamespaceAndPath((String)"easy_villagers", (String)"textures/gui/container/auto_trader.png");
    private final Inventory playerInventory;

    public AutoTraderScreen(AutoTraderContainer container, Inventory playerInventory, Component name) {
        super(BACKGROUND, container, playerInventory, name);
        this.playerInventory = playerInventory;
        this.imageWidth = 176;
        this.imageHeight = 202;
    }

    protected void init() {
        super.init();
        this.addRenderableWidget((GuiEventListener)new ArrowButton(this.leftPos + 8, this.topPos + 19, true, button -> ClientPacketDistributor.sendToServer((CustomPacketPayload)new MessageSelectTrade(false), (CustomPacketPayload[])new CustomPacketPayload[0])));
        this.addRenderableWidget((GuiEventListener)new ArrowButton(this.leftPos + this.imageWidth - 16 - 8, this.topPos + 19, false, button -> ClientPacketDistributor.sendToServer((CustomPacketPayload)new MessageSelectTrade(true), (CustomPacketPayload[])new CustomPacketPayload[0])));
    }

    @Override
    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        super.renderBg(guiGraphics, partialTicks, mouseX, mouseY);
        if (((AutoTraderContainer)this.getMenu()).isLocked()) {
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, BACKGROUND, this.leftPos + 83, this.topPos + 19, 176.0f, 0.0f, 28, 21, 256, 256);
        }
    }

    @Override
    protected void renderLabels(GuiGraphics guiGraphics, int x, int y) {
        super.renderLabels(guiGraphics, x, y);
        this.drawCenteredText(guiGraphics, this.title, 6, -12566464);
        this.drawCenteredText(guiGraphics, (Component)Component.translatable((String)"gui.easy_villagers.input"), 45, -12566464);
        this.drawCenteredText(guiGraphics, (Component)Component.translatable((String)"gui.easy_villagers.output"), 77, -12566464);
        guiGraphics.drawString(this.font, this.playerInventory.getDisplayName().getVisualOrderText(), 8, this.imageHeight - 96 + 3, -12566464, false);
    }

    protected void drawCenteredText(GuiGraphics guiGraphics, Component text, int y, int color) {
        int width = this.font.width((FormattedText)text);
        guiGraphics.drawString(this.font, text.getVisualOrderText(), this.imageWidth / 2 - width / 2, y, color, false);
    }
}

