/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.camera.inventory;

import de.maxhenkel.camera.items.ImageItem;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;

public class AlbumInventory
implements Container {
    public static final int SIZE = 54;
    private NonNullList<ItemStack> items;
    private ItemStack album;

    public AlbumInventory(ItemStack album) {
        assert (!album.isEmpty());
        this.album = album;
        this.items = NonNullList.withSize((int)54, (Object)ItemStack.EMPTY);
        ItemContainerContents contents = (ItemContainerContents)album.getOrDefault(DataComponents.CONTAINER, (Object)ItemContainerContents.EMPTY);
        contents.copyInto(this.items);
    }

    public int getContainerSize() {
        return 54;
    }

    public ItemStack getItem(int index) {
        return (ItemStack)this.items.get(index);
    }

    public ItemStack removeItem(int index, int count) {
        ItemStack itemstack = ContainerHelper.removeItem(this.items, (int)index, (int)count);
        this.setChanged();
        return itemstack;
    }

    public ItemStack removeItemNoUpdate(int index) {
        return ContainerHelper.takeItem(this.items, (int)index);
    }

    public void setItem(int index, ItemStack stack) {
        this.items.set(index, (Object)stack);
        this.setChanged();
    }

    public int getMaxStackSize() {
        return 64;
    }

    public void setChanged() {
        this.album.set(DataComponents.CONTAINER, (Object)ItemContainerContents.fromItems(this.items));
    }

    public boolean canPlaceItem(int index, ItemStack stack) {
        return !(stack.getItem() instanceof ImageItem);
    }

    public void clearContent() {
        this.items.clear();
        this.setChanged();
    }

    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    public boolean stillValid(Player player) {
        for (InteractionHand hand : InteractionHand.values()) {
            if (!player.getItemInHand(hand).equals(this.album)) continue;
            return true;
        }
        return false;
    }
}

