/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.camera.net;

import de.maxhenkel.camera.ImageTools;
import de.maxhenkel.camera.TextureCache;
import de.maxhenkel.camera.corelib.net.Message;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.Identifier;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class MessageImage
implements Message<MessageImage> {
    public static final CustomPacketPayload.Type<MessageImage> TYPE = new CustomPacketPayload.Type(Identifier.fromNamespaceAndPath((String)"camera", (String)"image"));
    private UUID uuid;
    private byte[] image;

    public MessageImage() {
    }

    public MessageImage(UUID uuid, byte[] image) throws IOException {
        this.uuid = uuid;
        this.image = image;
        if (image.length > 1000000) {
            throw new IOException("Image too large: " + image.length + " bytes (max 1.000.000)");
        }
    }

    @Override
    public PacketFlow getExecutingSide() {
        return PacketFlow.CLIENTBOUND;
    }

    @Override
    public void executeClientSide(IPayloadContext context) {
        try {
            BufferedImage img = ImageTools.fromBytes(this.image);
            Minecraft.getInstance().submitAsync(() -> TextureCache.instance().addImage(this.uuid, img));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public MessageImage fromBytes(RegistryFriendlyByteBuf buf) {
        this.uuid = buf.readUUID();
        this.image = buf.readByteArray();
        return this;
    }

    @Override
    public void toBytes(RegistryFriendlyByteBuf buf) {
        buf.writeUUID(this.uuid);
        buf.writeByteArray(this.image);
    }

    @Override
    public CustomPacketPayload.Type<MessageImage> type() {
        return TYPE;
    }
}

