/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.camera.net;

import de.maxhenkel.camera.CameraMod;
import de.maxhenkel.camera.corelib.net.Message;
import java.util.UUID;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.Identifier;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class MessagePartialImage
implements Message<MessagePartialImage> {
    public static final CustomPacketPayload.Type<MessagePartialImage> TYPE = new CustomPacketPayload.Type(Identifier.fromNamespaceAndPath((String)"camera", (String)"partial_image"));
    private UUID imgUUID;
    private int offset;
    private int length;
    private byte[] bytes;

    public MessagePartialImage() {
    }

    public MessagePartialImage(UUID imgUUID, int offset, int length, byte[] bytes) {
        this.imgUUID = imgUUID;
        this.offset = offset;
        this.length = length;
        this.bytes = bytes;
    }

    @Override
    public PacketFlow getExecutingSide() {
        return PacketFlow.SERVERBOUND;
    }

    @Override
    public void executeServerSide(IPayloadContext context) {
        Player player = context.player();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer sender = (ServerPlayer)player;
        CameraMod.PACKET_MANAGER.addBytes(sender, this.imgUUID, this.offset, this.length, this.bytes);
    }

    @Override
    public MessagePartialImage fromBytes(RegistryFriendlyByteBuf buf) {
        this.imgUUID = buf.readUUID();
        this.offset = buf.readInt();
        this.length = buf.readInt();
        this.bytes = buf.readByteArray();
        return this;
    }

    @Override
    public void toBytes(RegistryFriendlyByteBuf buf) {
        buf.writeUUID(this.imgUUID);
        buf.writeInt(this.offset);
        buf.writeInt(this.length);
        buf.writeByteArray(this.bytes);
    }

    @Override
    public CustomPacketPayload.Type<MessagePartialImage> type() {
        return TYPE;
    }
}

