/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.client.gui.controls;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.MouseButtonEvent;
import net.p3pp3rf1y.sophisticatedcore.client.gui.controls.WidgetBase;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.Dimension;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.Position;
import org.jspecify.annotations.Nullable;

public abstract class CompositeWidgetBase<T extends WidgetBase>
extends WidgetBase
implements ContainerEventHandler {
    protected final List<T> children = new ArrayList<T>();
    private boolean dragging = false;
    private @Nullable GuiEventListener listener;

    protected CompositeWidgetBase(Position position, Dimension dimension) {
        super(position, dimension);
    }

    @Override
    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.children.forEach(child -> child.render(guiGraphics, mouseX, mouseY, partialTicks));
    }

    protected <U extends T> U addChild(U child) {
        this.children.add(child);
        return child;
    }

    public List<? extends GuiEventListener> children() {
        return this.children;
    }

    public boolean isDragging() {
        for (WidgetBase child : this.children) {
            ContainerEventHandler containerEventHandler;
            if (!(child instanceof ContainerEventHandler) || !(containerEventHandler = (ContainerEventHandler)child).isDragging()) continue;
            return true;
        }
        return this.dragging;
    }

    public boolean mouseClicked(MouseButtonEvent event, boolean doubleClicked) {
        return this.getChildAt(event.x(), event.y()).map(l -> {
            if (l.mouseClicked(event, doubleClicked)) {
                this.setFocused((GuiEventListener)l);
                if (event.button() == 0) {
                    this.setDragging(true);
                }
                return true;
            }
            return false;
        }).orElse(false);
    }

    public boolean mouseDragged(MouseButtonEvent event, double dragX, double dragY) {
        return this.getChildAt(event.x(), event.y()).map(l -> l.mouseDragged(event, dragX, dragY)).orElse(false);
    }

    public void setDragging(boolean dragging) {
        this.dragging = dragging;
    }

    public @Nullable GuiEventListener getFocused() {
        return this.listener;
    }

    public void setFocused(@Nullable GuiEventListener listener) {
        this.listener = listener;
    }

    @Override
    public void renderTooltip(Screen screen, GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.renderTooltip(screen, guiGraphics, mouseX, mouseY);
        this.children.forEach(c -> c.renderTooltip(screen, guiGraphics, mouseX, mouseY));
    }
}

