/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.compat.recipeviewers.jei;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.Optional;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.client.Minecraft;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.client.event.ScreenEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.p3pp3rf1y.sophisticatedcore.client.ClientEventHandler;
import net.p3pp3rf1y.sophisticatedcore.client.render.ItemInStorageHighlightRenderer;
import org.jspecify.annotations.Nullable;

public class JeiClientCompat {
    private static @Nullable IJeiRuntime runtime = null;

    public static void setRuntime(@Nullable IJeiRuntime runtime) {
        JeiClientCompat.runtime = runtime;
    }

    public static void init() {
        IEventBus eventBus = NeoForge.EVENT_BUS;
        eventBus.addListener(JeiClientCompat::handleGuiKeyPress);
        eventBus.addListener(JeiClientCompat::handleGuiMouseKeyPress);
        ClientEventHandler.registerHoveredStackSupplier(() -> JeiClientCompat.getStack().orElse(ItemStack.EMPTY));
    }

    private static Optional<ItemStack> getStack() {
        return runtime == null ? Optional.empty() : runtime.getIngredientListOverlay().getIngredientUnderMouse().or(() -> runtime.getBookmarkOverlay().getIngredientUnderMouse()).flatMap(ITypedIngredient::getItemStack).or(() -> runtime.getRecipesGui().getIngredientUnderMouse((IIngredientType)VanillaTypes.ITEM_STACK));
    }

    public static void handleGuiKeyPress(ScreenEvent.KeyPressed.Pre event) {
        if (runtime == null) {
            return;
        }
        InputConstants.Key key = InputConstants.getKey((KeyEvent)event.getKeyEvent());
        if (ClientEventHandler.ITEM_HIGHLIGHT_KEYBIND.isActiveAndMatches(key) && JeiClientCompat.getStack().map(JeiClientCompat::tryHighlightItem).orElse(false).booleanValue()) {
            event.getScreen().onClose();
            event.setCanceled(true);
        }
    }

    public static void handleGuiMouseKeyPress(ScreenEvent.MouseButtonPressed.Pre event) {
        if (runtime == null) {
            return;
        }
        InputConstants.Key input = InputConstants.Type.MOUSE.getOrCreate(event.getButton());
        if (ClientEventHandler.ITEM_HIGHLIGHT_KEYBIND.isActiveAndMatches(input) && JeiClientCompat.getStack().map(JeiClientCompat::tryHighlightItem).orElse(false).booleanValue()) {
            event.getScreen().onClose();
            event.setCanceled(true);
        }
    }

    private static boolean tryHighlightItem(ItemStack stack) {
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null) {
            return false;
        }
        ItemInStorageHighlightRenderer.highlightItem(player, stack);
        return true;
    }
}

