/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.inventory;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.Identifier;
import net.minecraft.world.ItemStackWithSlot;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.ValueInput;
import net.p3pp3rf1y.sophisticatedcore.SophisticatedCore;
import net.p3pp3rf1y.sophisticatedcore.inventory.ItemStackKey;
import net.p3pp3rf1y.sophisticatedcore.renderdata.DisplaySide;
import net.p3pp3rf1y.sophisticatedcore.settings.itemdisplay.ItemDisplaySettingsCategoryData;
import net.p3pp3rf1y.sophisticatedcore.settings.main.Context;
import net.p3pp3rf1y.sophisticatedcore.settings.main.MainSettingsCategoryData;
import net.p3pp3rf1y.sophisticatedcore.settings.memory.MemorySettingsCategoryData;
import net.p3pp3rf1y.sophisticatedcore.settings.nosort.NoSortSettingsCategoryData;
import net.p3pp3rf1y.sophisticatedcore.util.CodecHelper;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;
import net.p3pp3rf1y.sophisticatedcore.util.RegistryHelper;
import net.p3pp3rf1y.sophisticatedcore.util.ValueIOHelper;

public record ContainerContents(InventoryData inventory, PartitionerData partitioner, UpgradeData upgrades, SettingsData settings) {
    public static Codec<ContainerContents> CODEC = Codec.withAlternative((Codec)RecordCodecBuilder.create(instance -> instance.group((App)InventoryData.CODEC.fieldOf("inventory").forGetter(ContainerContents::inventory), (App)PartitionerData.CODEC.fieldOf("partitioner").forGetter(ContainerContents::partitioner), (App)UpgradeData.CODEC.fieldOf("upgrades").forGetter(ContainerContents::upgrades), (App)SettingsData.CODEC.fieldOf("settings").forGetter(ContainerContents::settings)).apply((Applicative)instance, ContainerContents::new)), (Codec)CompoundTag.CODEC, LegacyDeserialization::legacyDeserialize);
    public static final StreamCodec<RegistryFriendlyByteBuf, ContainerContents> STREAM_CODEC = StreamCodec.composite(InventoryData.STREAM_CODEC, ContainerContents::inventory, PartitionerData.STREAM_CODEC, ContainerContents::partitioner, UpgradeData.STREAM_CODEC, ContainerContents::upgrades, SettingsData.STREAM_CODEC, ContainerContents::settings, ContainerContents::new);

    public ContainerContents() {
        this(new InventoryData(), new PartitionerData(), new UpgradeData(), new SettingsData());
    }

    public ContainerContents copy() {
        return new ContainerContents(this.inventory.copy(), this.partitioner.copy(), this.upgrades.copy(), this.settings.copy());
    }

    public void reloadFrom(ContainerContents contents) {
        this.inventory.reloadFrom(contents.inventory);
        this.partitioner.reloadFrom(contents.partitioner);
        this.upgrades.reloadFrom(contents.upgrades);
        this.settings.reloadFrom(contents.settings);
    }

    public static class InventoryData {
        public static final Codec<InventoryData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)CodecHelper.OPTIONAL_OVERSIZED_ITEM_STACK_CODEC.listOf().xmap(CodecHelper::toMutableNonnullItemStackList, Function.identity()).fieldOf("stacks").forGetter(InventoryData::stacks)).apply((Applicative)instance, InventoryData::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, InventoryData> STREAM_CODEC = StreamCodec.composite((StreamCodec)ItemStack.OPTIONAL_STREAM_CODEC.apply(ByteBufCodecs.list()).map(CodecHelper::toMutableNonnullItemStackList, Function.identity()), InventoryData::stacks, InventoryData::new);
        private NonNullList<ItemStack> stacks;

        public InventoryData() {
            this.stacks = NonNullList.create();
        }

        public InventoryData(NonNullList<ItemStack> stacks) {
            this.stacks = stacks;
        }

        public NonNullList<ItemStack> stacks() {
            return this.stacks;
        }

        public InventoryData copy() {
            return new InventoryData((NonNullList<ItemStack>)this.stacks.stream().map(ItemStack::copy).collect(Collectors.toCollection(NonNullList::create)));
        }

        public void reloadFrom(InventoryData inventory) {
            this.stacks = inventory.stacks.stream().map(ItemStack::copy).collect(Collectors.toCollection(NonNullList::create));
        }

        public void resize(int newSize) {
            NonNullList newStacks = NonNullList.withSize((int)newSize, (Object)ItemStack.EMPTY);
            for (int i = 0; i < Math.min(this.stacks.size(), newSize); ++i) {
                newStacks.set(i, (Object)((ItemStack)this.stacks.get(i)));
            }
            this.stacks = newStacks;
        }
    }

    public static final class PartitionerData {
        private static final Codec<PartitionerData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.listOf().fieldOf("baseIndexes").forGetter(data -> Arrays.stream(data.baseIndexes).boxed().toList()), (App)Codec.STRING.listOf().fieldOf("partNames").forGetter(data -> data.partNames)).apply((Applicative)instance, (baseIndexesList, partNames) -> new PartitionerData(baseIndexesList.stream().mapToInt(Integer::intValue).toArray(), (List<String>)partNames)));
        private static final StreamCodec<RegistryFriendlyByteBuf, PartitionerData> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT.apply(ByteBufCodecs.list()).map(list -> list.stream().mapToInt(Integer::intValue).toArray(), arr -> Arrays.stream(arr).boxed().toList()), PartitionerData::baseIndexes, (StreamCodec)ByteBufCodecs.STRING_UTF8.apply(ByteBufCodecs.list()), PartitionerData::partNames, PartitionerData::new);
        private int[] baseIndexes;
        private List<String> partNames;

        public PartitionerData() {
            this.baseIndexes = new int[]{0};
            this.partNames = List.of("default");
        }

        public PartitionerData(int[] baseIndexes, List<String> partNames) {
            this.baseIndexes = baseIndexes;
            this.partNames = partNames;
        }

        public int[] baseIndexes() {
            return this.baseIndexes;
        }

        public List<String> partNames() {
            return this.partNames;
        }

        public PartitionerData copy() {
            return new PartitionerData(Arrays.copyOf(this.baseIndexes, this.baseIndexes.length), List.copyOf(this.partNames));
        }

        public void reloadFrom(PartitionerData partitioner) {
            this.baseIndexes = partitioner.baseIndexes;
            this.partNames = partitioner.partNames;
        }

        public void setPartBaseIndexesAndNames(int[] baseIndexes, List<String> partNames) {
            this.baseIndexes = baseIndexes;
            this.partNames = partNames;
        }
    }

    public static class UpgradeData {
        public static final Codec<UpgradeData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ItemStack.OPTIONAL_CODEC.listOf().xmap(CodecHelper::toMutableNonnullItemStackList, Function.identity()).fieldOf("stacks").forGetter(UpgradeData::stacks)).apply((Applicative)instance, UpgradeData::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, UpgradeData> STREAM_CODEC = StreamCodec.composite((StreamCodec)ItemStack.OPTIONAL_STREAM_CODEC.apply(ByteBufCodecs.list()).map(CodecHelper::toMutableNonnullItemStackList, Function.identity()), UpgradeData::stacks, UpgradeData::new);
        private NonNullList<ItemStack> stacks;

        public UpgradeData() {
            this.stacks = NonNullList.create();
        }

        public UpgradeData(NonNullList<ItemStack> stacks) {
            this.stacks = stacks;
        }

        public NonNullList<ItemStack> stacks() {
            return this.stacks;
        }

        public UpgradeData copy() {
            return new UpgradeData((NonNullList<ItemStack>)this.stacks.stream().map(ItemStack::copy).collect(Collectors.toCollection(NonNullList::create)));
        }

        public void reloadFrom(UpgradeData upgrades) {
            this.stacks = upgrades.stacks.stream().map(ItemStack::copy).collect(Collectors.toCollection(NonNullList::create));
        }

        public void setStacks(NonNullList<ItemStack> stacks) {
            this.stacks = stacks;
        }
    }

    public static class SettingsData {
        public static final Codec<SettingsData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.dispatchedMap((Codec)Codec.STRING, SettingsCategoryDataRegistry::getCodecOrThrow).xmap(CodecHelper::toMutable, Function.identity()).fieldOf("categories").forGetter(SettingsData::categories), (App)Context.CODEC.fieldOf("mainSettingsContext").forGetter(SettingsData::mainSettingsContext), (App)Codec.STRING.fieldOf("searchPhrase").forGetter(data -> data.searchPhrase)).apply((Applicative)instance, SettingsData::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, SettingsData> STREAM_CODEC = StreamCodec.composite((StreamCodec)StreamCodec.of((buf, categories) -> {
            buf.writeVarInt(categories.size());
            for (Map.Entry entry : categories.entrySet()) {
                buf.writeUtf((String)entry.getKey());
                SettingsCategoryDataRegistry.getStreamCodecOrThrow((String)entry.getKey()).encode(buf, (Object)((ISettingsCategoryData)entry.getValue()));
            }
        }, buf -> {
            int size = buf.readVarInt();
            HashMap<String, ISettingsCategoryData> categories = new HashMap<String, ISettingsCategoryData>();
            for (int i = 0; i < size; ++i) {
                String id = buf.readUtf();
                categories.put(id, (ISettingsCategoryData)SettingsCategoryDataRegistry.getStreamCodecOrThrow(id).decode(buf));
            }
            return categories;
        }), SettingsData::categories, Context.STREAM_CODEC, SettingsData::mainSettingsContext, (StreamCodec)ByteBufCodecs.STRING_UTF8, SettingsData::searchPhrase, SettingsData::new);
        private final Map<String, ISettingsCategoryData<?>> categories;
        private Context mainSettingsContext = Context.PLAYER;
        private String searchPhrase = "";

        public SettingsData(Map<String, ISettingsCategoryData<?>> categories, Context mainSettingsContext, String searchPhrase) {
            this.categories = categories;
            this.mainSettingsContext = mainSettingsContext;
            this.searchPhrase = searchPhrase;
        }

        public SettingsData() {
            this.categories = new HashMap();
        }

        public Map<String, ISettingsCategoryData<?>> categories() {
            return this.categories;
        }

        public <D extends ISettingsCategoryData<D>> D getCategoryData(String id) {
            return (D)this.categories.get(id);
        }

        public Context mainSettingsContext() {
            return this.mainSettingsContext;
        }

        public void setMainSettingsContext(Context context) {
            this.mainSettingsContext = context;
        }

        public String searchPhrase() {
            return this.searchPhrase;
        }

        public void setSearchPhrase(String searchPhrase) {
            this.searchPhrase = searchPhrase;
        }

        public SettingsData copy() {
            HashMap copiedCategories = new HashMap();
            this.categories.forEach((key, value) -> copiedCategories.put((String)key, (ISettingsCategoryData<?>)value.copy()));
            return new SettingsData(copiedCategories, this.mainSettingsContext, this.searchPhrase);
        }

        public void reloadFrom(SettingsData settings) {
            this.categories.forEach((name, categoryData) -> {
                if (settings.categories.containsKey(name)) {
                    categoryData.reloadFromAny(settings.categories.get(name));
                }
            });
            this.mainSettingsContext = settings.mainSettingsContext;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            SettingsData that = (SettingsData)obj;
            return Objects.equals(this.categories, that.categories);
        }
    }

    public static class LegacyDeserialization {
        private static final String INVENTORY_TAG = "inventory";
        private static final String PARTITIONER_TAG = "partitioner";
        private static final String BASE_INDEXES_TAG = "baseIndexes";
        private static final String UPGRADE_INVENTORY_TAG = "upgradeInventory";
        public static final String SETTINGS_TAG = "settings";
        private static final String COLOR_TAG = "color";
        private static final String SELECTED_SLOTS_TAG = "selectedSlots";
        private static final String SLOT_FILTER_ITEMS_TAG = "slotFilterItems";
        private static final String SLOT_FILTER_STACKS_TAG = "slotFilterStacks";
        private static final String IGNORE_NBT_TAG = "ignoreNbt";
        private static final String SLOTS_TAG = "slots";
        private static final String ROTATIONS_TAG = "rotations";
        private static final String DISPLAY_SIDE_TAG = "displaySide";

        private static ContainerContents legacyDeserialize(CompoundTag contentsNbt) {
            return new ContainerContents(LegacyDeserialization.deserializeInventoryData(contentsNbt.getCompoundOrEmpty(INVENTORY_TAG)), LegacyDeserialization.deserializePartitionerData(contentsNbt.getCompoundOrEmpty(PARTITIONER_TAG)), LegacyDeserialization.deserializeUpgradeData(contentsNbt.getCompoundOrEmpty(UPGRADE_INVENTORY_TAG)), LegacyDeserialization.deserializeSettingsData(contentsNbt.getCompoundOrEmpty(SETTINGS_TAG)));
        }

        public static SettingsData deserializeSettingsData(CompoundTag settingsNbt) {
            HashMap categories = new HashMap();
            settingsNbt.getCompound("no_sort").ifPresent(categoryNbt -> categories.put("no_sort", LegacyDeserialization.deserializeNoSort(categoryNbt)));
            settingsNbt.getCompound("memory").ifPresent(categoryNbt -> categories.put("memory", LegacyDeserialization.deserializeMemory(categoryNbt)));
            settingsNbt.getCompound("item_display").ifPresent(categoryNbt -> categories.put("item_display", LegacyDeserialization.deserializeItemDisplay(categoryNbt)));
            return new SettingsData(categories, Context.PLAYER, "");
        }

        private static ItemDisplaySettingsCategoryData deserializeItemDisplay(CompoundTag categoryNbt) {
            List slotIndexes = NBTHelper.getIntArray(categoryNbt, SLOTS_TAG).map(arr -> Arrays.stream(arr).boxed().collect(Collectors.toCollection(ArrayList::new))).orElseGet(ArrayList::new);
            Map slotRotations = NBTHelper.getMap(categoryNbt, ROTATIONS_TAG, Integer::valueOf, (k, v) -> v.asInt()).orElseGet(HashMap::new);
            DyeColor color = NBTHelper.getInt(categoryNbt, COLOR_TAG).map(DyeColor::byId).orElse(DyeColor.RED);
            DisplaySide displaySide = NBTHelper.getEnumConstant(categoryNbt, DISPLAY_SIDE_TAG, DisplaySide::fromName).orElse(DisplaySide.FRONT);
            return new ItemDisplaySettingsCategoryData(color, slotIndexes, slotRotations, displaySide);
        }

        private static NoSortSettingsCategoryData deserializeNoSort(CompoundTag categoryNbt) {
            HashSet<Integer> selectedSlots = new HashSet<Integer>();
            categoryNbt.getIntArray(SELECTED_SLOTS_TAG).ifPresent(slotNumbers -> {
                for (int slotNumber : slotNumbers) {
                    selectedSlots.add(slotNumber);
                }
            });
            DyeColor color = NBTHelper.getInt(categoryNbt, COLOR_TAG).map(DyeColor::byId).orElse(DyeColor.LIME);
            return new NoSortSettingsCategoryData(selectedSlots, color);
        }

        private static MemorySettingsCategoryData deserializeMemory(CompoundTag categoryNbt) {
            Map slotFilterItems = NBTHelper.getMap(categoryNbt, SLOT_FILTER_ITEMS_TAG, Integer::valueOf, (k, v) -> BuiltInRegistries.ITEM.getOptional((Identifier)v.asString().map(Identifier::parse).orElse(null))).orElseGet(HashMap::new);
            Map slotFilterStacks = NBTHelper.getMap(categoryNbt, SLOT_FILTER_STACKS_TAG, Integer::valueOf, (k, v) -> {
                Optional<Object> optional;
                if (v instanceof CompoundTag) {
                    CompoundTag tag = (CompoundTag)v;
                    optional = NBTHelper.deserializeStackFromTag((Tag)tag).map(ItemStackKey::of);
                } else {
                    optional = Optional.empty();
                }
                return optional;
            }).orElseGet(HashMap::new);
            boolean ignoreNbt = NBTHelper.getBoolean(categoryNbt, IGNORE_NBT_TAG).orElse(true);
            return new MemorySettingsCategoryData(slotFilterItems, slotFilterStacks, ignoreNbt);
        }

        private static UpgradeData deserializeUpgradeData(CompoundTag upgradeInventoryNbt) {
            return RegistryHelper.getRegistryAccess().map(registryAccess -> {
                ValueInput input = ValueIOHelper.inputFromCompoundTag((HolderLookup.Provider)registryAccess, upgradeInventoryNbt);
                int size = input.getIntOr("Size", 0);
                NonNullList stacks = NonNullList.withSize((int)size, (Object)ItemStack.EMPTY);
                input.listOrEmpty("Items", ItemStackWithSlot.CODEC).forEach(slot -> {
                    if (slot.isValidInContainer(stacks.size())) {
                        stacks.set(slot.slot(), (Object)slot.stack());
                    }
                });
                return new UpgradeData((NonNullList<ItemStack>)stacks);
            }).orElse(new UpgradeData());
        }

        private static PartitionerData deserializePartitionerData(CompoundTag partitionerNbt) {
            int[] baseIndexes = partitionerNbt.getIntArray(BASE_INDEXES_TAG).orElse(new int[]{0});
            List partNames = partitionerNbt.getListOrEmpty("inventoryPartNames").stream().map(Tag::asString).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toCollection(ArrayList::new));
            return new PartitionerData(baseIndexes, partNames);
        }

        private static InventoryData deserializeInventoryData(CompoundTag nbt) {
            int size = nbt.getIntOr("Size", 0);
            NonNullList stacks = NonNullList.withSize((int)size, (Object)ItemStack.EMPTY);
            ListTag tagList = nbt.getListOrEmpty("Items");
            RegistryHelper.getRegistryAccess().ifPresent(registryAccess -> {
                for (int i = 0; i < tagList.size(); ++i) {
                    tagList.getCompound(i).ifPresent(itemTag -> {
                        int slot = itemTag.getIntOr("Slot", 0);
                        if (slot >= 0 && slot < stacks.size()) {
                            LegacyDeserialization.getStackFromNbt((Tag)itemTag, registryAccess).ifPresent(stack -> stacks.set(slot, stack));
                        }
                    });
                }
            });
            return new InventoryData((NonNullList<ItemStack>)stacks);
        }

        private static Optional<ItemStack> getStackFromNbt(Tag itemTag, RegistryAccess registryAccess) {
            return CodecHelper.OVERSIZED_ITEM_STACK_CODEC.parse((DynamicOps)registryAccess.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)itemTag).resultOrPartial(itemName -> SophisticatedCore.LOGGER.error("Tried to load invalid item: '{}'", itemName));
        }
    }

    public static class SettingsCategoryDataRegistry {
        private static final Map<String, Codec<? extends ISettingsCategoryData<?>>> CODECS = new HashMap();
        private static final Map<String, StreamCodec<RegistryFriendlyByteBuf, ? extends ISettingsCategoryData<?>>> STREAM_CODECS = new HashMap();

        private SettingsCategoryDataRegistry() {
        }

        public static void register(Codec<? extends ISettingsCategoryData<?>> codec, StreamCodec<RegistryFriendlyByteBuf, ? extends ISettingsCategoryData<?>> streamCodec, String id) {
            CODECS.put(id, codec);
            STREAM_CODECS.put(id, streamCodec);
        }

        public static <T extends ISettingsCategoryData<?>> Codec<T> getCodecOrThrow(String id) {
            if (!CODECS.containsKey(id)) {
                throw new IllegalArgumentException("SettingsCategoryData codec not found for id: " + id);
            }
            return CODECS.get(id);
        }

        public static <T extends ISettingsCategoryData<?>> StreamCodec<RegistryFriendlyByteBuf, T> getStreamCodecOrThrow(String id) {
            if (!STREAM_CODECS.containsKey(id)) {
                throw new IllegalArgumentException("SettingsCategoryData stream codec not found for id: " + id);
            }
            return STREAM_CODECS.get(id);
        }

        static {
            SettingsCategoryDataRegistry.register(MainSettingsCategoryData.CODEC, MainSettingsCategoryData.STREAM_CODEC, "global");
            SettingsCategoryDataRegistry.register(NoSortSettingsCategoryData.CODEC, NoSortSettingsCategoryData.STREAM_CODEC, "no_sort");
            SettingsCategoryDataRegistry.register(MemorySettingsCategoryData.CODEC, MemorySettingsCategoryData.STREAM_CODEC, "memory");
            SettingsCategoryDataRegistry.register(ItemDisplaySettingsCategoryData.CODEC, ItemDisplaySettingsCategoryData.STREAM_CODEC, "item_display");
        }
    }

    public static interface ISettingsCategoryData<T extends ISettingsCategoryData<T>> {
        public String id();

        public T copy();

        public void reloadFrom(T var1);

        default public void reloadFromAny(ISettingsCategoryData<?> src) {
            if (this.getClass().isInstance(src)) {
                this.reloadFrom(src);
            }
        }
    }
}

