/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.inventory;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;
import net.p3pp3rf1y.sophisticatedcore.inventory.ITrackedContentsItemResourceHandler;
import net.p3pp3rf1y.sophisticatedcore.inventory.ItemStackKey;
import net.p3pp3rf1y.sophisticatedcore.upgrades.FilterLogic;

public class FilteredItemHandler<T extends ResourceHandler<ItemResource>>
implements ResourceHandler<ItemResource> {
    protected final T inventoryHandler;
    protected final List<FilterLogic> inputFilters;
    private final List<FilterLogic> outputFilters;

    public FilteredItemHandler(T inventoryHandler, List<FilterLogic> inputFilters, List<FilterLogic> outputFilters) {
        this.inventoryHandler = inventoryHandler;
        this.inputFilters = inputFilters;
        this.outputFilters = outputFilters;
    }

    public int size() {
        return this.inventoryHandler.size();
    }

    public ItemResource getResource(int i) {
        return (ItemResource)this.inventoryHandler.getResource(i);
    }

    public long getAmountAsLong(int i) {
        return this.inventoryHandler.getAmountAsLong(i);
    }

    public int insert(int index, ItemResource resource, int amount, TransactionContext transactionContext) {
        if (this.matchesFilters(resource, this.inputFilters)) {
            return this.inventoryHandler.insert(index, (Resource)resource, amount, transactionContext);
        }
        return 0;
    }

    public int insert(ItemResource resource, int amount, TransactionContext transaction) {
        if (this.matchesFilters(resource, this.inputFilters)) {
            return this.inventoryHandler.insert((Resource)resource, amount, transaction);
        }
        return 0;
    }

    public int extract(ItemResource resource, int amount, TransactionContext transaction) {
        if (this.matchesFilters(resource, this.outputFilters)) {
            return this.inventoryHandler.extract((Resource)resource, amount, transaction);
        }
        return 0;
    }

    public int extract(int index, ItemResource resource, int amount, TransactionContext transactionContext) {
        if (this.matchesFilters(resource, this.outputFilters)) {
            return this.inventoryHandler.extract(index, (Resource)resource, amount, transactionContext);
        }
        return 0;
    }

    protected boolean matchesFilters(ItemResource resource, List<FilterLogic> filters) {
        if (filters.isEmpty()) {
            return true;
        }
        boolean matchAll = this.shouldMatchAllFilters(filters);
        for (FilterLogic filter : filters) {
            if (matchAll && !filter.matchesFilter(resource)) {
                return false;
            }
            if (matchAll || !filter.matchesFilter(resource)) continue;
            return true;
        }
        return matchAll;
    }

    protected boolean shouldMatchAllFilters(List<FilterLogic> filters) {
        if (filters.size() < 2) {
            return false;
        }
        for (FilterLogic filter : filters) {
            if (filter.isAllowList()) continue;
            return true;
        }
        return false;
    }

    public long getCapacityAsLong(int i, ItemResource resource) {
        return this.inventoryHandler.getCapacityAsLong(i, (Resource)resource);
    }

    public boolean isValid(int i, ItemResource resource) {
        if (this.matchesFilters(resource, this.inputFilters)) {
            return this.inventoryHandler.isValid(i, (Resource)resource);
        }
        return false;
    }

    public static class Modifiable
    extends FilteredItemHandler<ITrackedContentsItemResourceHandler>
    implements ITrackedContentsItemResourceHandler {
        public Modifiable(ITrackedContentsItemResourceHandler inventoryHandler, List<FilterLogic> inputFilters, List<FilterLogic> outputFilters) {
            super(inventoryHandler, inputFilters, outputFilters);
        }

        @Override
        public void setStackInSlot(int slot, ItemStack stack) {
            ((ITrackedContentsItemResourceHandler)this.inventoryHandler).setStackInSlot(slot, stack);
        }

        @Override
        public int insert(int index, ItemResource resource, int amount, TransactionContext transactionContext) {
            return super.insert(index, resource, amount, transactionContext);
        }

        @Override
        public ItemStack getStackInSlot(int slot) {
            return ((ITrackedContentsItemResourceHandler)this.inventoryHandler).getStackInSlot(slot);
        }

        @Override
        public int insert(ItemResource resource, int amount, TransactionContext transaction) {
            return super.insert(resource, amount, transaction);
        }

        protected boolean matchesFilters(ItemStack stack, List<FilterLogic> filters) {
            if (filters.isEmpty()) {
                return true;
            }
            boolean matchAll = this.shouldMatchAllFilters(filters);
            for (FilterLogic filter : filters) {
                if (matchAll && !filter.matchesFilter(stack)) {
                    return false;
                }
                if (matchAll || !filter.matchesFilter(stack)) continue;
                return true;
            }
            return matchAll;
        }

        @Override
        public Set<ItemStackKey> getTrackedStacks() {
            HashSet<ItemStackKey> ret = new HashSet<ItemStackKey>();
            ((ITrackedContentsItemResourceHandler)this.inventoryHandler).getTrackedStacks().forEach(ts -> {
                if (this.matchesFilters(ts.stack(), (List<FilterLogic>)this.inputFilters)) {
                    ret.add((ItemStackKey)ts);
                }
            });
            return ret;
        }

        @Override
        public void registerTrackingListeners(Consumer<ItemStackKey> onAddStackKey, Consumer<ItemStackKey> onRemoveStackKey, Runnable onAddFirstEmptySlot, Runnable onRemoveLastEmptySlot) {
            ((ITrackedContentsItemResourceHandler)this.inventoryHandler).registerTrackingListeners(isk -> {
                if (this.matchesFilters(isk.stack(), (List<FilterLogic>)this.inputFilters)) {
                    onAddStackKey.accept((ItemStackKey)isk);
                }
            }, isk -> {
                if (this.matchesFilters(isk.stack(), (List<FilterLogic>)this.inputFilters)) {
                    onRemoveStackKey.accept((ItemStackKey)isk);
                }
            }, onAddFirstEmptySlot, onRemoveLastEmptySlot);
        }

        @Override
        public void unregisterStackKeyListeners() {
            ((ITrackedContentsItemResourceHandler)this.inventoryHandler).unregisterStackKeyListeners();
        }

        @Override
        public boolean hasEmptySlots() {
            return ((ITrackedContentsItemResourceHandler)this.inventoryHandler).hasEmptySlots();
        }

        @Override
        public int getInternalSlotLimit(int slot) {
            return ((ITrackedContentsItemResourceHandler)this.inventoryHandler).getInternalSlotLimit(slot);
        }

        @Override
        public boolean isInsertBlocked() {
            return ((ITrackedContentsItemResourceHandler)this.inventoryHandler).isInsertBlocked();
        }
    }
}

