/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.network;

import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.Identifier;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.p3pp3rf1y.sophisticatedcore.SophisticatedCore;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.TranslationHelper;
import net.p3pp3rf1y.sophisticatedcore.common.IItemActionPayloadHandler;
import net.p3pp3rf1y.sophisticatedcore.common.ItemActionHandlerRegistry;
import net.p3pp3rf1y.sophisticatedcore.controller.ControllerBlockEntityBase;
import net.p3pp3rf1y.sophisticatedcore.controller.IControllableStorage;
import net.p3pp3rf1y.sophisticatedcore.inventory.ISlotTracker;
import net.p3pp3rf1y.sophisticatedcore.inventory.InventoryHandler;
import net.p3pp3rf1y.sophisticatedcore.inventory.ItemStackKey;
import net.p3pp3rf1y.sophisticatedcore.network.SyncItemTransfersPayload;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;
import net.p3pp3rf1y.sophisticatedcore.util.RandHelper;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;

public record DepositItemsPayload(int minSlot, int maxSlot, List<BlockPos> storagePositions, List<BlockPos> controllerPositions, Map<Identifier, Object> extras, boolean onlyMatching) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<DepositItemsPayload> TYPE = new CustomPacketPayload.Type(SophisticatedCore.getIdentifier("deposit_items"));
    public static final StreamCodec<RegistryFriendlyByteBuf, DepositItemsPayload> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, DepositItemsPayload::minSlot, (StreamCodec)ByteBufCodecs.INT, DepositItemsPayload::maxSlot, (StreamCodec)BlockPos.STREAM_CODEC.apply(ByteBufCodecs.list()), DepositItemsPayload::storagePositions, (StreamCodec)BlockPos.STREAM_CODEC.apply(ByteBufCodecs.list()), DepositItemsPayload::controllerPositions, ItemActionHandlerRegistry.EXTRAS_STREAM_CODEC, DepositItemsPayload::extras, (StreamCodec)ByteBufCodecs.BOOL, DepositItemsPayload::onlyMatching, DepositItemsPayload::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handlePayload(DepositItemsPayload payload, IPayloadContext context) {
        MutableComponent message;
        Player player = context.player();
        Level level = player.level();
        TreeMap<Vec3, IDepositHandler> depositHandlers = new TreeMap<Vec3, IDepositHandler>(Comparator.comparingDouble(arg_0 -> ((Player)player).distanceToSqr(arg_0)).thenComparingDouble(Vec3::x).thenComparingDouble(Vec3::y).thenComparingDouble(Vec3::z));
        HashSet<BlockPos> controllerPositions = new HashSet<BlockPos>(payload.controllerPositions());
        Level level2 = player.level();
        if (level2 instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level2;
            payload.storagePositions().stream().filter(pos -> WorldHelper.playerMayInteract(player, pos)).map(pos -> WorldHelper.getBlockEntity((BlockGetter)level, pos, IControllableStorage.class)).filter(Optional::isPresent).map(Optional::get).forEach(s -> s.getControllerPos().ifPresentOrElse(controllerPositions::add, () -> depositHandlers.put(s.getStorageBlockPos().getCenter(), new StorageDepositHandler(s.getStorageWrapper().getInventoryHandler()))));
            controllerPositions.stream().filter(pos -> WorldHelper.playerMayInteract(player, pos)).map(pos -> WorldHelper.getBlockEntity((BlockGetter)player.level(), pos, ControllerBlockEntityBase.class)).filter(Optional::isPresent).map(Optional::get).forEach(c -> depositHandlers.put(c.getBlockPos().getCenter(), new ControllerDepositHandler((ControllerBlockEntityBase)c)));
        }
        payload.extras().forEach((id, extraData) -> ItemActionHandlerRegistry.get(id).ifPresent(handler -> DepositItemsPayload.getTargetInventories(handler, player, extraData).forEach((pos, inventory) -> depositHandlers.put((Vec3)pos, new StorageDepositHandler((InventoryHandler)inventory)))));
        HashMap<Vec3, ItemStack> inserted = new HashMap<Vec3, ItemStack>();
        HashSet<Integer> depositedFromSlots = new HashSet<Integer>();
        DepositItemsPayload.depositSlotsToHandlers(payload, player, depositHandlers, inserted, depositedFromSlots, true);
        if (!payload.onlyMatching()) {
            DepositItemsPayload.depositSlotsToHandlers(payload, player, depositHandlers, inserted, depositedFromSlots, false);
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            Vec3 playerPos = player.getEyePosition().add(0.0, -0.1, 0.0);
            PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new SyncItemTransfersPayload(inserted, playerPos, true), (CustomPacketPayload[])new CustomPacketPayload[0]);
            PacketDistributor.sendToPlayersTrackingEntity((Entity)serverPlayer, (CustomPacketPayload)new SyncItemTransfersPayload(inserted, playerPos, true), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        if (payload.maxSlot() - payload.minSlot() == 1) {
            if (inserted.isEmpty()) {
                message = TranslationHelper.INSTANCE.translStatusMessage("cannot_deposit_item", Component.literal((String)player.getInventory().getItem(payload.minSlot()).getHoverName().getString()).withStyle(ChatFormatting.RED));
                level.playSound(null, (Entity)player, (SoundEvent)SoundEvents.NOTE_BLOCK_BASS.value(), SoundSource.PLAYERS, 1.0f, 0.7f + RandHelper.getRandomMinusOneToOne(level.random) * 0.1f);
            } else {
                message = TranslationHelper.INSTANCE.translStatusMessage("deposited_item", Component.literal((String)((ItemStack)inserted.values().iterator().next()).getHoverName().getString()).withStyle(ChatFormatting.DARK_GREEN));
            }
        } else if (inserted.isEmpty()) {
            message = TranslationHelper.INSTANCE.translStatusMessage("cannot_deposit_items", new Object[0]);
            level.playSound(null, (Entity)player, (SoundEvent)SoundEvents.NOTE_BLOCK_BASS.value(), SoundSource.PLAYERS, 1.0f, 0.7f + RandHelper.getRandomMinusOneToOne(level.random) * 0.1f);
        } else {
            message = TranslationHelper.INSTANCE.translStatusMessage("deposited_items", Component.literal((String)String.valueOf(depositedFromSlots.size())).withStyle(ChatFormatting.DARK_GREEN));
        }
        player.displayClientMessage((Component)message, true);
    }

    private static void depositSlotsToHandlers(DepositItemsPayload payload, Player player, Map<Vec3, IDepositHandler> depositHandlers, Map<Vec3, ItemStack> inserted, Set<Integer> depositedFromSlots, boolean checkPresent) {
        block0: for (int slot = payload.minSlot(); slot < payload.maxSlot(); ++slot) {
            ItemStack stack = player.getInventory().getItem(slot);
            if (stack.isEmpty()) continue;
            ItemStackKey stackKey = ItemStackKey.of(stack);
            for (Map.Entry<Vec3, IDepositHandler> entry : depositHandlers.entrySet()) {
                ItemStack remaining;
                Vec3 pos = entry.getKey();
                IDepositHandler handler = entry.getValue();
                if (checkPresent && !handler.isPresent(stackKey) || (remaining = handler.deposit(stack)).getCount() >= stack.getCount()) continue;
                inserted.put(pos, stack.copyWithCount(stack.getCount() - remaining.getCount()));
                player.getInventory().setItem(slot, remaining);
                depositedFromSlots.add(slot);
                stack = remaining;
                if (!stack.isEmpty()) continue;
                continue block0;
            }
        }
    }

    private static <T> Map<Vec3, InventoryHandler> getTargetInventories(IItemActionPayloadHandler<T> handler, Player player, Object extraData) {
        return handler.getTargetInventories(player, extraData);
    }

    private static interface IDepositHandler {
        public boolean isPresent(ItemStackKey var1);

        public ItemStack deposit(ItemStack var1);
    }

    private static class StorageDepositHandler
    implements IDepositHandler {
        private final InventoryHandler inventoryHandler;

        public StorageDepositHandler(InventoryHandler inventoryHandler) {
            this.inventoryHandler = inventoryHandler;
        }

        @Override
        public boolean isPresent(ItemStackKey stackKey) {
            ISlotTracker slotTracker = this.inventoryHandler.getSlotTracker();
            if (slotTracker.getPartialStacks().contains(stackKey) || slotTracker.getFullStacks().contains(stackKey) || slotTracker.getItems().contains(stackKey.stack().getItem())) {
                return true;
            }
            return slotTracker.hasStackMemorizedOrFiltered(stackKey.stack());
        }

        @Override
        public ItemStack deposit(ItemStack stack) {
            int inserted = InventoryHelper.insert(this.inventoryHandler, ItemResource.of((ItemStack)stack), stack.getCount());
            return inserted == 0 ? stack : stack.copyWithCount(stack.getCount() - inserted);
        }
    }

    private static class ControllerDepositHandler
    implements IDepositHandler {
        private final ControllerBlockEntityBase controller;

        public ControllerDepositHandler(ControllerBlockEntityBase controller) {
            this.controller = controller;
        }

        @Override
        public boolean isPresent(ItemStackKey stackKey) {
            return this.controller.hasMatchingStackOrItem(stackKey);
        }

        @Override
        public ItemStack deposit(ItemStack stack) {
            int inserted = InventoryHelper.insert(this.controller, ItemResource.of((ItemStack)stack), stack.getCount());
            return inserted == 0 ? stack : stack.copyWithCount(stack.getCount() - inserted);
        }
    }
}

