/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.settings.itemdisplay;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.DyeColor;
import net.p3pp3rf1y.sophisticatedcore.inventory.ContainerContents;
import net.p3pp3rf1y.sophisticatedcore.renderdata.DisplaySide;
import net.p3pp3rf1y.sophisticatedcore.util.CodecHelper;

public class ItemDisplaySettingsCategoryData
implements ContainerContents.ISettingsCategoryData<ItemDisplaySettingsCategoryData> {
    public static Codec<ItemDisplaySettingsCategoryData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)DyeColor.CODEC.fieldOf("color").forGetter(data -> data.color), (App)Codec.list((Codec)Codec.INT).fieldOf("slotIndexes").forGetter(data -> data.slotIndexes), (App)Codec.unboundedMap(CodecHelper.STRING_ENCODED_INT, (Codec)Codec.INT).fieldOf("slotRotations").forGetter(data -> data.slotRotations), (App)DisplaySide.CODEC.fieldOf("displaySide").forGetter(data -> data.displaySide)).apply((Applicative)instance, ItemDisplaySettingsCategoryData::new));
    public static StreamCodec<RegistryFriendlyByteBuf, ItemDisplaySettingsCategoryData> STREAM_CODEC = StreamCodec.composite((StreamCodec)DyeColor.STREAM_CODEC, ItemDisplaySettingsCategoryData::color, (StreamCodec)ByteBufCodecs.VAR_INT.apply(ByteBufCodecs.list()), ItemDisplaySettingsCategoryData::slotIndexes, (StreamCodec)ByteBufCodecs.map(HashMap::new, (StreamCodec)ByteBufCodecs.VAR_INT, (StreamCodec)ByteBufCodecs.VAR_INT), data -> data.slotRotations, DisplaySide.STREAM_CODEC, data -> data.displaySide, ItemDisplaySettingsCategoryData::new);
    private DyeColor color = DyeColor.RED;
    private List<Integer> slotIndexes = new LinkedList<Integer>();
    private Map<Integer, Integer> slotRotations = new HashMap<Integer, Integer>();
    private DisplaySide displaySide = DisplaySide.FRONT;

    public ItemDisplaySettingsCategoryData() {
    }

    public ItemDisplaySettingsCategoryData(DyeColor color, List<Integer> slotIndexes, Map<Integer, Integer> slotRotations, DisplaySide displaySide) {
        this.color = color;
        this.slotIndexes.addAll(slotIndexes);
        this.slotRotations.putAll(slotRotations);
        this.displaySide = displaySide;
    }

    @Override
    public String id() {
        return "item_display";
    }

    @Override
    public ItemDisplaySettingsCategoryData copy() {
        return new ItemDisplaySettingsCategoryData(this.color, new LinkedList<Integer>(this.slotIndexes), new HashMap<Integer, Integer>(this.slotRotations), this.displaySide);
    }

    @Override
    public void reloadFrom(ItemDisplaySettingsCategoryData other) {
        this.color = other.color;
        this.slotIndexes = new LinkedList<Integer>(other.slotIndexes);
        this.slotRotations = new HashMap<Integer, Integer>(other.slotRotations);
        this.displaySide = other.displaySide;
    }

    public DyeColor color() {
        return this.color;
    }

    public List<Integer> slotIndexes() {
        return this.slotIndexes;
    }

    public void removeSlotIndex(int slotIndex) {
        this.slotIndexes.removeIf(index -> index == slotIndex);
        this.slotRotations.remove(slotIndex);
    }

    public Map<Integer, Integer> slotRotations() {
        return this.slotRotations;
    }

    public DisplaySide displaySide() {
        return this.displaySide;
    }

    public void setColor(DyeColor color) {
        this.color = color;
    }

    public void setRotation(int slotIndex, int rotation) {
        this.slotRotations.put(slotIndex, rotation);
    }

    public void setDisplaySide(DisplaySide displaySide) {
        this.displaySide = displaySide;
    }

    public void addSlot(int slotIndex) {
        this.slotIndexes.add(slotIndex);
    }

    public void removeSlot(int slotIndex) {
        this.slotIndexes.removeIf(slot -> slot >= slotIndex);
    }

    public boolean equals(Object o) {
        if (!(o instanceof ItemDisplaySettingsCategoryData)) {
            return false;
        }
        ItemDisplaySettingsCategoryData that = (ItemDisplaySettingsCategoryData)o;
        return this.color == that.color && Objects.equals(this.slotIndexes, that.slotIndexes) && Objects.equals(this.slotRotations, that.slotRotations) && this.displaySide == that.displaySide;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.color, this.slotIndexes, this.slotRotations, this.displaySide});
    }
}

