/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.settings.main;

import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.p3pp3rf1y.sophisticatedcore.common.gui.SettingsContainerMenu;
import net.p3pp3rf1y.sophisticatedcore.settings.SettingsContainerBase;
import net.p3pp3rf1y.sophisticatedcore.settings.main.Context;
import net.p3pp3rf1y.sophisticatedcore.settings.main.MainSettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.settings.main.MainSettingsCategoryData;
import net.p3pp3rf1y.sophisticatedcore.settings.main.PlayerMainSettingsSavedData;

public class MainSettingsContainer
extends SettingsContainerBase<MainSettingsCategory> {
    private static final String CONTEXT_TAG = "context";
    private static final String SHIFT_CLICK_INTO_OPEN_TAB_FIRST = "shiftClickIntoOpenTabFirst";
    private static final String KEEP_TAB_OPEN_TAG = "keepTabOpen";
    private static final String KEEP_SEARCH_PHRASE_TAG = "keepSearchPhrase";

    public MainSettingsContainer(SettingsContainerMenu<?> settingsContainer, String categoryName, MainSettingsCategory category) {
        super(settingsContainer, categoryName, category);
    }

    @Override
    public void handlePacket(CompoundTag data) {
        data.getString(CONTEXT_TAG).ifPresent(name -> ((MainSettingsCategory)this.getCategory()).setContext(Context.fromName(name)));
        data.getBoolean(SHIFT_CLICK_INTO_OPEN_TAB_FIRST).ifPresent(this::setShiftClickIntoOpenTab);
        data.getBoolean(KEEP_TAB_OPEN_TAG).ifPresent(this::setKeepTabOpen);
        data.getBoolean(KEEP_SEARCH_PHRASE_TAG).ifPresent(this::setKeepSearchPhrase);
    }

    private void setShiftClickIntoOpenTab(boolean value) {
        this.setSettingValue(data -> data.setShiftClickIntoOpenTab(value), tag -> tag.putBoolean(SHIFT_CLICK_INTO_OPEN_TAB_FIRST, value));
    }

    public void toggleContext() {
        ((MainSettingsCategory)this.getCategory()).toggleContext();
        this.sendStringToServer(CONTEXT_TAG, this.getContext().getSerializedName());
    }

    public Context getContext() {
        return ((MainSettingsCategory)this.getCategory()).getContext();
    }

    protected Player getPlayer() {
        return this.getSettingsContainer().getPlayer();
    }

    public void toggleShiftClickIntoOpenTab() {
        this.setShiftClickIntoOpenTab(!this.shouldShiftClickIntoOpenTab());
    }

    public boolean shouldShiftClickIntoOpenTab() {
        return this.getSettingValue(MainSettingsCategoryData::shiftClickIntoOpenTab);
    }

    private void setKeepTabOpen(boolean value) {
        this.setSettingValue(data -> data.setKeepTabOpen(value), tag -> tag.putBoolean(KEEP_TAB_OPEN_TAG, value));
    }

    public void toggleKeepTabOpen() {
        this.setKeepTabOpen(!this.shouldKeepTabOpen());
    }

    private void setKeepSearchPhrase(boolean value) {
        this.setSettingValue(data -> data.setKeepSearchPhrase(value), tag -> tag.putBoolean(KEEP_SEARCH_PHRASE_TAG, value));
    }

    public void toggleKeepSearchPhrase() {
        this.setKeepSearchPhrase(!this.shouldKeepSearchPhrase());
    }

    public boolean shouldKeepTabOpen() {
        return this.getSettingValue(MainSettingsCategoryData::keepTabOpen);
    }

    public boolean shouldKeepSearchPhrase() {
        return this.getSettingValue(MainSettingsCategoryData::keepSearchPhrase);
    }

    protected <T> T getSettingValue(Function<MainSettingsCategoryData, T> getter) {
        return this.getSettingsContainer().getStorageWrapper().getSettingsHandler().getMainSettingValue(this.getPlayer(), getter);
    }

    public void setSettingValue(Consumer<MainSettingsCategoryData> setter, Consumer<CompoundTag> dataSetter) {
        if (this.getContext() == Context.PLAYER) {
            PlayerMainSettingsSavedData.get().setvalue(this.getPlayer().getUUID(), ((MainSettingsCategory)this.getCategory()).getPlayerSettingsName(), setter);
        } else {
            ((MainSettingsCategory)this.getCategory()).setValue(setter);
        }
        this.sendDataToServer(() -> {
            CompoundTag data = new CompoundTag();
            dataSetter.accept(data);
            return data;
        });
    }
}

