/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntConsumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.p3pp3rf1y.sophisticatedcore.upgrades.FilterAttributes;
import net.p3pp3rf1y.sophisticatedcore.upgrades.PrimaryMatch;
import net.p3pp3rf1y.sophisticatedcore.util.FilterItemStackHandler;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;
import net.p3pp3rf1y.sophisticatedcore.util.ItemStackHelper;
import org.jspecify.annotations.Nullable;

public class FilterLogic {
    protected final ItemStack upgrade;
    protected final Consumer<ItemStack> saveHandler;
    protected final DeferredHolder<DataComponentType<?>, DataComponentType<FilterAttributes>> filterAttributesComponent;
    private final int defaultFilterSlotCount;
    private final Predicate<ItemStack> isItemValid;
    protected @Nullable Set<TagKey<Item>> tagKeys = null;
    private ObservableFilterItemStackHandler filterHandler = null;
    private boolean emptyAllowListMatchesEverything = false;
    private boolean allowListDefault = false;
    private @Nullable FilterAttributes emptyAttributes = null;

    public FilterLogic(ItemStack upgrade, Consumer<ItemStack> saveHandler, int defaultFilterSlotCount, DeferredHolder<DataComponentType<?>, DataComponentType<FilterAttributes>> filterAttributesComponent) {
        this(upgrade, saveHandler, defaultFilterSlotCount, s -> true, filterAttributesComponent);
    }

    public FilterLogic(ItemStack upgrade, Consumer<ItemStack> saveHandler, int defaultFilterSlotCount, Predicate<ItemStack> isItemValid, DeferredHolder<DataComponentType<?>, DataComponentType<FilterAttributes>> filterAttributesComponent) {
        this.upgrade = upgrade;
        this.saveHandler = saveHandler;
        this.filterAttributesComponent = filterAttributesComponent;
        this.defaultFilterSlotCount = defaultFilterSlotCount;
        this.isItemValid = isItemValid;
    }

    public void setEmptyAllowListMatchesEverything() {
        this.emptyAllowListMatchesEverything = true;
    }

    public ObservableFilterItemStackHandler getFilterHandler() {
        if (this.filterHandler == null) {
            ItemContainerContents filterItemContents = this.getAttributes().filterItems();
            NonNullList filterItems = NonNullList.withSize((int)filterItemContents.getSlots(), (Object)ItemStack.EMPTY);
            filterItemContents.copyInto(filterItems);
            int filterSlotCount = Math.max(filterItems.size(), this.defaultFilterSlotCount);
            this.filterHandler = new ObservableFilterItemStackHandler(filterSlotCount);
            this.filterHandler.initFilters((List<ItemStack>)filterItems);
        }
        return this.filterHandler;
    }

    public boolean matchesFilter(ItemStack stack) {
        return this.matchesFilter(stack.getTags(), stack.getItem(), stack.getDamageValue(), stack.isEmpty(), stack.getComponents());
    }

    protected boolean matchesFilter(Stream<TagKey<Item>> tags, Item item, int damageValue, boolean empty, DataComponentMap components) {
        if (empty) {
            return false;
        }
        if (this.isAllowList()) {
            if (this.getPrimaryMatch() == PrimaryMatch.TAGS) {
                return this.isTagMatch(tags);
            }
            return this.getFilterHandler().hasOnlyEmptyFilters() && this.emptyAllowListMatchesEverything || InventoryHelper.iterate(this.getFilterHandler(), (slot, filter) -> this.stackMatchesFilter((ItemStack)filter, item, damageValue, empty, components), () -> false, returnValue -> returnValue) != false;
        }
        if (this.getPrimaryMatch() == PrimaryMatch.TAGS) {
            return !this.isTagMatch(tags);
        }
        return this.getFilterHandler().hasOnlyEmptyFilters() || InventoryHelper.iterate(this.getFilterHandler(), (slot, filter) -> !this.stackMatchesFilter((ItemStack)filter, item, damageValue, empty, components), () -> true, returnValue -> returnValue == false) != false;
    }

    public boolean matchesFilter(ItemResource resource) {
        return this.matchesFilter(resource.getItem().builtInRegistryHolder().tags(), resource.getItem(), (Integer)resource.getOrDefault(DataComponents.DAMAGE, (Object)0), resource.isEmpty(), resource.getComponents());
    }

    private boolean isTagMatch(Stream<TagKey<Item>> tags) {
        if (this.shouldMatchAnyTag()) {
            return this.anyTagMatches(tags);
        }
        return this.allTagsMatch(tags);
    }

    private boolean allTagsMatch(Stream<TagKey<Item>> tagsStream) {
        if (this.tagKeys == null) {
            this.initTags();
        }
        Set tags = tagsStream.collect(Collectors.toSet());
        for (TagKey<Item> tagName : this.tagKeys) {
            if (tags.contains(tagName)) continue;
            return false;
        }
        return true;
    }

    private boolean anyTagMatches(Stream<TagKey<Item>> tags) {
        if (this.tagKeys == null) {
            this.initTags();
        }
        return tags.anyMatch(t -> this.tagKeys.contains(t));
    }

    protected FilterAttributes getAttributes() {
        return (FilterAttributes)this.upgrade.getOrDefault(this.filterAttributesComponent, (Object)this.getEmptyAttributes());
    }

    private FilterAttributes getEmptyAttributes() {
        if (this.emptyAttributes == null) {
            this.emptyAttributes = new FilterAttributes(Collections.emptySet(), this.allowListDefault, false, false, PrimaryMatch.ITEM, true, ItemContainerContents.EMPTY, false, false);
        }
        return this.emptyAttributes;
    }

    protected void setAttributes(Function<FilterAttributes, FilterAttributes> setter) {
        this.upgrade.set(this.filterAttributesComponent, (Object)setter.apply(this.getAttributes()));
    }

    public void setAllowByDefault(boolean allowListDefault) {
        this.allowListDefault = allowListDefault;
    }

    protected void save() {
        this.saveHandler.accept(this.upgrade);
    }

    public boolean stackMatchesFilter(ItemStack filter, Item item, int damageValue, boolean isEmpty, DataComponentMap components) {
        if (filter.isEmpty()) {
            return false;
        }
        PrimaryMatch primaryMatch = this.getPrimaryMatch();
        if (primaryMatch == PrimaryMatch.MOD ? !BuiltInRegistries.ITEM.getKey((Object)item).getNamespace().equals(BuiltInRegistries.ITEM.getKey((Object)filter.getItem()).getNamespace()) : primaryMatch == PrimaryMatch.ITEM && item != filter.getItem()) {
            return false;
        }
        if (this.shouldMatchDurability() && damageValue != filter.getDamageValue()) {
            return false;
        }
        return !this.shouldMatchComponents() || ItemStackHelper.areItemStackComponentsEqualIgnoreDurability(filter.isEmpty(), filter.getComponents(), isEmpty, components);
    }

    public Set<TagKey<Item>> getTagKeys() {
        if (this.tagKeys == null) {
            this.initTags();
        }
        return Collections.unmodifiableSet(this.tagKeys);
    }

    public void addTag(TagKey<Item> tagName) {
        if (this.tagKeys == null) {
            this.initTags();
        }
        this.tagKeys.add(tagName);
        this.serializeTags();
        this.save();
    }

    private void serializeTags() {
        if (this.tagKeys == null) {
            return;
        }
        this.setAttributes(contents -> contents.setTagKeys(this.tagKeys));
    }

    public void removeTagName(TagKey<Item> tagName) {
        if (this.tagKeys == null) {
            this.initTags();
        }
        this.tagKeys.remove(tagName);
        this.serializeTags();
        this.save();
    }

    protected void initTags() {
        this.tagKeys = new TreeSet<TagKey>(Comparator.comparing(TagKey::location));
        this.tagKeys.addAll(this.getAttributes().tagKeys());
    }

    public void setAllowList(boolean isAllowList) {
        this.setAttributes(contents -> contents.setAllowList(isAllowList));
        this.save();
    }

    public boolean isAllowList() {
        return this.getAttributes().isAllowList();
    }

    public boolean shouldMatchDurability() {
        return this.getAttributes().matchDurability();
    }

    public void setMatchDurability(boolean matchDurability) {
        this.setAttributes(contents -> contents.setMatchDurability(matchDurability));
        this.save();
    }

    public void setMatchComponents(boolean matchComponents) {
        this.setAttributes(contents -> contents.setMatchComponents(matchComponents));
        this.save();
    }

    public boolean shouldMatchComponents() {
        return this.getAttributes().matchComponents();
    }

    public void setPrimaryMatch(PrimaryMatch primaryMatch) {
        this.setAttributes(contents -> contents.setPrimaryMatch(primaryMatch));
        this.save();
    }

    public PrimaryMatch getPrimaryMatch() {
        return this.getAttributes().primaryMatch();
    }

    public boolean shouldMatchAnyTag() {
        return this.getAttributes().matchAnyTag();
    }

    public void setMatchAnyTag(boolean matchAnyTag) {
        this.setAttributes(contents -> contents.setMatchAnyTag(matchAnyTag));
        this.save();
    }

    public DeferredHolder<DataComponentType<?>, DataComponentType<FilterAttributes>> getAttributesComponent() {
        return this.filterAttributesComponent;
    }

    public class ObservableFilterItemStackHandler
    extends FilterItemStackHandler {
        private IntConsumer onSlotChange;

        public ObservableFilterItemStackHandler(int filterSlotCount) {
            super(filterSlotCount);
            this.onSlotChange = s -> {};
        }

        @Override
        protected void onContentsChanged(int slot, ItemStack previousContents) {
            super.onContentsChanged(slot, previousContents);
            FilterLogic.this.setAttributes(contents -> contents.setFilterItem(slot, (ItemStack)this.stacks.get(slot)));
            FilterLogic.this.save();
            this.onSlotChange.accept(slot);
        }

        public void setOnSlotChange(IntConsumer onSlotChange) {
            this.onSlotChange = onSlotChange;
        }

        public boolean isValid(int slot, ItemResource resource) {
            return resource.isEmpty() || this.doesNotContain(resource) && FilterLogic.this.isItemValid.test(resource.toStack());
        }

        private boolean doesNotContain(ItemResource resource) {
            return !InventoryHelper.hasItem((ResourceHandler<ItemResource>)this, s -> s.equals((Object)resource));
        }

        public void initFilters(List<ItemStack> filterItems) {
            for (int slot = 0; slot < filterItems.size(); ++slot) {
                ItemStack filterStack = filterItems.get(slot);
                if (filterStack.isEmpty()) continue;
                this.set(slot, (Resource)ItemResource.of((ItemStack)filterStack), 1);
            }
            this.updateEmptyFilters();
        }
    }
}

