/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades.pump;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.fluid.FluidResource;
import net.neoforged.neoforge.transfer.fluid.FluidUtil;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.neoforged.neoforge.transfer.transaction.Transaction;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.init.ModCoreDataComponents;
import net.p3pp3rf1y.sophisticatedcore.upgrades.ITickableUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeWrapperBase;
import net.p3pp3rf1y.sophisticatedcore.upgrades.pump.FluidFilterLogic;
import net.p3pp3rf1y.sophisticatedcore.upgrades.pump.PumpUpgradeConfig;
import net.p3pp3rf1y.sophisticatedcore.upgrades.pump.PumpUpgradeItem;
import net.p3pp3rf1y.sophisticatedcore.util.CapabilityHelper;
import net.p3pp3rf1y.sophisticatedcore.util.MutableStackItemAccess;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;
import org.jspecify.annotations.Nullable;

public class PumpUpgradeWrapper
extends UpgradeWrapperBase<PumpUpgradeWrapper, PumpUpgradeItem>
implements ITickableUpgrade {
    private static final int DID_NOTHING_COOLDOWN_TIME = 40;
    private static final int HAND_INTERACTION_COOLDOWN_TIME = 3;
    private static final int WORLD_INTERACTION_COOLDOWN_TIME = 20;
    private static final int FLUID_HANDLER_INTERACTION_COOLDOWN_TIME = 20;
    private static final int PLAYER_SEARCH_RANGE = 3;
    private static final int PUMP_IN_WORLD_RANGE = 4;
    private static final int PUMP_IN_WORLD_RANGE_SQR = 16;
    private long lastHandActionTime = -1L;
    private final FluidFilterLogic fluidFilterLogic;
    private final PumpUpgradeConfig pumpUpgradeConfig = ((PumpUpgradeItem)this.upgradeItem).getPumpUpgradeConfig();

    protected PumpUpgradeWrapper(IStorageWrapper storageWrapper, ItemStack upgrade, Consumer<ItemStack> upgradeSaveHandler) {
        super(storageWrapper, upgrade, upgradeSaveHandler);
        this.fluidFilterLogic = new FluidFilterLogic((Integer)this.pumpUpgradeConfig.filterSlots.get(), upgrade, upgradeSaveHandler);
    }

    @Override
    public void tick(@Nullable Entity entity, Level level, BlockPos pos) {
        if (this.isInCooldown(level)) {
            return;
        }
        this.setCooldown(level, this.storageWrapper.getFluidHandler().map(storageFluidHandler -> this.tick((ResourceHandler<FluidResource>)storageFluidHandler, entity, level, pos)).orElse(40));
    }

    private int tick(ResourceHandler<FluidResource> storageFluidHandler, @Nullable Entity entity, Level level, BlockPos pos) {
        if (this.shouldInteractWithHand()) {
            if (entity instanceof Player) {
                Player player = (Player)entity;
                if (this.handleFluidContainerInHands(player, storageFluidHandler)) {
                    this.lastHandActionTime = level.getGameTime();
                    return 3;
                }
            } else if (this.handleFluidContainersInHandsOfNearbyPlayers(level, pos, storageFluidHandler)) {
                this.lastHandActionTime = level.getGameTime();
                return 3;
            }
        }
        return this.handleInWorldInteractions(storageFluidHandler, entity, level, pos).orElseGet(() -> this.lastHandActionTime + 30L > level.getGameTime() ? 3 : 40);
    }

    private Optional<Integer> handleInWorldInteractions(ResourceHandler<FluidResource> storageFluidHandler, @Nullable Entity entity, Level level, BlockPos pos) {
        Optional<Integer> newCooldown;
        if (this.shouldInteractWithWorld() && (newCooldown = this.interactWithWorld(level, pos, storageFluidHandler, entity)).isPresent()) {
            return newCooldown;
        }
        if (this.shouldInteractWithFluidHandlers()) {
            return this.interactWithAttachedFluidHandlers(level, pos, storageFluidHandler);
        }
        return Optional.empty();
    }

    private Optional<Integer> interactWithAttachedFluidHandlers(Level level, BlockPos pos, ResourceHandler<FluidResource> storageFluidHandler) {
        for (Direction dir : Direction.values()) {
            boolean successful = WorldHelper.getBlockEntity((BlockGetter)level, pos.offset(dir.getUnitVec3i())).map(be -> CapabilityHelper.getFromFluidHandler(be, dir.getOpposite(), fluidHandler -> {
                if (this.isInput()) {
                    return this.tryFluidTransfer((ResourceHandler<FluidResource>)fluidHandler, storageFluidHandler, this.getMaxInOut());
                }
                return this.tryFluidTransfer(storageFluidHandler, (ResourceHandler<FluidResource>)fluidHandler, this.getMaxInOut());
            }, false)).orElse(false);
            if (!successful) continue;
            return Optional.of(20);
        }
        return Optional.empty();
    }

    private int getMaxInOut() {
        return Math.max(1000, (Integer)this.pumpUpgradeConfig.maxInputOutput.get() * this.storageWrapper.getNumberOfSlotRows() * this.getAdjustedStackMultiplier(this.storageWrapper));
    }

    public int getAdjustedStackMultiplier(IStorageWrapper storageWrapper) {
        return 1 + (int)((Double)this.pumpUpgradeConfig.stackMultiplierRatio.get() * (storageWrapper.getInventoryHandler().getStackSizeMultiplier() - 1.0));
    }

    private Optional<Integer> interactWithWorld(Level level, BlockPos pos, ResourceHandler<FluidResource> storageFluidHandler, @Nullable Entity entity) {
        if (this.isInput()) {
            return this.fillFromBlockInRange(level, pos, storageFluidHandler, entity);
        }
        for (Direction dir : Direction.values()) {
            BlockPos offsetPos = pos.offset(dir.getUnitVec3i());
            if (!this.placeFluidInWorld(level, storageFluidHandler, dir, offsetPos)) continue;
            return Optional.of(20);
        }
        return Optional.empty();
    }

    private boolean placeFluidInWorld(Level level, ResourceHandler<FluidResource> storageFluidHandler, Direction dir, BlockPos offsetPos) {
        if (dir != Direction.UP) {
            try (Transaction tx = Transaction.openRoot();){
                for (int tank = 0; tank < storageFluidHandler.size(); ++tank) {
                    FluidResource tankFluid = (FluidResource)storageFluidHandler.getResource(tank);
                    if (tankFluid.isEmpty() || !this.fluidFilterLogic.fluidMatches(tankFluid) || !this.isValidForFluidPlacement(level, offsetPos) || storageFluidHandler.extract((Resource)tankFluid, 1000, (TransactionContext)tx) != 1000 || !FluidUtil.tryPlaceFluid((FluidResource)tankFluid, null, (Level)level, (InteractionHand)InteractionHand.MAIN_HAND, (BlockPos)offsetPos)) continue;
                    tx.commit();
                    boolean bl = true;
                    return bl;
                }
            }
        }
        return false;
    }

    private boolean isValidForFluidPlacement(Level level, BlockPos offsetPos) {
        BlockState blockState = level.getBlockState(offsetPos);
        return blockState.isAir() || !blockState.getFluidState().isEmpty() && !blockState.getFluidState().isSource();
    }

    private Optional<Integer> fillFromBlockInRange(Level level, BlockPos basePos, ResourceHandler<FluidResource> storageFluidHandler, @Nullable Entity entity) {
        LinkedList<BlockPos> nextPositions = new LinkedList<BlockPos>();
        HashSet<BlockPos> searchedPositions = new HashSet<BlockPos>();
        nextPositions.add(basePos);
        while (!nextPositions.isEmpty()) {
            BlockPos pos = (BlockPos)nextPositions.poll();
            if (this.fillFromBlock(level, pos, storageFluidHandler, entity)) {
                return Optional.of((int)(Math.max(1.0, Math.sqrt(basePos.distSqr((Vec3i)pos))) * 20.0));
            }
            for (Direction dir : Direction.values()) {
                BlockPos offsetPos = pos.offset(dir.getUnitVec3i());
                if (searchedPositions.contains(offsetPos)) continue;
                searchedPositions.add(offsetPos);
                if (!(basePos.distSqr((Vec3i)offsetPos) < 16.0)) continue;
                nextPositions.add(offsetPos);
            }
        }
        return Optional.empty();
    }

    private boolean fillFromBlock(Level level, BlockPos pos, ResourceHandler<FluidResource> storageFluidHandler, @Nullable Entity entity) {
        FluidState fluidState = level.getFluidState(pos);
        if (!fluidState.isEmpty()) {
            BlockState state = level.getBlockState(pos);
            Block block = state.getBlock();
            if (block instanceof BucketPickup) {
                BucketPickup bucketPickup = (BucketPickup)block;
                return PumpUpgradeWrapper.pickupBlock(level, pos, storageFluidHandler, bucketPickup, fluidState, state);
            }
            ResourceHandler fluidHandler = (ResourceHandler)level.getCapability(Capabilities.Fluid.BLOCK, pos, null);
            if (fluidHandler == null) {
                return false;
            }
            return this.tryFluidTransfer((ResourceHandler<FluidResource>)fluidHandler, storageFluidHandler);
        }
        return false;
    }

    private static boolean pickupBlock(Level level, BlockPos pos, ResourceHandler<FluidResource> storageFluidHandler, BucketPickup bucketPickup, FluidState fluidState, BlockState state) {
        Fluid fluid = fluidState.getType();
        try (Transaction tx = Transaction.openRoot();){
            if (storageFluidHandler.insert((Resource)FluidResource.of((Fluid)fluid), 1000, (TransactionContext)tx) == 1000) {
                bucketPickup.pickupBlock(null, (LevelAccessor)level, pos, state);
                tx.commit();
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    private boolean handleFluidContainersInHandsOfNearbyPlayers(Level level, BlockPos pos, ResourceHandler<FluidResource> storageFluidHandler) {
        AABB searchBox = new AABB(pos).inflate(3.0);
        for (Player player : level.players()) {
            if (!searchBox.contains(player.getX(), player.getY(), player.getZ()) || !this.handleFluidContainerInHands(player, storageFluidHandler)) continue;
            return true;
        }
        return false;
    }

    private boolean handleFluidContainerInHands(Player player, ResourceHandler<FluidResource> storageFluidHandler) {
        return this.handleFluidContainerInHand(storageFluidHandler, player, InteractionHand.MAIN_HAND) || this.handleFluidContainerInHand(storageFluidHandler, player, InteractionHand.OFF_HAND);
    }

    private boolean handleFluidContainerInHand(ResourceHandler<FluidResource> storageFluidHandler, Player player, InteractionHand hand) {
        ItemStack itemInHand = player.getItemInHand(hand);
        if (itemInHand.getCount() != 1 || itemInHand == this.storageWrapper.getWrappedStorageStack()) {
            return false;
        }
        MutableStackItemAccess itemAccess = new MutableStackItemAccess(itemInHand);
        return CapabilityHelper.getFromFluidHandler(itemAccess, itemFluidHandler -> {
            if (this.isInput()) {
                if (this.tryFluidTransfer((ResourceHandler<FluidResource>)itemFluidHandler, storageFluidHandler)) {
                    player.setItemInHand(hand, itemAccess.getStack());
                    return true;
                }
                return false;
            }
            if (this.tryFluidTransfer(storageFluidHandler, (ResourceHandler<FluidResource>)itemFluidHandler)) {
                player.setItemInHand(hand, itemAccess.getStack());
                return true;
            }
            return false;
        }, false);
    }

    private boolean tryFluidTransfer(ResourceHandler<FluidResource> fluidHandler, ResourceHandler<FluidResource> storageFluidHandler) {
        return this.tryFluidTransfer(fluidHandler, storageFluidHandler, 1000);
    }

    private boolean tryFluidTransfer(ResourceHandler<FluidResource> source, ResourceHandler<FluidResource> target, int maxDrain) {
        for (int i = 0; i < source.size(); ++i) {
            FluidResource sourceFluid = (FluidResource)source.getResource(i);
            if (sourceFluid.isEmpty() || !this.fluidFilterLogic.fluidMatches(sourceFluid)) continue;
            try (Transaction tx = Transaction.openRoot();){
                int inserted = target.insert((Resource)sourceFluid, Math.min(maxDrain, source.getAmountAsInt(i)), (TransactionContext)tx);
                if (inserted <= 0 || source.extract((Resource)sourceFluid, inserted, (TransactionContext)tx) != inserted) continue;
                tx.commit();
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    public void setIsInput(boolean input) {
        this.upgrade.set(ModCoreDataComponents.IS_INPUT, (Object)input);
        this.save();
    }

    public boolean isInput() {
        return (Boolean)this.upgrade.getOrDefault(ModCoreDataComponents.IS_INPUT, (Object)true);
    }

    public FluidFilterLogic getFluidFilterLogic() {
        return this.fluidFilterLogic;
    }

    public void setInteractWithHand(boolean interactWithHand) {
        this.upgrade.set(ModCoreDataComponents.INTERACT_WITH_HAND, (Object)interactWithHand);
        this.save();
    }

    public boolean shouldInteractWithHand() {
        return (Boolean)this.upgrade.getOrDefault(ModCoreDataComponents.INTERACT_WITH_HAND, (Object)((PumpUpgradeItem)this.upgradeItem).getInteractWithHandDefault());
    }

    public void setInteractWithWorld(boolean interactWithWorld) {
        this.upgrade.set(ModCoreDataComponents.INTERACT_WITH_WORLD, (Object)interactWithWorld);
        this.save();
    }

    public boolean shouldInteractWithWorld() {
        return (Boolean)this.upgrade.getOrDefault(ModCoreDataComponents.INTERACT_WITH_WORLD, (Object)((PumpUpgradeItem)this.upgradeItem).getInteractWithWorldDefault());
    }

    public void setInteractWithFluidHandlers(boolean interactWithFluidHandlers) {
        this.upgrade.set(ModCoreDataComponents.INTERACT_WITH_FLUID_HANDLERS, (Object)interactWithFluidHandlers);
        this.save();
    }

    public boolean shouldInteractWithFluidHandlers() {
        return (Boolean)this.upgrade.getOrDefault(ModCoreDataComponents.INTERACT_WITH_FLUID_HANDLERS, (Object)((PumpUpgradeItem)this.upgradeItem).getInteractWithFluidHandlersDefault());
    }
}

