/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.PrimitiveCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.p3pp3rf1y.sophisticatedcore.util.SetCodec;

public class CodecHelper {
    public static final Codec<ItemStack> OVERSIZED_ITEM_STACK_CODEC = Codec.lazyInitialized(() -> RecordCodecBuilder.create(instance -> instance.group((App)Item.CODEC.fieldOf("id").forGetter(ItemStack::getItemHolder), (App)Codec.INT.fieldOf("count").orElse((Object)1).forGetter(ItemStack::getCount), (App)DataComponentPatch.CODEC.optionalFieldOf("components", (Object)DataComponentPatch.EMPTY).forGetter(p_330103_ -> p_330103_.components.asPatch())).apply((Applicative)instance, ItemStack::new)));
    public static final Codec<ItemStack> OPTIONAL_OVERSIZED_ITEM_STACK_CODEC = ExtraCodecs.optionalEmptyMap(OVERSIZED_ITEM_STACK_CODEC).xmap(optional -> optional.orElse(ItemStack.EMPTY), stack -> stack.isEmpty() ? Optional.empty() : Optional.of(stack)).orElse((Object)ItemStack.EMPTY);
    public static final Codec<ItemContainerContents.Slot> LENIENT_CONTENTS_SLOT_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.intRange((int)0, (int)255).fieldOf("slot").forGetter(ItemContainerContents.Slot::index), (App)ItemStack.CODEC.lenientOptionalFieldOf("item", (Object)ItemStack.EMPTY).forGetter(ItemContainerContents.Slot::item)).apply((Applicative)instance, ItemContainerContents.Slot::new));
    public static Codec<ItemContainerContents> LENIENT_ITEM_CONTAINER_CONTENTS_CODEC = LENIENT_CONTENTS_SLOT_CODEC.sizeLimitedListOf(256).xmap(ItemContainerContents::fromSlots, ItemContainerContents::asSlots);
    public static final Codec<UUID> STRING_ENCODED_UUID = Codec.STRING.xmap(UUID::fromString, UUID::toString);
    public static final PrimitiveCodec<Integer> STRING_ENCODED_INT = new PrimitiveCodec<Integer>(){

        public <T> DataResult<Integer> read(DynamicOps<T> ops, T input) {
            return ops.getStringValue(input).map(s -> {
                if (s.startsWith("i")) {
                    return Integer.parseInt(s.substring(1));
                }
                return Integer.parseInt(s);
            });
        }

        public <T> T write(DynamicOps<T> ops, Integer value) {
            return (T)ops.createString("i" + value);
        }

        public String toString() {
            return "Int";
        }
    };

    private CodecHelper() {
    }

    public static <T> Codec<Set<T>> setOf(Codec<T> elementCodec) {
        return new SetCodec<T>(elementCodec);
    }

    public static <T> List<T> toMutable(List<T> list) {
        return new ArrayList<T>(list);
    }

    public static NonNullList<ItemStack> toMutableNonnullItemStackList(List<ItemStack> list) {
        return CodecHelper.toMutableNonnull(list, ItemStack.EMPTY);
    }

    public static <T> NonNullList<T> toMutableNonnull(List<T> list, T defaultElement) {
        NonNullList nonNullList = NonNullList.withSize((int)list.size(), defaultElement);
        for (int i = 0; i < list.size(); ++i) {
            nonNullList.set(i, list.get(i));
        }
        return nonNullList;
    }

    public static <K, V> Map<K, V> toMutable(Map<K, V> map) {
        return new HashMap<K, V>(map);
    }
}

