/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.util;

import java.util.Objects;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.ValueInput;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.item.ItemStacksResourceHandler;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;
import net.p3pp3rf1y.sophisticatedcore.inventory.ISlotStackAccessor;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;

public class FilterItemStackHandler
extends ItemStacksResourceHandler
implements ISlotStackAccessor {
    private boolean onlyEmptyFilters = true;

    public FilterItemStackHandler(int size) {
        super(size);
    }

    protected int getCapacity(int index, ItemResource resource) {
        return 1;
    }

    public int extract(int index, ItemResource resource, int amount, TransactionContext transaction) {
        return 0;
    }

    public int insert(int index, ItemResource resource, int amount, TransactionContext transaction) {
        return 0;
    }

    protected void onContentsChanged(int slot, ItemStack previousContents) {
        super.onContentsChanged(slot, (Object)previousContents);
        this.updateEmptyFilters();
    }

    public void deserialize(ValueInput input) {
        super.deserialize(input);
        this.updateEmptyFilters();
    }

    protected void updateEmptyFilters() {
        this.onlyEmptyFilters = InventoryHelper.iterate(this, (s, filter) -> filter.isEmpty(), () -> true, result -> result == false);
    }

    public boolean hasOnlyEmptyFilters() {
        return this.onlyEmptyFilters;
    }

    @Override
    public ItemStack getStackInSlot(int slot) {
        Objects.checkIndex(slot, this.size());
        return (ItemStack)this.stacks.get(slot);
    }

    @Override
    public void setStackInSlot(int slot, ItemStack stack) {
        Objects.checkIndex(slot, this.size());
        this.stacks.set(slot, (Object)stack);
        this.onContentsChanged(slot, stack);
    }
}

