/*
 * Decompiled with CFR 0.152.
 */
package baguchi.hunters_return.client.model;

import baguchi.hunters_return.client.animation.HunterAnimations;
import baguchi.hunters_return.client.model.HunterModel;
import baguchi.hunters_return.client.render.state.HunterRenderState;
import net.minecraft.client.animation.KeyframeAnimation;
import net.minecraft.client.model.AnimationUtils;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.monster.illager.AbstractIllager;

public class NewHunterModel<T extends HunterRenderState>
extends HunterModel<T> {
    private final KeyframeAnimation walkAnimation;
    private final KeyframeAnimation walkRightAttackAnimation;
    private final KeyframeAnimation walkLeftAttackAnimation;
    private final KeyframeAnimation shootRightAnimation;
    private final KeyframeAnimation shootLeftAnimation;
    private final KeyframeAnimation chargeRightAnimation;
    private final KeyframeAnimation chargeLeftAnimation;
    private final KeyframeAnimation thrownRightAnimation;
    private final KeyframeAnimation thrownLeftAnimation;
    private final KeyframeAnimation attackRightAnimation;
    private final KeyframeAnimation attackLeftAnimation;
    public final ModelPart body;
    public final ModelPart everything;
    private final ModelPart LeftLeg;
    private final ModelPart RightLeg;
    private final ModelPart RightArm;
    private final ModelPart LeftArm;
    private final ModelPart root;
    public final ModelPart head;
    private final ModelPart nose;
    private final ModelPart cape;
    private final ModelPart rightEye;
    private final ModelPart leftEye;

    public NewHunterModel(ModelPart root) {
        super(root);
        this.root = root;
        this.everything = root.getChild("everything");
        this.body = this.everything.getChild("body");
        this.cape = this.body.getChild("cape");
        this.LeftLeg = this.everything.getChild("left_leg");
        this.RightLeg = this.everything.getChild("right_leg");
        this.RightArm = this.body.getChild("right_arm");
        this.LeftArm = this.body.getChild("left_arm");
        this.head = this.body.getChild("head");
        this.rightEye = this.head.getChild("rightEye");
        this.leftEye = this.head.getChild("leftEye");
        this.nose = this.head.getChild("nose");
        this.walkAnimation = HunterAnimations.walk.bake(root);
        this.walkRightAttackAnimation = HunterAnimations.right_walk_attack.bake(root);
        this.walkLeftAttackAnimation = HunterAnimations.left_walk_attack.bake(root);
        this.shootRightAnimation = HunterAnimations.right_shot.bake(root);
        this.shootLeftAnimation = HunterAnimations.left_shot.bake(root);
        this.chargeRightAnimation = HunterAnimations.right_attack_range_charge.bake(root);
        this.chargeLeftAnimation = HunterAnimations.left_attack_range_charge.bake(root);
        this.thrownRightAnimation = HunterAnimations.right_attack_melee.bake(root);
        this.thrownLeftAnimation = HunterAnimations.left_attack_melee.bake(root);
        this.attackRightAnimation = HunterAnimations.right_attack_melee.bake(root);
        this.attackLeftAnimation = HunterAnimations.left_attack_melee.bake(root);
    }

    @Override
    public void setupAnim(T entityIn) {
        this.rightArmPose = HumanoidModel.ArmPose.EMPTY;
        this.leftArmPose = HumanoidModel.ArmPose.EMPTY;
        AbstractIllager.IllagerArmPose abstractillager$illagerarmpose = ((HunterRenderState)((Object)entityIn)).armPose;
        super.setupAnim(entityIn);
        this.head.yRot = ((HunterRenderState)((Object)entityIn)).yRot * ((float)Math.PI / 180);
        this.head.xRot = ((HunterRenderState)((Object)entityIn)).xRot * ((float)Math.PI / 180);
        if (((HunterRenderState)((Object)entityIn)).isRiding) {
            this.RightArm.xRot = -0.62831855f;
            this.RightArm.yRot = 0.0f;
            this.RightArm.zRot = 0.0f;
            this.LeftArm.xRot = -0.62831855f;
            this.LeftArm.yRot = 0.0f;
            this.LeftArm.zRot = 0.0f;
            this.RightLeg.xRot = -1.4137167f;
            this.RightLeg.yRot = 0.31415927f;
            this.RightLeg.zRot = 0.07853982f;
            this.LeftLeg.xRot = -1.4137167f;
            this.LeftLeg.yRot = -0.31415927f;
            this.LeftLeg.zRot = -0.07853982f;
        } else if (!((HunterRenderState)((Object)entityIn)).dodghRightAnimationState.isStarted() && !((HunterRenderState)((Object)entityIn)).dodghLeftAnimationState.isStarted()) {
            if (((HunterRenderState)((Object)entityIn)).chargeAnimationState.isStarted()) {
                if (((HunterRenderState)((Object)entityIn)).mainArm == HumanoidArm.RIGHT) {
                    this.walkRightAttackAnimation.applyWalk(((HunterRenderState)((Object)entityIn)).walkAnimationPos, ((HunterRenderState)((Object)entityIn)).walkAnimationSpeed, 1.0f, 1.5f);
                } else {
                    this.walkLeftAttackAnimation.applyWalk(((HunterRenderState)((Object)entityIn)).walkAnimationPos, ((HunterRenderState)((Object)entityIn)).walkAnimationSpeed, 1.0f, 1.5f);
                }
            } else if (!((HunterRenderState)((Object)entityIn)).sleep) {
                this.walkAnimation.applyWalk(((HunterRenderState)((Object)entityIn)).walkAnimationPos, ((HunterRenderState)((Object)entityIn)).walkAnimationSpeed, 1.0f, 1.5f);
            }
        } else {
            this.dodghRightAnimation.apply(((HunterRenderState)((Object)entityIn)).dodghRightAnimationState, ((HunterRenderState)((Object)entityIn)).ageInTicks);
            this.dodghLeftAnimation.apply(((HunterRenderState)((Object)entityIn)).dodghLeftAnimationState, ((HunterRenderState)((Object)entityIn)).ageInTicks);
        }
        if (abstractillager$illagerarmpose == AbstractIllager.IllagerArmPose.CROSSBOW_HOLD) {
            AnimationUtils.animateCrossbowHold((ModelPart)this.RightArm, (ModelPart)this.LeftArm, (ModelPart)this.head, (boolean)true);
        } else if (abstractillager$illagerarmpose == AbstractIllager.IllagerArmPose.CROSSBOW_CHARGE) {
            AnimationUtils.animateCrossbowCharge((ModelPart)this.RightArm, (ModelPart)this.LeftArm, (float)((HunterRenderState)((Object)entityIn)).ageInTicks, (float)((HunterRenderState)((Object)entityIn)).maxCrossbowChargeDuration, (boolean)true);
        } else if (((HunterRenderState)((Object)entityIn)).mainArm == HumanoidArm.RIGHT) {
            this.shootRightAnimation.apply(((HunterRenderState)((Object)entityIn)).shootAnimationState, ((HunterRenderState)((Object)entityIn)).ageInTicks);
            this.chargeRightAnimation.apply(((HunterRenderState)((Object)entityIn)).chargeAnimationState, ((HunterRenderState)((Object)entityIn)).ageInTicks);
            this.attackRightAnimation.apply(((HunterRenderState)((Object)entityIn)).attackAnimationState, ((HunterRenderState)((Object)entityIn)).ageInTicks, 1.5f);
            this.thrownRightAnimation.apply(((HunterRenderState)((Object)entityIn)).thrownAnimationState, ((HunterRenderState)((Object)entityIn)).ageInTicks);
        } else {
            this.shootLeftAnimation.apply(((HunterRenderState)((Object)entityIn)).shootAnimationState, ((HunterRenderState)((Object)entityIn)).ageInTicks);
            this.chargeLeftAnimation.apply(((HunterRenderState)((Object)entityIn)).chargeAnimationState, ((HunterRenderState)((Object)entityIn)).ageInTicks);
            this.attackLeftAnimation.apply(((HunterRenderState)((Object)entityIn)).attackAnimationState, ((HunterRenderState)((Object)entityIn)).ageInTicks, 1.5f);
            this.thrownLeftAnimation.apply(((HunterRenderState)((Object)entityIn)).thrownAnimationState, ((HunterRenderState)((Object)entityIn)).ageInTicks);
        }
        float f3 = ((HunterRenderState)((Object)entityIn)).ageInTicks + (float)((HunterRenderState)((Object)entityIn)).id;
        this.rightEye.visible = !((HunterRenderState)((Object)entityIn)).sleep && !(0.0 > Math.sin(f3 * 0.05f) + Math.sin(f3 * 0.13f) + Math.sin(f3 * 0.7f) + (double)2.55f);
        this.leftEye.visible = !((HunterRenderState)((Object)entityIn)).sleep && !(0.0 > Math.sin(f3 * 0.05f) + Math.sin(f3 * 0.13f) + Math.sin(f3 * 0.7f) + (double)2.55f);
        this.rightEye.x -= Mth.clamp((float)((((HunterRenderState)((Object)entityIn)).eyeRot % 360.0f - 180.0f) / 90.0f), (float)0.0f, (float)0.5f);
        this.leftEye.x -= Mth.clamp((float)((((HunterRenderState)((Object)entityIn)).eyeRot % 360.0f - 180.0f) / 90.0f), (float)-0.5f, (float)0.0f);
        if (!((HunterRenderState)((Object)entityIn)).mouthItem.isEmpty()) {
            this.nose.xRot = -0.5f;
        }
    }
}

